/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.util.BufferUtils;
import org.limewire.util.ByteUtils;

public abstract class RUDPMessageImpl
implements RUDPMessage {
    protected static final int MAX_DATA1_SIZE = 12;
    protected static byte[] emptyByteArray = new byte[16];
    protected final byte _connectionID;
    protected final RUDPMessage.OpCode _opcode;
    protected long _sequenceNumber;
    protected final ByteBuffer _data1;
    protected final ByteBuffer _data2;

    protected RUDPMessageImpl(byte connectionID, RUDPMessage.OpCode opcode, long sequenceNumber, short d1, short d2) {
        this._connectionID = connectionID;
        this._opcode = opcode;
        this._sequenceNumber = sequenceNumber;
        this._data1 = ByteBuffer.allocate(4);
        this._data1.order(ByteOrder.BIG_ENDIAN);
        this._data1.putShort(d1);
        this._data1.putShort(d2);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte connectionID, RUDPMessage.OpCode opcode, long sequenceNumber, byte b) {
        this._connectionID = connectionID;
        this._opcode = opcode;
        this._sequenceNumber = sequenceNumber;
        this._data1 = ByteBuffer.allocate(1);
        this._data1.put(b);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte connectionID, RUDPMessage.OpCode opcode, long sequenceNumber, byte b, short d) {
        this._connectionID = connectionID;
        this._opcode = opcode;
        this._sequenceNumber = sequenceNumber;
        this._data1 = ByteBuffer.allocate(3);
        this._data1.order(ByteOrder.BIG_ENDIAN);
        this._data1.put(b);
        this._data1.putShort(d);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte connectionID, RUDPMessage.OpCode opcode, long sequenceNumber, byte[] data) {
        this(connectionID, opcode, sequenceNumber, data, data.length);
    }

    protected RUDPMessageImpl(byte connectionID, RUDPMessage.OpCode opcode, long sequenceNumber, byte[] data, int datalength) {
        this._connectionID = connectionID;
        this._opcode = opcode;
        this._sequenceNumber = sequenceNumber;
        this._data1 = datalength > 0 ? ByteBuffer.wrap(data, 0, Math.min(datalength, 12)) : BufferUtils.getEmptyBuffer();
        int data2Length = Math.max(0, datalength - 12);
        this._data2 = data2Length > 0 ? ByteBuffer.wrap(data, 12, data2Length) : BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(RUDPMessage.OpCode opcode, byte connectionId, long sequenceNumber, ByteBuffer data1, ByteBuffer data2) throws MessageFormatException {
        this._opcode = opcode;
        this._connectionID = connectionId;
        this._sequenceNumber = sequenceNumber;
        this._data1 = data1;
        this._data2 = data2;
    }

    @Override
    public byte getConnectionID() {
        return this._connectionID;
    }

    @Override
    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    @Override
    public void extendSequenceNumber(long seqNo) {
        this._sequenceNumber = seqNo;
    }

    @Override
    public int getDataLength() {
        return this._data1.limit() + this._data2.limit();
    }

    @Override
    public int getLength() {
        return 23 + this._data2.limit();
    }

    @Override
    public RUDPMessage.OpCode getOpCode() {
        return this._opcode;
    }

    protected int getData1Length() {
        return 0;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        out.write(this._connectionID);
        out.write((this._opcode.toByte() & 0xF) << 4 | (byte)this.getData1Length() & 0xF);
        out.write((byte)((this._sequenceNumber & 0xFF00L) >> 8));
        out.write((byte)(this._sequenceNumber & 0xFFL));
        if (this._data1.hasRemaining()) {
            out.write(this._data1.array(), this._data1.arrayOffset() + this._data1.position(), this._data1.remaining());
        }
        if (this._data1.remaining() < 12) {
            out.write(emptyByteArray, 0, 12 - this._data1.remaining());
        }
        out.write(65);
        out.write(1);
        out.write(0);
        ByteUtils.int2leb(this._data2.remaining(), out);
        if (this._data2.hasRemaining()) {
            out.write(this._data2.array(), this._data2.arrayOffset() + this._data2.position(), this._data2.remaining());
        }
    }
}

