/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net.address;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.nio.ByteOrder;
import java.util.Set;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.net.address.AddressFactory;
import org.limewire.net.address.AddressSerializer;
import org.limewire.net.address.StrictIpPortSet;

@EagerSingleton
public class ConnectableSerializer
implements AddressSerializer {
    private static final int IP_V4 = 0;
    private static final int IP_V6 = 1;
    static final String CONNECTABLE = "CN";

    @Override
    public String getAddressType() {
        return "direct-connect";
    }

    @Override
    public boolean canSerialize(Address address) {
        return address instanceof Connectable;
    }

    @Override
    public Address deserialize(String address) throws IOException {
        if (address.indexOf(58) == -1) {
            address = address + ":6346";
        }
        return NetworkUtils.parseIpPort(address, false);
    }

    @Override
    public Connectable deserialize(byte[] serializedAddress) throws IOException {
        try {
            GGEP ggep = new GGEP(serializedAddress);
            ByteArrayInputStream in = new ByteArrayInputStream(ggep.getBytes(CONNECTABLE));
            int hostPortLength = (IOUtils.readByte(in) == 0 ? 4 : 16) + 2;
            byte[] hostPort = new byte[hostPortLength];
            IOUtils.readFully(in, hostPort);
            try {
                IpPort ipPort = NetworkUtils.getIpPort(hostPort, ByteOrder.BIG_ENDIAN);
                boolean supportsTLS = IOUtils.readByte(in) == 1;
                return new ConnectableImpl(ipPort, supportsTLS);
            }
            catch (InvalidDataException e) {
                throw new IOException(e);
            }
        }
        catch (BadGGEPBlockException e) {
            throw new IOException(e);
        }
        catch (BadGGEPPropertyException e) {
            throw new IOException(e);
        }
    }

    public Set<Connectable> deserializeSet(byte[] serializedSet) throws IOException {
        try {
            GGEP ggep = new GGEP(serializedSet);
            StrictIpPortSet<Connectable> set = new StrictIpPortSet<Connectable>();
            int i = 0;
            while (ggep.hasValueFor(CONNECTABLE + i)) {
                set.add(this.deserialize(ggep.getBytes(CONNECTABLE + i)));
                ++i;
            }
            return set;
        }
        catch (BadGGEPBlockException e) {
            throw new IOException(e);
        }
        catch (BadGGEPPropertyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] serialize(Address address) throws IOException {
        Connectable connectable = (Connectable)address;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int type = connectable.getInetAddress() instanceof Inet4Address ? 0 : 1;
        bos.write(type);
        bos.write(NetworkUtils.getBytes(connectable, ByteOrder.BIG_ENDIAN));
        bos.write(connectable.isTLSCapable() ? 1 : 0);
        GGEP ggep = new GGEP();
        ggep.put(CONNECTABLE, bos.toByteArray());
        return ggep.toByteArray();
    }

    public byte[] serialize(Set<Connectable> addresses) throws IOException {
        GGEP ggep = new GGEP();
        int i = 0;
        for (Connectable connectable : addresses) {
            ggep.put(CONNECTABLE + i, this.serialize(connectable));
            ++i;
        }
        return ggep.toByteArray();
    }

    @Override
    @Inject
    public void register(AddressFactory factory) {
        factory.registerSerializer(this);
    }
}

