/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.MemoryOptimizedIpPortImpl;
import org.limewire.util.ByteUtils;
import org.limewire.util.Decorator;

public final class NetworkUtils {
    public static final int CLASS_C_NETMASK = -256;

    private NetworkUtils() {
    }

    public static boolean isValidAddressAndPort(byte[] addr, int port) {
        return NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port);
    }

    public static boolean isValidAddressAndPort(String addr, int port) {
        return NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port);
    }

    public static boolean isValidIpPort(IpPort ipport) {
        return NetworkUtils.isValidAddress(ipport.getAddress()) && NetworkUtils.isValidPort(ipport.getPort());
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean isValidAddress(byte[] address) {
        return !NetworkUtils.isAnyLocalAddress(address) && !NetworkUtils.isInvalidAddress(address) && !NetworkUtils.isBroadcastAddress(address) && !NetworkUtils.isDocumentationAddress(address);
    }

    public static boolean isValidAddress(IP ip) {
        int msb = ip.addr >> 24 & 0xFF;
        return msb != 0 && msb != 255;
    }

    public static boolean isValidAddress(InetAddress address) {
        return !address.isAnyLocalAddress() && !NetworkUtils.isInvalidAddress(address) && !NetworkUtils.isBroadcastAddress(address) && !NetworkUtils.isDocumentationAddress(address);
    }

    public static boolean isValidAddress(String host) {
        try {
            return NetworkUtils.isValidAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static boolean isDottedIPV4(String s) {
        int octets = 0;
        while (octets < 3) {
            int dot = s.indexOf(".");
            if (dot == -1) {
                return false;
            }
            String octet = s.substring(0, dot);
            try {
                int parsed = Integer.parseInt(octet);
                if (parsed < 0 || parsed > 255) {
                    return false;
                }
            }
            catch (NumberFormatException bad) {
                return false;
            }
            ++octets;
            s = s.substring(Math.min(dot + 1, s.length()), s.length());
        }
        if (s.indexOf(".") != -1) {
            return false;
        }
        try {
            int parsed = Integer.parseInt(s);
            if (parsed < 0 || parsed > 255) {
                return false;
            }
        }
        catch (NumberFormatException bad) {
            return false;
        }
        return true;
    }

    public static boolean isAddress(String hostAndPort) {
        int i = (hostAndPort = hostAndPort.trim()).indexOf(":");
        if (i == -1) {
            return hostAndPort.length() > 0;
        }
        if (i > 0) {
            try {
                int port = Integer.parseInt(hostAndPort.substring(i + 1));
                return NetworkUtils.isValidPort(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean isValidExternalIpPort(IpPort addr) {
        InetAddress address = addr.getInetAddress();
        return address != null && NetworkUtils.isValidAddress(address) && NetworkUtils.isValidPort(addr.getPort());
    }

    public static boolean isValidSocketAddress(SocketAddress address) {
        InetSocketAddress iaddr = (InetSocketAddress)address;
        return !iaddr.isUnresolved() && NetworkUtils.isValidAddress(iaddr.getAddress()) && NetworkUtils.isValidPort(iaddr.getPort());
    }

    public static boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!Arrays.equals(addr.getAddress(), address.getAddress())) continue;
                    return true;
                }
            }
        }
        catch (SocketException err) {
            return false;
        }
        return false;
    }

    public static boolean isLocalAddress(SocketAddress addr) {
        InetSocketAddress iaddr = (InetSocketAddress)addr;
        return !iaddr.isUnresolved() && NetworkUtils.isLocalAddress(iaddr.getAddress());
    }

    public static boolean isCloseIP(InetAddress addr0, InetAddress addr1) {
        return NetworkUtils.isCloseIP(addr0.getAddress(), addr1.getAddress());
    }

    public static boolean isCloseIP(byte[] addr0, byte[] addr1) {
        if (NetworkUtils.isIPv4Address(addr0) && NetworkUtils.isIPv4Address(addr1) || NetworkUtils.isIPv4MappedAddress(addr0) && NetworkUtils.isIPv4MappedAddress(addr1)) {
            return addr0[addr0.length - 4] == addr1[addr1.length - 4];
        }
        return false;
    }

    public static boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        if (NetworkUtils.isIPv4Address(addr0) && NetworkUtils.isIPv4Address(addr1) || NetworkUtils.isIPv4MappedAddress(addr0) && NetworkUtils.isIPv4MappedAddress(addr1)) {
            return addr0[addr0.length - 4] == addr1[addr1.length - 4] && addr0[addr0.length - 3] == addr1[addr1.length - 3];
        }
        return false;
    }

    static boolean isPrivateAddress(InetAddress address) {
        return address.isAnyLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || NetworkUtils.isUniqueLocalUnicastAddress(address) || NetworkUtils.isBroadcastAddress(address) || NetworkUtils.isInvalidAddress(address) || NetworkUtils.isDocumentationAddress(address);
    }

    public static boolean areInSameSiteLocalNetwork(InetAddress address1, InetAddress address2) {
        return NetworkUtils.areInSameSiteLocalNetwork(address1.getAddress(), address2.getAddress());
    }

    public static boolean areInSameSiteLocalNetwork(byte[] address1, byte[] address2) {
        if (address1.length != address2.length) {
            return false;
        }
        if (address1.length == 4) {
            if (address1[0] == 10) {
                return address2[0] == 10;
            }
            if (address1[0] == -84 && (address1[1] & 0xF0) == 16) {
                return address2[0] == -84 && (address2[1] & 0xF0) == 16;
            }
            if (address1[0] == -64 && address1[1] == -88) {
                return address2[0] == -64 && address2[1] == -88;
            }
            return false;
        }
        if (address1.length == 16) {
            try {
                InetAddress a1 = InetAddress.getByAddress(address1);
                InetAddress a2 = InetAddress.getByAddress(address2);
                return a1.isSiteLocalAddress() && a2.isSiteLocalAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("addresses of illegal length: " + address1.length);
    }

    public static boolean isPrivateAddress(byte[] address) {
        return NetworkUtils.isAnyLocalAddress(address) || NetworkUtils.isInvalidAddress(address) || NetworkUtils.isLoopbackAddress(address) || NetworkUtils.isLinkLocalAddress(address) || NetworkUtils.isSiteLocalAddress(address) || NetworkUtils.isUniqueLocalUnicastAddress(address) || NetworkUtils.isBroadcastAddress(address) || NetworkUtils.isDocumentationAddress(address);
    }

    public static final String ip2string(byte[] ip) {
        return NetworkUtils.ip2string(ip, 0);
    }

    public static final String ip2string(byte[] ip, int offset) {
        StringBuilder sbuf = new StringBuilder(16);
        sbuf.append(ByteUtils.ubyte2int(ip[offset]));
        sbuf.append('.');
        sbuf.append(ByteUtils.ubyte2int(ip[offset + 1]));
        sbuf.append('.');
        sbuf.append(ByteUtils.ubyte2int(ip[offset + 2]));
        sbuf.append('.');
        sbuf.append(ByteUtils.ubyte2int(ip[offset + 3]));
        return sbuf.toString();
    }

    public static boolean isLocalHost(Socket socket) {
        return NetworkUtils.isLocalAddress(socket.getInetAddress());
    }

    public static byte[] packIpPorts(Collection<? extends IpPort> ipPorts) {
        byte[] data = new byte[ipPorts.size() * 6];
        int offset = 0;
        for (IpPort ipPort : ipPorts) {
            byte[] addr = ipPort.getInetAddress().getAddress();
            int port = ipPort.getPort();
            System.arraycopy(addr, 0, data, offset, 4);
            ByteUtils.short2leb((short)port, data, offset += 4);
            offset += 2;
        }
        return data;
    }

    public static List<IpPort> unpackIps(byte[] data) throws InvalidDataException {
        return NetworkUtils.unpackIps(data, null);
    }

    public static List<IpPort> unpackIps(byte[] data, Decorator<IpPort, ? extends IpPort> decorator) throws InvalidDataException {
        if (data.length % 6 != 0) {
            throw new InvalidDataException("invalid size");
        }
        int size = data.length / 6;
        ArrayList<IpPort> ret = new ArrayList<IpPort>(size);
        byte[] current = new byte[6];
        for (int i = 0; i < size; ++i) {
            System.arraycopy(data, i * 6, current, 0, 6);
            IpPort ipp = NetworkUtils.getIpPort(current, ByteOrder.LITTLE_ENDIAN);
            if (decorator != null && (ipp = decorator.decorate(ipp)) == null) {
                throw new InvalidDataException("decorator returned null");
            }
            ret.add(ipp);
        }
        return Collections.unmodifiableList(ret);
    }

    public static <T extends IpPort> Collection<T> filterOnePerClassC(Collection<T> c) {
        return NetworkUtils.filterUnique(c, -256);
    }

    public static <T extends IpPort> Collection<T> filterUnique(Collection<T> c, int netmask) {
        ArrayList<IpPort> ret = new ArrayList<IpPort>(c.size());
        HashSet<Integer> ips = new HashSet<Integer>();
        for (IpPort ip : c) {
            if (!ips.add(NetworkUtils.getMaskedIP(ip.getInetAddress(), netmask))) continue;
            ret.add(ip);
        }
        ret.trimToSize();
        return ret;
    }

    public static int getClassC(InetAddress addr) {
        return NetworkUtils.getMaskedIP(addr, -256);
    }

    public static int getMaskedIP(InetAddress addr, int netmask) {
        byte[] address = addr.getAddress();
        return ByteUtils.beb2int(address, address.length - 4) & netmask;
    }

    public static byte[] toByteAddress(int ip) {
        byte[] address = new byte[4];
        ByteUtils.int2beb(ip, address, 0);
        return address;
    }

    public static int getHexMask(int decMask) {
        if (decMask < 0 || decMask > 32) {
            throw new IllegalArgumentException("bad mask " + decMask);
        }
        if (decMask == 0) {
            return 0;
        }
        return -1 << 32 - decMask;
    }

    public static InetAddress getLocalAddress() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        if (addr instanceof Inet4Address && !addr.isLoopbackAddress()) {
            return addr;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        throw new UnknownHostException("localhost has no interface with a non-loopback IPv4 address");
    }

    public static byte[] getBytes(SocketAddress addr, ByteOrder order) throws UnknownHostException {
        InetSocketAddress iaddr = (InetSocketAddress)addr;
        if (iaddr.isUnresolved()) {
            throw new UnknownHostException(iaddr.toString());
        }
        return NetworkUtils.getBytes(iaddr.getAddress(), iaddr.getPort(), order);
    }

    public static byte[] getBytes(IpPort ipp, ByteOrder order) {
        return NetworkUtils.getBytes(ipp.getInetAddress(), ipp.getPort(), order);
    }

    public static byte[] getBytes(InetAddress addr, int port, ByteOrder order) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        if (!NetworkUtils.isValidAddress(addr)) {
            throw new IllegalArgumentException("invalid addr: " + addr);
        }
        byte[] address = addr.getAddress();
        byte[] dst = new byte[address.length + 2];
        System.arraycopy(address, 0, dst, 0, address.length);
        if (order == ByteOrder.BIG_ENDIAN) {
            ByteUtils.short2beb((short)port, dst, dst.length - 2);
        } else {
            ByteUtils.short2leb((short)port, dst, dst.length - 2);
        }
        return dst;
    }

    public static IpPort getIpPort(byte[] ipport, ByteOrder order) throws InvalidDataException {
        InetAddress host;
        if (ipport.length < 6) {
            throw new InvalidDataException("length must be >= 6, is: " + ipport.length);
        }
        short shortport = order == ByteOrder.BIG_ENDIAN ? ByteUtils.beb2short(ipport, ipport.length - 2) : ByteUtils.leb2short(ipport, ipport.length - 2);
        int port = ByteUtils.ushort2int(shortport);
        if (!NetworkUtils.isValidPort(port)) {
            throw new InvalidDataException("Bad Port: " + port);
        }
        if (ipport.length == 6) {
            IP ip = new IP(ipport, 0);
            if (!NetworkUtils.isValidAddress(ip)) {
                throw new InvalidDataException("invalid addr: " + ip);
            }
            return new MemoryOptimizedIpPortImpl(ip, shortport);
        }
        try {
            byte[] ip = new byte[ipport.length - 2];
            System.arraycopy(ipport, 0, ip, 0, ip.length);
            host = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            throw new InvalidDataException(uhe);
        }
        if (!NetworkUtils.isValidAddress(host)) {
            throw new InvalidDataException("invalid addr: " + host);
        }
        return new IpPortImpl(host, port);
    }

    public static Connectable getConnectable(byte[] ipport, ByteOrder order, boolean tlsCapable) throws InvalidDataException {
        return new ConnectableImpl(NetworkUtils.getIpPort(ipport, order), tlsCapable);
    }

    public static boolean isSameAddressSpace(SocketAddress a, SocketAddress b) {
        return NetworkUtils.isSameAddressSpace(((InetSocketAddress)a).getAddress(), ((InetSocketAddress)b).getAddress());
    }

    public static boolean isSameAddressSpace(InetAddress a, InetAddress b) {
        if (a == null || b == null) {
            return false;
        }
        return a instanceof Inet4Address && b instanceof Inet4Address || a instanceof Inet6Address && b instanceof Inet6Address;
    }

    public static byte[] getIPv6AddressBytes(InetAddress address) {
        byte[] bytes = address.getAddress();
        switch (bytes.length) {
            case 16: {
                return bytes;
            }
            case 4: {
                byte[] result = new byte[16];
                result[10] = -1;
                result[11] = -1;
                System.arraycopy(bytes, 0, result, 12, bytes.length);
                return result;
            }
        }
        throw new IllegalArgumentException("unhandled address length");
    }

    public static boolean isIPv6Compatible(InetAddress address) {
        int length = address.getAddress().length;
        return length == 4 || length == 16;
    }

    private static boolean isIPv4Address(byte[] address) {
        return address.length == 4;
    }

    static boolean isIPv4CompatibleAddress(byte[] address) {
        return address.length == 16 && address[0] == 0 && address[1] == 0 && address[2] == 0 && address[3] == 0 && address[4] == 0 && address[5] == 0 && address[6] == 0 && address[7] == 0 && address[8] == 0 && address[9] == 0 && address[10] == 0 && address[11] == 0;
    }

    static boolean isIPv4MappedAddress(byte[] address) {
        return address.length == 16 && address[0] == 0 && address[1] == 0 && address[2] == 0 && address[3] == 0 && address[4] == 0 && address[5] == 0 && address[6] == 0 && address[7] == 0 && address[8] == 0 && address[9] == 0 && address[10] == -1 && address[11] == -1;
    }

    private static boolean isInvalidAddress(InetAddress address) {
        return NetworkUtils.isInvalidAddress(address.getAddress());
    }

    private static boolean isInvalidAddress(byte[] address) {
        if (NetworkUtils.isIPv4Address(address) || NetworkUtils.isIPv4MappedAddress(address)) {
            return address[address.length - 4] == 0;
        }
        return false;
    }

    static boolean isAnyLocalAddress(byte[] address) {
        if (address.length == 4 || address.length == 16) {
            byte test = 0;
            for (int i = 0; i < address.length; ++i) {
                test = (byte)(test | address[i]);
            }
            return test == 0;
        }
        return false;
    }

    static boolean isLoopbackAddress(byte[] address) {
        if (NetworkUtils.isIPv4Address(address) || NetworkUtils.isIPv4MappedAddress(address)) {
            return (address[address.length - 4] & 0xFF) == 127;
        }
        if (address.length == 16) {
            byte test = 0;
            for (int i = 0; i < 15; ++i) {
                test = (byte)(test | address[i]);
            }
            return test == 0 && address[15] == 1;
        }
        return false;
    }

    static boolean isLinkLocalAddress(byte[] address) {
        if (NetworkUtils.isIPv4Address(address) || NetworkUtils.isIPv4MappedAddress(address)) {
            return (address[address.length - 4] & 0xFF) == 169 && (address[address.length - 3] & 0xFF) == 254;
        }
        if (address.length == 16) {
            return (address[0] & 0xFF) == 254 && (address[1] & 0xC0) == 128;
        }
        return false;
    }

    static boolean isSiteLocalAddress(byte[] address) {
        if (NetworkUtils.isIPv4Address(address) || NetworkUtils.isIPv4MappedAddress(address)) {
            return (address[address.length - 4] & 0xFF) == 10 || (address[address.length - 4] & 0xFF) == 172 && (address[address.length - 3] & 0xF0) == 16 || (address[address.length - 4] & 0xFF) == 192 && (address[address.length - 3] & 0xFF) == 168;
        }
        if (address.length == 16) {
            return (address[0] & 0xFF) == 254 && (address[1] & 0xC0) == 192;
        }
        return false;
    }

    public static boolean isUniqueLocalUnicastAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            return NetworkUtils.isUniqueLocalUnicastAddress(address.getAddress());
        }
        return false;
    }

    private static boolean isUniqueLocalUnicastAddress(byte[] address) {
        if (address.length == 16) {
            return (address[0] & 0xFE) == 252;
        }
        return false;
    }

    public static boolean isBroadcastAddress(InetAddress address) {
        return NetworkUtils.isBroadcastAddress(address.getAddress());
    }

    private static boolean isBroadcastAddress(byte[] address) {
        if (NetworkUtils.isIPv4Address(address) || NetworkUtils.isIPv4MappedAddress(address)) {
            return (address[address.length - 4] & 0xFF) == 255;
        }
        return false;
    }

    public static boolean isPrivateIPv4CompatibleAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            return NetworkUtils.isPrivateIPv4CompatibleAddress(address.getAddress());
        }
        return false;
    }

    private static boolean isPrivateIPv4CompatibleAddress(byte[] address) {
        if (NetworkUtils.isIPv4CompatibleAddress(address)) {
            byte[] ipv4 = new byte[4];
            System.arraycopy(address, 12, ipv4, 0, ipv4.length);
            return NetworkUtils.isPrivateAddress(ipv4);
        }
        return false;
    }

    public static boolean isDocumentationAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            return NetworkUtils.isDocumentationAddress(address.getAddress());
        }
        return false;
    }

    private static boolean isDocumentationAddress(byte[] address) {
        if (address.length == 16) {
            return (address[0] & 0xFF) == 32 && (address[1] & 0xFF) == 1 && (address[2] & 0xFF) == 13 && (address[3] & 0xFF) == 184;
        }
        return false;
    }

    static int parsePort(String portString) throws IOException {
        try {
            int port = Integer.parseInt(portString);
            if (!NetworkUtils.isValidPort(port)) {
                throw new IOException("invalid port: " + port);
            }
            return port;
        }
        catch (NumberFormatException invalid) {
            throw (IOException)new IOException().initCause(invalid);
        }
    }

    static InetAddress getAndCheckAddress(String addressString) throws IOException {
        InetAddress address = InetAddress.getByName(addressString);
        if (!NetworkUtils.isValidAddress(address)) {
            throw new IOException("invalid addr: " + address);
        }
        return address;
    }

    static int getAndCheckIpPortSeparator(String ipPort) throws IOException {
        int separator = ipPort.indexOf(":");
        if (separator <= 0 || separator != ipPort.lastIndexOf(":") || separator == ipPort.length() - 1) {
            throw new IOException("invalid separator in http: " + ipPort);
        }
        return separator;
    }

    public static Connectable parseIpPort(String ipPort, boolean tlsCapable) throws IOException {
        int separator = NetworkUtils.getAndCheckIpPortSeparator(ipPort);
        InetAddress address = NetworkUtils.getAndCheckAddress(ipPort.substring(0, separator));
        int port = NetworkUtils.parsePort(ipPort.substring(separator + 1));
        return new ConnectableImpl(new InetSocketAddress(address, port), tlsCapable);
    }

    public static IpPort parsePortIp(String http) throws IOException {
        int separator = NetworkUtils.getAndCheckIpPortSeparator(http);
        int port = NetworkUtils.parsePort(http.substring(0, separator));
        InetAddress address = NetworkUtils.getAndCheckAddress(http.substring(separator + 1));
        return new IpPortImpl(address, port);
    }
}

