/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;

public final class Expand {
    private Expand() {
    }

    public static void expandFile(File source, File dest) throws IOException {
        Expand.expandFile(source, dest, false, null);
    }

    public static void expandFile(File source, File dest, boolean overwrite) throws IOException {
        Expand.expandFile(source, dest, overwrite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandFile(File source, File dest, boolean overwrite, String[] names) throws IOException {
        BufferedInputStream in = null;
        try {
            FileUtils.setWriteable(source);
            in = new BufferedInputStream(new FileInputStream(source));
            Expand.expandFile(in, dest, overwrite, names);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandFile(InputStream is, File dest, boolean overwrite, String[] names) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            File f = new File(dest, ze.getName());
            File dirF = new File(f.getParent());
            FileUtils.setWriteable(dirF);
            dirF.mkdirs();
            if (ze.isDirectory()) {
                f.mkdirs();
                continue;
            }
            if (ze.getTime() <= f.lastModified() && !overwrite && !Expand.inNames(ze.getName(), names)) continue;
            FileUtils.setWriteable(f);
            byte[] buffer = new byte[1024];
            int length = 0;
            BufferedOutputStream fos = null;
            try {
                fos = new BufferedOutputStream(new FileOutputStream(f));
                while ((length = zis.read(buffer)) >= 0) {
                    ((OutputStream)fos).write(buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(fos);
                throw throwable;
            }
            IOUtils.close(fos);
        }
    }

    private static boolean inNames(String name, String[] all) {
        if (all == null || name == null) {
            return false;
        }
        for (int i = 0; i < all.length; ++i) {
            if (!name.startsWith(all[i])) continue;
            return true;
        }
        return false;
    }
}

