/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.inspections;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.io.InvalidDataException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class InspectionDataContainer {
    private static final Log LOG = LogFactory.getLog(InspectionDataContainer.class);
    private final Map<String, Object> inspectionResults = new ConcurrentHashMap<String, Object>();
    private final long collectionTimestamp;

    public InspectionDataContainer() {
        this(System.currentTimeMillis());
    }

    public InspectionDataContainer(long collectionTimestamp) {
        this.collectionTimestamp = collectionTimestamp;
    }

    public InspectionDataContainer(byte[] bencodedGzipBytes) throws InvalidDataException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bencodedGzipBytes);
        try {
            GZIPInputStream gzip = new GZIPInputStream(bais);
            ReadableByteChannel rbc = Channels.newChannel(gzip);
            Map containerMap = (Map)Token.parse(rbc, "UTF-8");
            this.collectionTimestamp = (Long)containerMap.get("t");
            List listOfInspectionMaps = (List)containerMap.get("i");
            for (Object inspDataContainer : listOfInspectionMaps) {
                Map inspDataContainerMap = (Map)inspDataContainer;
                String inspKey = new String((byte[])inspDataContainerMap.get("k"));
                Object inspDataMap = inspDataContainerMap.get("d");
                this.addInspectionResult(inspKey, inspDataMap);
            }
        }
        catch (IOException e) {
            LOG.debugf(e, "Error in parsing bytes into inspection data", new Object[0]);
            throw new InvalidDataException(e);
        }
        catch (ClassCastException e) {
            LOG.debugf(e, "Invalid encoding in data", new Object[0]);
            throw new InvalidDataException(e);
        }
    }

    Map<String, Object> asBencodedMap() {
        HashMap<String, Object> bencodingMap = new HashMap<String, Object>();
        ArrayList inspPointsMapList = new ArrayList();
        bencodingMap.put("t", this.collectionTimestamp);
        bencodingMap.put("i", inspPointsMapList);
        for (Map.Entry<String, Object> entry : this.inspectionResults.entrySet()) {
            HashMap<String, Object> inspKeyAndData = new HashMap<String, Object>();
            inspKeyAndData.put("k", entry.getKey());
            inspKeyAndData.put("d", entry.getValue());
            inspPointsMapList.add(inspKeyAndData);
        }
        return bencodingMap;
    }

    public void addInspectionResult(String key, Object inspectionData) {
        this.inspectionResults.put(key, inspectionData);
    }

    long getTimestamp() {
        return this.collectionTimestamp;
    }

    Object getData(String key) {
        return this.inspectionResults.get(key);
    }

    int getResultCount() {
        return this.inspectionResults.size();
    }
}

