/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import java.util.HashSet;
import java.util.Set;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

public class RequestCache {
    private static final Log LOG = LogFactory.getLog(RequestCache.class);
    private static final double MAX_REQUESTS = 5000.0;
    static long FIRST_CHECK_TIME = 30000L;
    private final Set<URN> ACTIVE_TRANSFERS = new HashSet<URN>();
    private double _numRequests = 0.0;
    private long _lastRequest = this._firstRequest = System.currentTimeMillis();
    private long _firstRequest;

    void startedTransfer(URN sha1) {
        this.ACTIVE_TRANSFERS.add(sha1);
    }

    boolean isHammering() {
        if (this._lastRequest - this._firstRequest <= FIRST_CHECK_TIME) {
            return false;
        }
        return (double)(this._lastRequest - this._firstRequest) / this._numRequests < 5000.0;
    }

    void countRequest() {
        this._numRequests += 1.0;
        this._lastRequest = System.currentTimeMillis();
    }

    boolean isDupe(URN sha1) {
        return this.ACTIVE_TRANSFERS.contains(sha1);
    }

    void transferDone(URN sha1) {
        this.ACTIVE_TRANSFERS.remove(sha1);
    }
}

