/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.DownloaderGuidAlternateLocationFinder;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.PushProxiesPublisher;
import com.limegroup.gnutella.library.Library;
import com.limegroup.gnutella.library.LibraryUtils;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.FileFilter;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.util.FileUtils;

@EagerSingleton
class CoreRandomGlue {
    private final Library library;
    private final ConnectionManager connectionManager;
    private final DHTManager dhtManager;
    private final PushProxiesPublisher pushProxiesPublisher;
    private final ConnectionServices connectionServices;
    private final DownloadManager downloadManager;
    private final DownloaderGuidAlternateLocationFinder downloaderGuidAlternateLocationFinder;
    private final SpamServices spamServices;
    private final SimppManager simppManager;
    private final HashTreeCache hashTreeCache;
    private final LicenseFactory licenseFactory;
    private final AltLocManager altLocManager;

    @Inject
    CoreRandomGlue(Library library, ConnectionManager connectionManager, DHTManager dhtManager, PushProxiesPublisher pushProxiesPublisher, ConnectionServices connectionServices, DownloadManager downloadManager, DownloaderGuidAlternateLocationFinder downloaderGuidAlternateLocationFinder, SpamServices spamServices, SimppManager simppManager, LicenseFactory licenseFactory, HashTreeCache hashTreeCache, SchemaReplyCollectionMapper schemaMapper, AltLocManager altLocManager) {
        this.library = library;
        this.connectionManager = connectionManager;
        this.dhtManager = dhtManager;
        this.pushProxiesPublisher = pushProxiesPublisher;
        this.connectionServices = connectionServices;
        this.downloadManager = downloadManager;
        this.downloaderGuidAlternateLocationFinder = downloaderGuidAlternateLocationFinder;
        this.spamServices = spamServices;
        this.simppManager = simppManager;
        this.hashTreeCache = hashTreeCache;
        this.licenseFactory = licenseFactory;
        this.altLocManager = altLocManager;
    }

    @Inject
    private void register(ServiceRegistry registry) {
        registry.register(new Service(){

            @Override
            public void initialize() {
                CoreRandomGlue.this.library.addListener(CoreRandomGlue.this.altLocManager);
                CoreRandomGlue.this.connectionManager.addEventListener(CoreRandomGlue.this.dhtManager);
                CoreRandomGlue.this.dhtManager.addEventListener(CoreRandomGlue.this.pushProxiesPublisher);
                CoreRandomGlue.this.downloadManager.addListener(CoreRandomGlue.this.downloaderGuidAlternateLocationFinder);
            }

            @Override
            public void start() {
                CoreRandomGlue.this.spamServices.reloadSpamFilters();
                CoreRandomGlue.this.simppManager.addListener(new SimppListener(){

                    @Override
                    public void simppUpdated(int newVersion) {
                        CoreRandomGlue.this.spamServices.reloadSpamFilters();
                    }
                });
            }

            @Override
            public void stop() {
                CoreRandomGlue.this.downloadManager.removeListener(CoreRandomGlue.this.downloaderGuidAlternateLocationFinder);
            }

            @Override
            public String getServiceName() {
                return I18nMarker.marktr("Various Core Services");
            }
        }).in("EarlyBackground");
        registry.register(new Service(){

            @Override
            public String getServiceName() {
                return I18nMarker.marktr("Gnutella Connections");
            }

            @Override
            public void initialize() {
            }

            @Override
            public void start() {
                int outgoing;
                if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
                    CoreRandomGlue.this.connectionServices.connect();
                }
            }

            @Override
            public void stop() {
                CoreRandomGlue.this.hashTreeCache.persistCache(CoreRandomGlue.this.library, CoreRandomGlue.this.downloadManager);
                CoreRandomGlue.this.licenseFactory.persistCache();
                CoreRandomGlue.this.cleanupPreviewFiles();
                CoreRandomGlue.this.cleanupTorrentMetadataFiles();
            }
        }).in(ServiceStage.LATE);
    }

    private void cleanupTorrentMetadataFiles() {
        if (!this.library.isLoadFinished()) {
            return;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return "torrent".equals(FileUtils.getFileExtension(f));
            }
        };
        File[] file_list = LibraryUtils.APPLICATION_SPECIAL_SHARE.listFiles(filter);
        if (file_list == null) {
            return;
        }
        long purgeLimit = System.currentTimeMillis() - (long)SharingSettings.TORRENT_METADATA_PURGE_TIME.getValue() * 24L * 60L * 60L * 1000L;
        for (int i = 0; i < file_list.length; ++i) {
            File tFile = file_list[i];
            if (this.library.getFileDesc(tFile) == null || tFile.lastModified() >= purgeLimit) continue;
            tFile.delete();
        }
    }

    private void cleanupPreviewFiles() {
        File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.get();
        if (incompleteDir == null) {
            return;
        }
        File[] files = incompleteDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!name.startsWith("Preview-")) continue;
            files[i].delete();
        }
    }
}

