/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xmind.core.ILabeled;
import org.xmind.core.ITopic;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.spreadsheet.ModifyColumnOrderCommand;
import org.xmind.ui.internal.spreadsheet.ModifyRowOrderCommand;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.ColumnOrder;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.spreadsheet.structures.RowOrder;
import org.xmind.ui.util.MindMapUtils;

public class SheetHeadModifiablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "modify_sheet_head".equals(requestType);
    }

    public void handle(Request request) {
        String reqType = request.getType();
        if ("modify_sheet_head".equals(reqType)) {
            this.modifySheetHead(request);
        }
    }

    private void modifySheetHead(Request request) {
        if (!request.hasParameter("text")) {
            return;
        }
        String text = (String)request.getParameter("text");
        if (text == null) {
            text = "";
        }
        Collection labels = MindMapUtils.getLabels((String)text);
        List sources = request.getTargets();
        ArrayList<ModifyLabelCommand> cmds = new ArrayList<ModifyLabelCommand>(sources.size());
        for (IPart p : sources) {
            Object o = MindMapUtils.getRealModel((IPart)p);
            if (!(o instanceof ILabeled)) continue;
            cmds.add(new ModifyLabelCommand((ILabeled)o, labels));
        }
        if (cmds.isEmpty()) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand(cmds);
        ITopic topic = ((ITopic)MindMapUtils.getRealModel((IPart)((IPart)sources.get(0)))).getParent().getParent();
        Set oldLabels = ((ITopic)MindMapUtils.getRealModel((IPart)((IPart)sources.get(0)))).getLabels();
        ColumnOrder columnOrder = ColumnOrder.createFromTopic(topic);
        List<ColumnHead> columnHeads = columnOrder.getHeads();
        Iterator<ColumnHead> ite = columnHeads.iterator();
        while (ite.hasNext()) {
            ColumnHead columnHead = ite.next();
            if (!columnHead.getLabels().equals(oldLabels)) continue;
            columnHead.setLabels(new TreeSet<String>(labels));
            for (ColumnHead ch : new ArrayList<ColumnHead>(columnHeads)) {
                if (ch == columnHead || !ch.getLabels().equals(columnHead.getLabels())) continue;
                ite.remove();
            }
        }
        ModifyColumnOrderCommand modifyColumnOrderCommand = new ModifyColumnOrderCommand(topic, columnOrder);
        cmd.append((Command)modifyColumnOrderCommand);
        RowOrder rowOrder = RowOrder.createFromTopic(topic);
        List<RowHead> rowHeads = rowOrder.getHeads();
        Iterator<RowHead> ite2 = rowHeads.iterator();
        while (ite2.hasNext()) {
            RowHead rowHead = ite2.next();
            if (!rowHead.getLabels().equals(oldLabels)) continue;
            rowHead.setLabels(new TreeSet<String>(labels));
            for (RowHead rh : new ArrayList<RowHead>(rowHeads)) {
                if (rh == rowHead || !rh.getLabels().equals(rowHead.getLabels())) continue;
                ite2.remove();
            }
        }
        ModifyRowOrderCommand modifyRowOrderCommand = new ModifyRowOrderCommand(topic, rowOrder);
        cmd.append((Command)modifyRowOrderCommand);
        cmd.setLabel(CommandMessages.Command_ModifyLabels);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
        this.select(cmd.getSources(), request.getTargetViewer());
    }
}

