/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.thrift.protocol;

import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TField;
import com.evernote.thrift.protocol.TList;
import com.evernote.thrift.protocol.TMap;
import com.evernote.thrift.protocol.TMessage;
import com.evernote.thrift.protocol.TSet;
import com.evernote.thrift.protocol.TStruct;
import com.evernote.thrift.transport.TTransport;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class TProtocol {
    protected TTransport trans_;

    private TProtocol() {
    }

    protected TProtocol(TTransport trans) {
        this.trans_ = trans;
    }

    public TTransport getTransport() {
        return this.trans_;
    }

    public abstract void writeMessageBegin(TMessage var1) throws TException;

    public abstract void writeMessageEnd() throws TException;

    public abstract void writeStructBegin(TStruct var1) throws TException;

    public abstract void writeStructEnd() throws TException;

    public abstract void writeFieldBegin(TField var1) throws TException;

    public abstract void writeFieldEnd() throws TException;

    public abstract void writeFieldStop() throws TException;

    public abstract void writeMapBegin(TMap var1) throws TException;

    public abstract void writeMapEnd() throws TException;

    public abstract void writeListBegin(TList var1) throws TException;

    public abstract void writeListEnd() throws TException;

    public abstract void writeSetBegin(TSet var1) throws TException;

    public abstract void writeSetEnd() throws TException;

    public abstract void writeBool(boolean var1) throws TException;

    public abstract void writeByte(byte var1) throws TException;

    public abstract void writeI16(short var1) throws TException;

    public abstract void writeI32(int var1) throws TException;

    public abstract void writeI64(long var1) throws TException;

    public abstract void writeDouble(double var1) throws TException;

    public abstract void writeString(String var1) throws TException;

    public void writeBinary(ByteBuffer buf) throws TException {
        int length = buf.limit() - buf.position() - buf.arrayOffset();
        this.writeBinary(buf.array(), buf.position() + buf.arrayOffset(), length);
    }

    public void writeStream(InputStream data, long length) throws TException {
        this.writeI32((int)length);
        byte[] buffer = new byte[1024];
        try {
            int bufflen = 0;
            while ((bufflen = data.read(buffer)) >= 0) {
                this.trans_.write(buffer, 0, bufflen);
            }
        }
        catch (IOException e) {
            throw new TException("Failed to read from stream", e);
        }
    }

    public abstract void writeBinary(byte[] var1, int var2, int var3) throws TException;

    public void writeBinary(byte[] buf) throws TException {
        this.writeBinary(buf, 0, buf.length);
    }

    public abstract TMessage readMessageBegin() throws TException;

    public abstract void readMessageEnd() throws TException;

    public abstract TStruct readStructBegin() throws TException;

    public abstract void readStructEnd() throws TException;

    public abstract TField readFieldBegin() throws TException;

    public abstract void readFieldEnd() throws TException;

    public abstract TMap readMapBegin() throws TException;

    public abstract void readMapEnd() throws TException;

    public abstract TList readListBegin() throws TException;

    public abstract void readListEnd() throws TException;

    public abstract TSet readSetBegin() throws TException;

    public abstract void readSetEnd() throws TException;

    public abstract boolean readBool() throws TException;

    public abstract byte readByte() throws TException;

    public abstract short readI16() throws TException;

    public abstract int readI32() throws TException;

    public abstract long readI64() throws TException;

    public abstract double readDouble() throws TException;

    public abstract String readString() throws TException;

    public abstract ByteBuffer readBinary() throws TException;

    public abstract byte[] readBytes() throws TException;

    public void reset() {
    }
}

