/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.mindmap.IWorkbookRef;

public class DeleteCloudMapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList<IWorkbookRef> workbookRefs = new ArrayList<IWorkbookRef>();
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof IWorkbookRef)) continue;
                workbookRefs.add((IWorkbookRef)element);
            }
            if (!workbookRefs.isEmpty()) {
                this.deleteCloudMap(workbookRefs, shell);
            }
        }
        return null;
    }

    private void deleteCloudMap(List<IWorkbookRef> workbookRefs, Shell shell) {
        String title = SeawindMessages.DeleteCloudMapConfirmationDialog_title;
        String message = workbookRefs.size() > 1 ? NLS.bind((String)SeawindMessages.DeleteCloudMapConfirmationDialog_message_forSingleMap, (Object)String.valueOf(workbookRefs.size())) : NLS.bind((String)SeawindMessages.DeleteCloudMapConfirmationDialog_message_forMultipleMaps, (Object)DeleteCloudMapHandler.getWorkbookRefName(workbookRefs.get(0)));
        MessageDialog confirmDialog = new MessageDialog(shell, title, null, message, 5, new String[]{SeawindMessages.DeleteCloudMapConfirmationDialog_DeleteButton_text, IDialogConstants.CANCEL_LABEL}, 0);
        if (confirmDialog.open() != 0) {
            return;
        }
        for (IWorkbookRef workbookRef : new ArrayList<IWorkbookRef>(workbookRefs)) {
            SeawindUIPlugin.getSeawindLibrary().deleteWorkbookRef(workbookRef.getURI());
        }
    }

    private static String getWorkbookRefName(IWorkbookRef workbookRef) {
        String name = workbookRef.getName();
        return name == null ? SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName : name;
    }
}

