/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.TopicExtension;

public class TopicExtensionElement
implements ITopicExtensionElement {
    private final TopicExtension owner;
    private final String name;
    private List<TopicExtensionElement> children;
    private TopicExtensionElement parent;
    private Map<String, String> attributes;
    private String textContent;
    private boolean orphan;

    public TopicExtensionElement(TopicExtension owner, String name) {
        this.owner = owner;
        this.name = name;
        this.children = new ArrayList<TopicExtensionElement>();
        this.parent = null;
        this.attributes = new HashMap<String, String>();
        this.textContent = null;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.owner.getOwnedSheet());
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getTopic());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.owner.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public ITopicExtension getExtension() {
        return this.owner;
    }

    public ITopic getTopic() {
        return this.owner.getParent();
    }

    public List<ITopicExtensionElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public List<ITopicExtensionElement> getChildren(String elementName) {
        ArrayList<ITopicExtensionElement> subChildren = new ArrayList<ITopicExtensionElement>(this.children.size());
        if (elementName != null) {
            for (TopicExtensionElement child : this.children) {
                if (!elementName.equals(child.getName())) continue;
                subChildren.add(child);
            }
        }
        return subChildren;
    }

    public ITopicExtensionElement createChild(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        TopicExtensionElement child = new TopicExtensionElement(this.owner, elementName);
        this.children.add(child);
        child.setParent(this);
        if (!this.isOrphan()) {
            child.onParented();
        }
        return child;
    }

    public ITopicExtensionElement getCreatedChild(String elementName) {
        ITopicExtensionElement child = this.getFirstChild(elementName);
        if (child != null) {
            return child;
        }
        return this.createChild(elementName);
    }

    public ITopicExtensionElement getFirstChild(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        for (TopicExtensionElement child : this.children) {
            if (!elementName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public ITopicExtensionElement getParent() {
        return this.parent;
    }

    protected void setParent(TopicExtensionElement parent) {
        this.parent = parent;
    }

    public void addChild(ITopicExtensionElement child, int index) {
        if (child == null || !(child instanceof TopicExtensionElement) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        TopicExtensionElement c = (TopicExtensionElement)child;
        ITopicExtensionElement oldParent = c.getParent();
        if (oldParent != null) {
            oldParent.deleteChild((IExtensionElement)c);
        }
        if (index >= 0 && index < this.children.size()) {
            this.children.add(index, c);
        } else {
            this.children.add(c);
        }
        if (!this.isOrphan()) {
            c.onParented();
        }
        c.setParent(this);
    }

    public void deleteChild(ITopicExtensionElement child) {
        if (child == null || !(child instanceof TopicExtensionElement) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        TopicExtensionElement c = (TopicExtensionElement)child;
        if (c.getParent() != this || !this.children.contains(c)) {
            return;
        }
        if (!this.isOrphan()) {
            c.onOrphan();
        }
        this.children.remove(c);
        c.setParent(null);
    }

    public void deleteChildren(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException();
        }
        Iterator<TopicExtensionElement> childIt = this.children.iterator();
        while (childIt.hasNext()) {
            TopicExtensionElement c = childIt.next();
            if (!elementName.equals(c.getName())) continue;
            if (!this.isOrphan()) {
                c.onOrphan();
            }
            childIt.remove();
            c.setParent(null);
        }
    }

    public void deleteChildren() {
        for (TopicExtensionElement child : this.children) {
            if (!this.isOrphan()) {
                child.onOrphan();
            }
            child.setParent(null);
        }
        this.children.clear();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public String getAttribute(String attrName) {
        if (attrName == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    public void setAttribute(String attrName, String attrValue) {
        if (attrName == null) {
            return;
        }
        if (attrValue == null) {
            this.attributes.remove(attrName);
        } else {
            this.attributes.put(attrName, attrValue);
        }
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String text) {
        this.textContent = text;
    }

    protected void onParented() {
        this.orphan = false;
        for (TopicExtensionElement child : this.children) {
            child.onParented();
        }
    }

    protected void onOrphan() {
        for (TopicExtensionElement child : this.children) {
            child.onOrphan();
        }
        this.orphan = true;
    }
}

