/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImageSpan;
import org.xmind.core.IParagraph;
import org.xmind.core.ITextSpan;
import org.xmind.core.plain.HtmlHyperlinkSpan;
import org.xmind.core.plain.HtmlImageSpan;
import org.xmind.core.plain.HtmlParagraph;
import org.xmind.core.plain.HtmlTextSpan;
import org.xmind.core.plain.NotesContent;
import org.xmind.core.plain.Workbook;

public class HtmlNotesContent
extends NotesContent
implements IHtmlNotesContent {
    private final List<IParagraph> paragraphs = new ArrayList<IParagraph>();

    public HtmlNotesContent(Workbook ownerWorkbook, String format) {
        super(ownerWorkbook, format);
    }

    public List<IParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public void addParagraph(IParagraph paragraph) {
        if (paragraph == null || paragraph.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        this.paragraphs.add(paragraph);
    }

    public void removeParagraph(IParagraph paragraph) {
        if (paragraph == null || paragraph.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        this.paragraphs.remove(paragraph);
    }

    public IParagraph createParagraph() {
        return new HtmlParagraph((Workbook)this.getOwnedWorkbook());
    }

    public ITextSpan createTextSpan(String textContent) {
        HtmlTextSpan span = new HtmlTextSpan((Workbook)this.getOwnedWorkbook());
        span.setTextContent(textContent);
        return span;
    }

    public IImageSpan createImageSpan(String source) {
        HtmlImageSpan span = new HtmlImageSpan((Workbook)this.getOwnedWorkbook());
        span.setSource(source);
        return span;
    }

    public IHyperlinkSpan createHyperlinkSpan(String href) {
        HtmlHyperlinkSpan span = new HtmlHyperlinkSpan((Workbook)this.getOwnedWorkbook());
        span.setHref(href);
        return span;
    }

    @Override
    protected void onParented() {
        super.onParented();
        for (IParagraph paragraph : this.paragraphs) {
            if (!(paragraph instanceof HtmlParagraph)) continue;
            ((HtmlParagraph)paragraph).onParented();
        }
    }

    @Override
    protected void onOrphan() {
        for (IParagraph paragraph : this.paragraphs) {
            if (!(paragraph instanceof HtmlParagraph)) continue;
            ((HtmlParagraph)paragraph).onOrphan();
        }
        super.onOrphan();
    }
}

