/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.meggy;

import java.util.HashMap;
import java.util.Map;

public class PropertySelector {
    private final Map<String, Rating> ratings = new HashMap<String, Rating>();
    private int nextPosition = 0;

    public void add(String value, int weight) {
        Rating rating = this.ratings.get(value);
        if (rating == null) {
            int position = this.nextPosition++;
            rating = new Rating(position);
            this.ratings.put(value, rating);
        }
        rating.votes += weight;
    }

    public String getResult() {
        String winner = null;
        Rating highestRating = null;
        for (Map.Entry<String, Rating> en : this.ratings.entrySet()) {
            Rating rating = en.getValue();
            if (highestRating != null && rating.votes <= highestRating.votes && (rating.votes != highestRating.votes || rating.position >= highestRating.position)) continue;
            winner = en.getKey();
            highestRating = rating;
        }
        return winner;
    }

    private static final class Rating {
        public int position;
        public int votes;

        public Rating(int position) {
            this.position = position;
            this.votes = 0;
        }
    }
}

