/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageReference {
    private static Map<ImageDescriptor, ImageCache> caches = new HashMap<ImageDescriptor, ImageCache>();
    private ImageCache cache;
    private boolean disposed = false;

    public ImageReference(ImageDescriptor descriptor, boolean returnMissingImageOnError) {
        this(descriptor, returnMissingImageOnError, ImageReference.findAvailableDevice());
    }

    public ImageReference(ImageDescriptor descriptor, boolean returnMissingImageOnError, Device device) {
        this.cache = ImageReference.getImageCache(descriptor, returnMissingImageOnError, device);
        this.cache.register(this);
    }

    public Image getImage() {
        if (this.disposed) {
            throw new SWTException(44);
        }
        return this.cache.getImage();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.cache.descriptor;
    }

    public boolean returnsMissingImageOnError() {
        return this.cache.returnMissingImageOnError;
    }

    public Device getDevice() {
        return this.cache.device;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ImageReference imageReference = this;
        synchronized (imageReference) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.cache.unregister(this);
        }
    }

    private static synchronized ImageCache getImageCache(ImageDescriptor descriptor, boolean returnMissingImageOnError, Device device) {
        ImageCache cache = caches.get(descriptor);
        if (cache == null) {
            cache = new ImageCache(descriptor, returnMissingImageOnError, device);
            caches.put(descriptor, cache);
        }
        return cache;
    }

    private static Device findAvailableDevice() {
        Display device = Display.getCurrent();
        if (device == null) {
            device = Display.getDefault();
        }
        if (device == null) {
            throw new IllegalStateException("No display available");
        }
        return device;
    }

    private static class ImageCache {
        private ImageDescriptor descriptor;
        private Device device;
        private boolean returnMissingImageOnError;
        private Image image = null;
        private List<ImageReference> refs = new ArrayList<ImageReference>();

        public ImageCache(ImageDescriptor descriptor, boolean returnMissingImageOnError, Device device) {
            this.descriptor = descriptor;
            this.device = device;
            this.returnMissingImageOnError = returnMissingImageOnError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(ImageReference ref) {
            ImageCache imageCache = this;
            synchronized (imageCache) {
                this.refs.add(ref);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister(ImageReference ref) {
            ImageCache imageCache = this;
            synchronized (imageCache) {
                this.refs.remove(ref);
                if (this.refs.isEmpty()) {
                    this.disposeImage();
                }
            }
        }

        private void disposeImage() {
            Image oldImage = this.image;
            this.image = null;
            if (oldImage != null) {
                oldImage.dispose();
            }
        }

        public synchronized Image getImage() {
            if (this.image == null || this.image.isDisposed()) {
                try {
                    this.image = this.descriptor.createImage(this.returnMissingImageOnError, this.device);
                }
                catch (SWTException sWTException) {
                    this.image = null;
                }
            }
            return this.image;
        }
    }
}

