/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mapshot;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRectangleProvider;
import org.xmind.gef.tool.AreaCreateTool;
import org.xmind.ui.internal.mapshot.CopyAreaFeedback;
import org.xmind.ui.internal.mapshot.MapShotTemporaryStorage;
import org.xmind.ui.internal.mapshot.MapShotTool;

public class MapShotAreaCreateTool
extends AreaCreateTool {
    private CopyAreaFeedback feedback;
    private IFeedbackService feedbackService;

    public MapShotAreaCreateTool() {
        this.setContextId("org.xmind.ui.context.mapShot");
    }

    protected void start() {
        super.start();
        this.feedbackService = (IFeedbackService)this.getTargetViewer().getService(IFeedbackService.class);
        if (this.feedbackService != null) {
            MapShotTemporaryStorage temporaryStorage = ((MapShotTool)this.getDomain().getTool("org.xmind.ui.tool.mapShot")).getTemporaryStorage();
            this.feedback = new CopyAreaFeedback(temporaryStorage);
            this.feedback.setBoundsProvider(new IRectangleProvider(){

                public Rectangle getRectangle() {
                    return MapShotAreaCreateTool.this.getResult();
                }
            });
            this.feedbackService.addFeedback((IFeedback)this.feedback);
        }
    }

    protected void end() {
        if (this.feedbackService != null) {
            if (this.feedback != null) {
                this.feedbackService.removeFeedback((IFeedback)this.feedback);
            }
            this.feedback = null;
            this.feedbackService = null;
        }
    }

    public CopyAreaFeedback getFeedback() {
        return this.feedback;
    }

    protected void updateArea(Rectangle area, Point currentPos) {
        super.updateArea(area, currentPos);
        if (this.feedback != null) {
            this.feedback.update();
        }
    }

    protected boolean handleMouseUp(MouseEvent me) {
        this.feedback.updateButtons();
        return super.handleMouseUp(me);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        return Cursors.CROSS;
    }

    protected void changeToNextTool() {
        this.changeActiveTool("org.xmind.ui.tool.mapShot");
    }
}

