/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.ITopic;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.SourceCommand;

public class AddMarkerCommand
extends SourceCommand {
    private String markerId;

    public AddMarkerCommand(ITopic topic, String newMarkerId) {
        super((Object)topic);
        Assert.isNotNull((Object)newMarkerId);
        this.markerId = newMarkerId;
    }

    public AddMarkerCommand(Collection<? extends ITopic> topics, String newMarkerId) {
        super(topics);
        Assert.isNotNull((Object)newMarkerId);
        this.markerId = newMarkerId;
    }

    public AddMarkerCommand(ISourceProvider sourceProvider, String newMarkerId) {
        super(sourceProvider);
        Assert.isNotNull((Object)newMarkerId);
        this.markerId = newMarkerId;
    }

    public void redo() {
        for (Object source : this.getSources()) {
            if (!(source instanceof ITopic)) continue;
            ITopic t = (ITopic)source;
            t.addMarker(this.markerId);
        }
        super.redo();
    }

    public void undo() {
        List sources = this.getSources();
        int i = sources.size() - 1;
        while (i >= 0) {
            Object source = sources.get(i);
            if (source instanceof ITopic) {
                ITopic t = (ITopic)source;
                t.removeMarker(this.markerId);
            }
            --i;
        }
        super.undo();
    }
}

