/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.ICommentManager;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.INotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.IResourceRef;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISerializer;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookComponentRefManager;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Workbook;
import org.xmind.core.internal.dom.BaseNotesContentImpl;
import org.xmind.core.internal.dom.BoundaryImpl;
import org.xmind.core.internal.dom.CommentManagerImpl;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerRefImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableRegistry;
import org.xmind.core.internal.dom.PlainNotesContentImpl;
import org.xmind.core.internal.dom.RelationshipImpl;
import org.xmind.core.internal.dom.ResourceRefImpl;
import org.xmind.core.internal.dom.RevisionRepositoryImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.SummaryImpl;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookComponentRefCounter;
import org.xmind.core.internal.dom.WorkbookExtensionManagerImpl;
import org.xmind.core.internal.dom.WorkbookMarkerRefCounter;
import org.xmind.core.internal.dom.WorkbookMarkerResourceProvider;
import org.xmind.core.internal.dom.WorkbookStyleRefCounter;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IMarkerRefCounter;
import org.xmind.core.util.IStyleRefCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookImpl
extends Workbook
implements ICoreEventSource,
ICoreEventSource2,
INodeAdaptableFactory {
    private Document implementation;
    private ManifestImpl manifest;
    private NodeAdaptableRegistry adaptableRegistry;
    private CoreEventSupport coreEventSupport = null;
    private StyleSheetImpl styleSheet = null;
    private MarkerSheetImpl markerSheet = null;
    private MetaImpl meta = null;
    private CommentManagerImpl commentManager = null;
    private WorkbookMarkerRefCounter markerRefCounter = null;
    private WorkbookStyleRefCounter styleRefCounter = null;
    private WorkbookComponentRefCounter elementRefCounter = null;
    private RevisionRepositoryImpl revisionRepository = null;
    private WorkbookExtensionManagerImpl extensionManager;

    public WorkbookImpl(Document implementation, IStorage storage) {
        this(implementation, new ManifestImpl(DOMUtils.createDocument(), storage));
    }

    public WorkbookImpl(Document implementation, ManifestImpl manifest) {
        this.implementation = implementation;
        this.manifest = manifest;
        this.adaptableRegistry = new NodeAdaptableRegistry(implementation, this);
        this.init();
    }

    private void init() {
        this.manifest.setWorkbook(this);
        this.manifest.createFileEntry("content.xml", "text/xml").increaseReference();
        this.manifest.createFileEntry("meta.xml", "text/xml").increaseReference();
        Element w = DOMUtils.ensureChildElement(this.implementation, "xmap-content");
        NS.setNS(NS.XMAP, w, NS.Xhtml, NS.Xlink, NS.SVG, NS.Fo);
        if (!DOMUtils.childElementIterByTag(w, "sheet").hasNext()) {
            this.addSheet(this.createSheet());
        }
        InternalDOMUtils.addVersion(this.implementation);
        ICoreEventListener eventHook = new ICoreEventListener(){

            public void handleCoreEvent(CoreEvent event) {
                WorkbookImpl.this.handleMarkerSheetEvent(event);
            }
        };
        ICoreEventSupport eventSupport = this.getCoreEventSupport();
        eventSupport.registerGlobalListener("markerAdd", eventHook);
        eventSupport.registerGlobalListener("markerRemove", eventHook);
        eventSupport.registerGlobalListener("markerGroupAdd", eventHook);
        eventSupport.registerGlobalListener("markerGroupRemove", eventHook);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public IStorage getStorage() {
        return this.manifest.getStorage();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookImpl)) {
            return false;
        }
        WorkbookImpl that = (WorkbookImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        if (this.getStorage() != null) {
            return "Workbook{" + this.hashCode() + ";path:" + this.getStorage().getFullPath() + "}";
        }
        return "Workbook{" + this.hashCode() + "}";
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IStorage.class.equals(adapter)) {
            return adapter.cast(this.getStorage());
        }
        if (IEntryStreamNormalizer.class.equals(adapter)) {
            return adapter.cast(this.manifest.getStreamNormalizer());
        }
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Document.class)) {
            return adapter.cast(this.implementation);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getWorkbookElement());
        }
        if (IMarkerSheet.class.equals(adapter)) {
            return adapter.cast(this.getMarkerSheet());
        }
        if (IManifest.class.equals(adapter)) {
            return adapter.cast(this.getManifest());
        }
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.getCoreEventSupport());
        }
        if (INodeAdaptableFactory.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (INodeAdaptableProvider.class.equals(adapter)) {
            return adapter.cast(this.getAdaptableRegistry());
        }
        if (IMarkerRefCounter.class.equals(adapter)) {
            return adapter.cast(this.getMarkerRefCounter());
        }
        if (IStyleRefCounter.class.equals(adapter)) {
            return adapter.cast(this.getStyleRefCounter());
        }
        if (IWorkbookComponentRefManager.class.equals(adapter)) {
            return adapter.cast(this.getElementRefCounter());
        }
        if (IRevisionRepository.class.equals(adapter)) {
            return adapter.cast(this.getRevisionRepository());
        }
        if (IWorkbookExtensionManager.class.equals(adapter)) {
            return adapter.cast(this.getWorkbookExtensionManager());
        }
        return super.getAdapter(adapter);
    }

    protected Element getWorkbookElement() {
        return this.implementation.getDocumentElement();
    }

    public NodeAdaptableRegistry getAdaptableRegistry() {
        return this.adaptableRegistry;
    }

    @Override
    public ITopic createTopic() {
        TopicImpl topic = new TopicImpl(this.implementation.createElement("topic"), this);
        this.getAdaptableRegistry().registerByNode(topic, topic.getImplementation());
        return topic;
    }

    @Override
    public ISheet createSheet() {
        SheetImpl sheet = new SheetImpl(this.implementation.createElement("sheet"), this);
        this.getAdaptableRegistry().registerByNode(sheet, sheet.getImplementation());
        return sheet;
    }

    @Override
    public IRelationship createRelationship() {
        RelationshipImpl relationship = new RelationshipImpl(this.implementation.createElement("relationship"), this);
        this.getAdaptableRegistry().registerByNode(relationship, relationship.getImplementation());
        return relationship;
    }

    @Override
    public IRelationship createRelationship(IRelationshipEnd end1, IRelationshipEnd end2) {
        ISheet sheet = end1.getOwnedSheet();
        IRelationship rel = this.createRelationship();
        rel.setEnd1Id(end1.getId());
        rel.setEnd2Id(end2.getId());
        sheet.addRelationship(rel);
        return rel;
    }

    @Override
    public IBoundary createBoundary() {
        BoundaryImpl boundary = new BoundaryImpl(this.implementation.createElement("boundary"), this);
        this.getAdaptableRegistry().registerByNode(boundary, boundary.getImplementation());
        return boundary;
    }

    @Override
    public ISummary createSummary() {
        SummaryImpl summary = new SummaryImpl(this.implementation.createElement("summary"), this);
        this.getAdaptableRegistry().registerByNode(summary, summary.getImplementation());
        return summary;
    }

    @Override
    public INotesContent createNotesContent(String format) {
        Element e = this.implementation.createElement(format);
        BaseNotesContentImpl content = "html".equals(format) ? new HtmlNotesContentImpl(e, this) : new PlainNotesContentImpl(e, this);
        this.getAdaptableRegistry().registerByNode(content, e);
        return content;
    }

    @Override
    public String getVersion() {
        return DOMUtils.getAttribute(this.getWorkbookElement(), "version");
    }

    @Override
    public List<ISheet> getSheets() {
        return DOMUtils.getChildList(this.getWorkbookElement(), "sheet", this.getAdaptableRegistry());
    }

    @Override
    public SheetImpl getPrimarySheet() {
        Element e = DOMUtils.getFirstChildElementByTag(this.getWorkbookElement(), "sheet");
        if (e != null) {
            return (SheetImpl)this.getAdaptableRegistry().getAdaptable(e);
        }
        return null;
    }

    @Override
    public void addSheet(ISheet sheet, int index) {
        Element s = ((SheetImpl)sheet).getImplementation();
        if (s != null && s.getOwnerDocument() == this.implementation) {
            Element w = this.getWorkbookElement();
            Node n = null;
            Element[] es = DOMUtils.getChildElementsByTag(w, "sheet");
            n = index >= 0 && index < es.length ? w.insertBefore(s, es[index]) : w.appendChild(s);
            if (n != null) {
                ((SheetImpl)sheet).addNotify(this);
                this.fireIndexedTargetChange("sheetAdd", sheet, sheet.getIndex());
                this.updateModificationInfo();
            }
        }
    }

    @Override
    public void removeSheet(ISheet sheet) {
        Element s = ((SheetImpl)sheet).getImplementation();
        Element w = this.getWorkbookElement();
        if (s != null && s.getParentNode() == w) {
            int oldIndex = sheet.getIndex();
            ((SheetImpl)sheet).removeNotify(this);
            Node n = w.removeChild(s);
            if (n != null) {
                this.fireIndexedTargetChange("sheetRemove", sheet, oldIndex);
                this.updateModificationInfo();
            }
        }
    }

    @Override
    public void moveSheet(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex == targetIndex) {
            return;
        }
        Element w = this.getWorkbookElement();
        Element[] ss = DOMUtils.getChildElementsByTag(w, "sheet");
        if (sourceIndex >= ss.length) {
            return;
        }
        Element s = ss[sourceIndex];
        if (targetIndex >= 0 && targetIndex < ss.length - 1) {
            int realTargetIndex = sourceIndex < targetIndex ? targetIndex + 1 : targetIndex;
            Element target = ss[realTargetIndex];
            if (s != target) {
                w.removeChild(s);
                w.insertBefore(s, target);
            }
        } else {
            w.removeChild(s);
            w.appendChild(s);
            targetIndex = ss.length - 1;
        }
        if (sourceIndex != targetIndex) {
            this.fireIndexedTargetChange("sheetMove", this.getAdaptableRegistry().getAdaptable(s), sourceIndex);
            this.updateModificationInfo();
        }
    }

    @Override
    public StyleSheetImpl getStyleSheet() {
        if (this.styleSheet == null) {
            this.setStyleSheet(this.createStyleSheet());
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheetImpl styleSheet) {
        StyleSheetImpl oldStyleSheet = this.styleSheet;
        if (styleSheet == oldStyleSheet) {
            return;
        }
        if (oldStyleSheet != null) {
            oldStyleSheet.getCoreEventSupport().setParent(null);
        }
        this.styleSheet = styleSheet;
        if (styleSheet != null) {
            styleSheet.getCoreEventSupport().setParent(this.getCoreEventSupport());
        }
    }

    protected StyleSheetImpl createStyleSheet() {
        StyleSheetImpl ss = (StyleSheetImpl)Core.getStyleSheetBuilder().createStyleSheet();
        this.getManifest().createFileEntry("styles.xml", "text/xml").increaseReference();
        ss.setManifest(this.getManifest());
        return ss;
    }

    @Override
    public ManifestImpl getManifest() {
        return this.manifest;
    }

    @Override
    public MarkerSheetImpl getMarkerSheet() {
        if (this.markerSheet == null) {
            this.setMarkerSheet(this.createMarkerSheet());
        }
        return this.markerSheet;
    }

    protected MarkerSheetImpl createMarkerSheet() {
        MarkerSheetImpl ms = (MarkerSheetImpl)Core.getMarkerSheetBuilder().createMarkerSheet(new WorkbookMarkerResourceProvider(this));
        ms.setManifest(this.getManifest());
        return ms;
    }

    public void setMarkerSheet(MarkerSheetImpl markerSheet) {
        MarkerSheetImpl oldMarkerSheet = this.markerSheet;
        if (markerSheet == oldMarkerSheet) {
            return;
        }
        if (oldMarkerSheet != null) {
            oldMarkerSheet.getCoreEventSupport().setParent(null);
            for (IMarkerGroup oldMarkerGroup : oldMarkerSheet.getMarkerGroups()) {
                this.handleMarkerGroupManagement(oldMarkerGroup, false);
            }
        }
        this.markerSheet = markerSheet;
        if (markerSheet != null) {
            for (IMarkerGroup newMarkerGroup : markerSheet.getMarkerGroups()) {
                this.handleMarkerGroupManagement(newMarkerGroup, true);
            }
            markerSheet.getCoreEventSupport().setParent(this.getCoreEventSupport());
        }
    }

    @Override
    public MetaImpl getMeta() {
        if (this.meta == null) {
            this.meta = this.createMeta();
        }
        return this.meta;
    }

    private MetaImpl createMeta() {
        Document metaImpl = DOMUtils.createDocument();
        MetaImpl meta = new MetaImpl(metaImpl);
        meta.setOwnedWorkbook(this);
        return meta;
    }

    public void setMeta(MetaImpl meta) {
        if (meta == null) {
            throw new IllegalArgumentException("Meta is null");
        }
        MetaImpl oldMeta = this.meta;
        this.meta = meta;
        if (oldMeta != null) {
            oldMeta.setOwnedWorkbook(null);
        }
        meta.setOwnedWorkbook(this);
    }

    protected WorkbookMarkerRefCounter getMarkerRefCounter() {
        if (this.markerRefCounter == null) {
            this.markerRefCounter = new WorkbookMarkerRefCounter(this);
        }
        return this.markerRefCounter;
    }

    protected WorkbookStyleRefCounter getStyleRefCounter() {
        if (this.styleRefCounter == null) {
            this.styleRefCounter = new WorkbookStyleRefCounter(this.getStyleSheet(), this.manifest);
        }
        return this.styleRefCounter;
    }

    protected WorkbookComponentRefCounter getElementRefCounter() {
        if (this.elementRefCounter == null) {
            this.elementRefCounter = new WorkbookComponentRefCounter(this);
        }
        return this.elementRefCounter;
    }

    @Override
    public IRevisionRepository getRevisionRepository() {
        if (this.revisionRepository == null) {
            this.revisionRepository = new RevisionRepositoryImpl(this);
        }
        return this.revisionRepository;
    }

    @Override
    public ICloneData clone(Collection<? extends Object> sources) {
        return WorkbookUtilsImpl.clone(this, sources, null);
    }

    @Override
    public IAdaptable importElement(IAdaptable source) {
        Node node = source.getAdapter(Node.class);
        if (node == null) {
            return null;
        }
        Node ele = this.getImplementation().importNode(node, true);
        return this.getAdaptableRegistry().getAdaptable(ele);
    }

    @Override
    public IResourceRef createResourceRef(String resourceType, String resourceId) {
        Element ele = this.implementation.createElement("resource-ref");
        ele.setAttribute("type", resourceType);
        ele.setAttribute("resource-id", resourceId);
        ResourceRefImpl ref = new ResourceRefImpl(ele, this);
        this.getAdaptableRegistry().registerByNode(ref, ele);
        return ref;
    }

    @Override
    public Object findElement(String id, IAdaptable source) {
        Node node;
        Node node2 = node = source == null ? null : source.getAdapter(Node.class);
        if (node == null) {
            node = this.getImplementation();
        }
        return this.getAdaptableRegistry().getAdaptable(id, DOMUtils.getOwnerDocument(node));
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        if (node instanceof Element) {
            String parentName;
            Element e = (Element)node;
            String tagName = e.getNodeName();
            if ("sheet".equals(tagName)) {
                return new SheetImpl(e, this);
            }
            if ("topic".equals(tagName)) {
                return new TopicImpl(e, this);
            }
            if ("relationship".equals(tagName)) {
                return new RelationshipImpl(e, this);
            }
            if ("marker-ref".equals(tagName)) {
                return new MarkerRefImpl(e, this);
            }
            if ("boundary".equals(tagName)) {
                return new BoundaryImpl(e, this);
            }
            if ("summary".equals(tagName)) {
                return new SummaryImpl(e, this);
            }
            if ("resource-ref".equals(tagName)) {
                return new ResourceRefImpl(e, this);
            }
            Node p = node.getParentNode();
            if (p != null && p instanceof Element && "notes".equals(parentName = p.getNodeName())) {
                String format = tagName;
                if ("html".equals(format)) {
                    return new HtmlNotesContentImpl(e, this);
                }
                if ("plain".equals(format)) {
                    return new PlainNotesContentImpl(e, this);
                }
            }
        }
        return null;
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            this.coreEventSupport = new CoreEventSupport();
        }
        return this.coreEventSupport;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventRegistration registerOnceCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerOnceCoreEventListener(this, type, listener);
    }

    @Override
    public boolean hasOnceListeners(String type) {
        return this.coreEventSupport != null && this.coreEventSupport.hasOnceListeners(this, type);
    }

    private void fireIndexedTargetChange(String type, Object target, int index) {
        if (this.coreEventSupport != null) {
            this.coreEventSupport.dispatchIndexedTargetChange(this, type, target, index);
        }
    }

    @Override
    @Deprecated
    public synchronized void save() throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public synchronized void save(String file) throws IOException, CoreException {
        FileOutputStream stream = new FileOutputStream(file);
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(this);
            serializer.setOutputStream(stream);
            serializer.serialize(null);
        }
        finally {
            stream.close();
        }
    }

    @Override
    @Deprecated
    public synchronized void save(IOutputTarget target) throws IOException, CoreException {
        ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
        serializer.setWorkbook(this);
        serializer.setOutputTarget(target);
        serializer.serialize(null);
    }

    @Override
    @Deprecated
    public synchronized void save(OutputStream output) throws IOException, CoreException {
        ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
        serializer.setWorkbook(this);
        serializer.setOutputStream(output);
        serializer.serialize(null);
    }

    @Override
    @Deprecated
    public void setTempStorage(IStorage storage) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IStorage getTempStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setFile(String file) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isSkipRevisionsWhenSaving() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getTempLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setTempLocation(String tempLocation) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setPassword(String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getPassword() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void saveTemp() throws IOException, CoreException {
        ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
        serializer.setWorkbook(this);
        serializer.setWorkbookStorageAsOutputTarget();
        serializer.serialize(null);
    }

    @Override
    public long getModifiedTime() {
        return InternalDOMUtils.getModifiedTime(this, this.getWorkbookElement());
    }

    @Override
    public String getModifiedBy() {
        return InternalDOMUtils.getModifiedBy(this, this.getWorkbookElement());
    }

    protected void updateModificationInfo() {
        InternalDOMUtils.updateModificationInfo(this);
    }

    @Override
    public ICommentManager getCommentManager() {
        if (this.commentManager == null) {
            this.commentManager = this.createCommentManager();
        }
        return this.commentManager;
    }

    private CommentManagerImpl createCommentManager() {
        return new CommentManagerImpl(this, DOMUtils.createDocument());
    }

    public void setCommentManager(CommentManagerImpl commentManager) {
        this.commentManager = commentManager;
    }

    private void handleMarkerSheetEvent(CoreEvent event) {
        String type = event.getType();
        if ("markerAdd".equals(type)) {
            this.handleMarkerManagement((IMarker)event.getTarget(), true);
        } else if ("markerRemove".equals(type)) {
            this.handleMarkerManagement((IMarker)event.getTarget(), false);
        } else if ("markerGroupAdd".equals(type)) {
            this.handleMarkerGroupManagement((IMarkerGroup)event.getTarget(), true);
        } else if ("markerGroupRemove".equals(type)) {
            this.handleMarkerGroupManagement((IMarkerGroup)event.getTarget(), false);
        }
    }

    private void handleMarkerManagement(IMarker marker, boolean added) {
        String path = marker.getResourcePath();
        if (path == null || "".equals(path)) {
            return;
        }
        IFileEntry entry = this.getManifest().getFileEntry("markers/" + path);
        if (entry == null) {
            return;
        }
        if (added) {
            entry.increaseReference();
        } else {
            entry.decreaseReference();
        }
    }

    private void handleMarkerGroupManagement(IMarkerGroup group, boolean added) {
        for (IMarker marker : group.getMarkers()) {
            this.handleMarkerManagement(marker, added);
        }
    }

    private IWorkbookExtensionManager getWorkbookExtensionManager() {
        if (this.extensionManager == null) {
            this.extensionManager = new WorkbookExtensionManagerImpl();
            this.extensionManager.setOwnedWorkbook(this);
        }
        return this.extensionManager;
    }
}

