/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yccheok.jstock.trading.api.Account;
import org.yccheok.jstock.trading.api.Commission;
import org.yccheok.jstock.trading.api.SessionManager;

public class User {
    public final String userID;
    public final String username;
    public final String displayName;
    public final String firstName;
    public final String lastName;
    public final String addressLine1;
    public final String addressLine2;
    public final String city;
    public final String stateProvince;
    public final String zipPostalCode;
    public final String countryID;
    public final String languageID;
    private final List<Account> accounts = new ArrayList<Account>();
    private Account activeAccount = null;
    private Commission commission = null;
    private String avatarUrl;
    private String emailAddress1;
    private String phoneHome;
    final Map<String, String> languageMap = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("en_US", "English");
            this.put("zh_CN", "Chinese");
            this.put("es_ES", "Spanish");
            this.put("pt_BR", "Portuguese");
            this.put("ja_JP", "Japanese");
        }
    });

    public User(Map<String, Object> session, Map<String, Object> userParams) {
        this.userID = session.get("userID").toString();
        ArrayList accs = (ArrayList)session.get("accounts");
        for (Map accMap : accs) {
            Account acc = new Account(accMap);
            this.accounts.add(acc);
            if (this.commission != null || !accMap.containsKey("commissionSchedule")) continue;
            LinkedTreeMap comm = (LinkedTreeMap)accMap.get("commissionSchedule");
            this.commission = new Commission((Double)comm.get((Object)"baseRate"), (Double)comm.get((Object)"baseShares"), (Double)comm.get((Object)"excessRate"), (Double)comm.get((Object)"fractionalRate"));
        }
        this.username = userParams.containsKey("username") ? userParams.get("username").toString() : null;
        this.displayName = userParams.containsKey("displayName") ? userParams.get("displayName").toString() : null;
        this.firstName = userParams.containsKey("firstName") ? userParams.get("firstName").toString() : null;
        this.lastName = userParams.containsKey("lastName") ? userParams.get("lastName").toString() : null;
        this.addressLine1 = userParams.containsKey("addressLine1") ? userParams.get("addressLine1").toString() : null;
        this.addressLine2 = userParams.containsKey("addressLine2") ? userParams.get("addressLine2").toString() : null;
        this.city = userParams.containsKey("city") ? userParams.get("city").toString() : null;
        this.stateProvince = userParams.containsKey("stateProvince") ? userParams.get("stateProvince").toString() : null;
        this.zipPostalCode = userParams.containsKey("zipPostalCode") ? userParams.get("zipPostalCode").toString() : null;
        this.countryID = userParams.containsKey("countryID") ? userParams.get("countryID").toString() : null;
        this.languageID = userParams.containsKey("languageID") ? userParams.get("languageID").toString() : null;
        this.emailAddress1 = userParams.containsKey("emailAddress1") ? userParams.get("emailAddress1").toString() : null;
        this.phoneHome = userParams.containsKey("phoneHome") ? userParams.get("phoneHome").toString() : null;
        this.avatarUrl = userParams.containsKey("avatarUrl") ? userParams.get("avatarUrl").toString() : null;
    }

    public String getLanguage() {
        String langID = this.languageID;
        if (langID == null || langID.isEmpty()) {
            return null;
        }
        if (this.languageMap.containsKey(langID)) {
            return this.languageMap.get(langID);
        }
        return null;
    }

    public String getEmailAddress1() {
        return this.emailAddress1;
    }

    public void setEmailAddress1(String email) {
        this.emailAddress1 = email;
    }

    public String getPhoneHome() {
        return this.phoneHome;
    }

    public void setPhoneHome(String phone) {
        this.phoneHome = phone;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String url) {
        this.avatarUrl = url;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public List<Account> getPracticeAccounts() {
        return this.getAccountsByType(SessionManager.AccType.PRACTICE);
    }

    public List<Account> getLiveAccounts() {
        return this.getAccountsByType(SessionManager.AccType.LIVE);
    }

    private List<Account> getAccountsByType(SessionManager.AccType accType) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (Account acc : this.accounts) {
            if (acc.accType != accType) continue;
            accounts.add(acc);
        }
        return accounts;
    }

    public void setActiveAccount(Account account) {
        this.activeAccount = account;
    }

    public Account getActiveAccount() {
        return this.activeAccount;
    }
}

