/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.StampDuty;
import org.yccheok.jstock.portfolio.Utils;

public class SimpleStampDuty
implements StampDuty {
    private double maximumRate;
    private double fraction;
    private double rate;
    @Deprecated
    private transient String name;

    public SimpleStampDuty(double maximumRate, double fraction, double rate) {
        this.maximumRate = maximumRate;
        this.fraction = fraction;
        this.rate = rate;
    }

    @Deprecated
    public SimpleStampDuty(String name, double maximumRate, double fraction, double rate) {
        this.name = name;
        this.maximumRate = maximumRate;
        this.fraction = fraction;
        this.rate = rate;
    }

    public SimpleStampDuty(SimpleStampDuty simpleStampDuty) {
        this.name = simpleStampDuty.getName();
        this.maximumRate = simpleStampDuty.getMaximumRate();
        this.fraction = simpleStampDuty.getFraction();
        this.rate = simpleStampDuty.getRate();
    }

    @Override
    public double calculate(Contract contract) {
        if (this.fraction <= 0.0) {
            return 0.0;
        }
        int numOfFraction = (int)(contract.getTotal() / this.fraction);
        double remainder = contract.getTotal() - (double)numOfFraction * this.fraction;
        double total = this.rate * (double)numOfFraction;
        if (remainder > 0.0) {
            total += this.rate;
        }
        if (!Utils.essentiallyEqual(this.maximumRate, 0.0) && total > this.maximumRate) {
            return this.maximumRate;
        }
        return total;
    }

    public double getMaximumRate() {
        return this.maximumRate;
    }

    public double getFraction() {
        return this.fraction;
    }

    public double getRate() {
        return this.rate;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setMaximumRate(double maximumRate) {
        this.maximumRate = maximumRate;
    }

    public void setFraction(double fraction) {
        this.fraction = fraction;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }
}

