/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.news;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.news.GoogleFinanceNewsServer;
import org.yccheok.jstock.news.GoogleSearchNewsServer;
import org.yccheok.jstock.news.NewsServer;
import org.yccheok.jstock.news.NewsSource;
import org.yccheok.jstock.news.YahooFinanceNewsServer;

public class NewsServerFactory {
    private static final Map<NewsSource, Set<Class<? extends NewsServer>>> newsSourceMap = new EnumMap<NewsSource, Set<Class<? extends NewsServer>>>(NewsSource.class);
    private static final Map<Country, List<NewsServer>> map = new EnumMap<Country, List<NewsServer>>(Country.class);

    public static List<NewsServer> getNewsServers(Country country) {
        return map.get((Object)country);
    }

    public static void updateNewsSource(Country country, NewsSource newsSource) {
        final Set<Class<? extends NewsServer>> classes = newsSourceMap.get(newsSource);
        if (classes == null) {
            return;
        }
        List<NewsServer> newsServers = map.get((Object)country);
        if (null == newsServers) {
            return;
        }
        ArrayList<NewsServer> tmp = new ArrayList<NewsServer>(newsServers);
        Collections.sort(tmp, new Comparator<NewsServer>(){

            @Override
            public int compare(NewsServer o1, NewsServer o2) {
                boolean result1 = classes.contains(o1.getClass());
                boolean result2 = classes.contains(o2.getClass());
                if (result1 && !result2) {
                    return -1;
                }
                if (!result1 && result2) {
                    return 1;
                }
                return 0;
            }
        });
        int ei = tmp.size();
        for (int i = 0; i < ei; ++i) {
            NewsServer f = (NewsServer)tmp.get(i);
            if (f == newsServers.get(i)) continue;
            newsServers.set(i, f);
        }
    }

    static {
        HashSet<Class<GoogleFinanceNewsServer>> googleSet = new HashSet<Class<GoogleFinanceNewsServer>>();
        HashSet<Class<GoogleSearchNewsServer>> googleSearchSet = new HashSet<Class<GoogleSearchNewsServer>>();
        HashSet<Class<YahooFinanceNewsServer>> yahooSet = new HashSet<Class<YahooFinanceNewsServer>>();
        CopyOnWriteArrayList<NewsServer> argentinaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> australiaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> austriaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> belgiumList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> brazilList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> canadaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> chinaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> denmarkList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> finlandList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> franceList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> germanyList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> hongkongList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> indiaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> indonesiaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> israelList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> italyList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> japanList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<NewsServer> koreaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> malaysiaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> netherlandsList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> newZealandList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> norwayList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> polandList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<NewsServer> portugalList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> russiaList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> saudiArabiaList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<NewsServer> singaporeList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> southAfricaList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> spainList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<NewsServer> swedenList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> switzerlandList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> taiwanList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> thailandList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<GoogleFinanceNewsServer> turkeyList = new CopyOnWriteArrayList<GoogleFinanceNewsServer>();
        CopyOnWriteArrayList<NewsServer> unitedKingdomList = new CopyOnWriteArrayList<NewsServer>();
        CopyOnWriteArrayList<NewsServer> unitedStateList = new CopyOnWriteArrayList<NewsServer>();
        googleSet.add(GoogleFinanceNewsServer.class);
        googleSearchSet.add(GoogleSearchNewsServer.class);
        yahooSet.add(YahooFinanceNewsServer.class);
        argentinaList.add(new YahooFinanceNewsServer());
        argentinaList.add(new GoogleFinanceNewsServer());
        australiaList.add(new YahooFinanceNewsServer());
        australiaList.add(new GoogleFinanceNewsServer());
        austriaList.add(new YahooFinanceNewsServer());
        austriaList.add(new GoogleFinanceNewsServer());
        belgiumList.add(new YahooFinanceNewsServer());
        belgiumList.add(new GoogleFinanceNewsServer());
        brazilList.add(new YahooFinanceNewsServer());
        brazilList.add(new GoogleFinanceNewsServer());
        canadaList.add(new YahooFinanceNewsServer());
        canadaList.add(new GoogleFinanceNewsServer());
        chinaList.add(new YahooFinanceNewsServer());
        chinaList.add(new GoogleFinanceNewsServer());
        denmarkList.add(new YahooFinanceNewsServer());
        denmarkList.add(new GoogleFinanceNewsServer());
        finlandList.add(new GoogleFinanceNewsServer());
        finlandList.add(new YahooFinanceNewsServer());
        franceList.add(new YahooFinanceNewsServer());
        franceList.add(new GoogleFinanceNewsServer());
        germanyList.add(new YahooFinanceNewsServer());
        germanyList.add(new GoogleSearchNewsServer());
        hongkongList.add(new YahooFinanceNewsServer());
        hongkongList.add(new GoogleFinanceNewsServer());
        indiaList.add(new YahooFinanceNewsServer());
        indiaList.add(new GoogleFinanceNewsServer());
        indonesiaList.add(new YahooFinanceNewsServer());
        indonesiaList.add(new GoogleFinanceNewsServer());
        israelList.add(new YahooFinanceNewsServer());
        israelList.add(new GoogleFinanceNewsServer());
        italyList.add(new YahooFinanceNewsServer());
        italyList.add(new GoogleFinanceNewsServer());
        japanList.add(new GoogleFinanceNewsServer());
        koreaList.add(new YahooFinanceNewsServer());
        koreaList.add(new GoogleFinanceNewsServer());
        malaysiaList.add(new YahooFinanceNewsServer());
        malaysiaList.add(new GoogleFinanceNewsServer());
        netherlandsList.add(new YahooFinanceNewsServer());
        netherlandsList.add(new GoogleFinanceNewsServer());
        newZealandList.add(new YahooFinanceNewsServer());
        newZealandList.add(new GoogleFinanceNewsServer());
        norwayList.add(new YahooFinanceNewsServer());
        norwayList.add(new GoogleSearchNewsServer());
        polandList.add(new GoogleFinanceNewsServer());
        portugalList.add(new YahooFinanceNewsServer());
        portugalList.add(new GoogleFinanceNewsServer());
        russiaList.add(new GoogleFinanceNewsServer());
        russiaList.add(new YahooFinanceNewsServer());
        saudiArabiaList.add(new GoogleFinanceNewsServer());
        singaporeList.add(new YahooFinanceNewsServer());
        singaporeList.add(new GoogleFinanceNewsServer());
        southAfricaList.add(new GoogleFinanceNewsServer());
        spainList.add(new GoogleFinanceNewsServer());
        swedenList.add(new YahooFinanceNewsServer());
        swedenList.add(new GoogleFinanceNewsServer());
        switzerlandList.add(new YahooFinanceNewsServer());
        switzerlandList.add(new GoogleSearchNewsServer());
        taiwanList.add(new YahooFinanceNewsServer());
        taiwanList.add(new GoogleFinanceNewsServer());
        thailandList.add(new GoogleFinanceNewsServer());
        turkeyList.add(new GoogleFinanceNewsServer());
        unitedKingdomList.add(new YahooFinanceNewsServer());
        unitedKingdomList.add(new GoogleFinanceNewsServer());
        unitedStateList.add(new YahooFinanceNewsServer());
        unitedStateList.add(new GoogleFinanceNewsServer());
        newsSourceMap.put(NewsSource.Google, googleSet);
        newsSourceMap.put(NewsSource.GoogleSearch, googleSearchSet);
        newsSourceMap.put(NewsSource.Yahoo, yahooSet);
        map.put(Country.Argentina, argentinaList);
        map.put(Country.Australia, australiaList);
        map.put(Country.Austria, austriaList);
        map.put(Country.Belgium, belgiumList);
        map.put(Country.Brazil, brazilList);
        map.put(Country.Canada, canadaList);
        map.put(Country.China, chinaList);
        map.put(Country.Denmark, denmarkList);
        map.put(Country.Finland, finlandList);
        map.put(Country.France, franceList);
        map.put(Country.Germany, germanyList);
        map.put(Country.HongKong, hongkongList);
        map.put(Country.India, indiaList);
        map.put(Country.Indonesia, indonesiaList);
        map.put(Country.Israel, israelList);
        map.put(Country.Italy, italyList);
        map.put(Country.Japan, japanList);
        map.put(Country.Korea, koreaList);
        map.put(Country.Malaysia, malaysiaList);
        map.put(Country.Netherlands, netherlandsList);
        map.put(Country.NewZealand, newZealandList);
        map.put(Country.Norway, norwayList);
        map.put(Country.Poland, polandList);
        map.put(Country.Portugal, portugalList);
        map.put(Country.Russia, russiaList);
        map.put(Country.SaudiArabia, saudiArabiaList);
        map.put(Country.Singapore, singaporeList);
        map.put(Country.SouthAfrica, southAfricaList);
        map.put(Country.Spain, spainList);
        map.put(Country.Sweden, swedenList);
        map.put(Country.Switzerland, switzerlandList);
        map.put(Country.Taiwan, taiwanList);
        map.put(Country.Thailand, thailandList);
        map.put(Country.Turkey, turkeyList);
        map.put(Country.UnitedKingdom, unitedKingdomList);
        map.put(Country.UnitedState, unitedStateList);
    }
}

