/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.news;

import it.sauronsoftware.feed4j.FeedException;
import it.sauronsoftware.feed4j.FeedParser;
import it.sauronsoftware.feed4j.bean.Feed;
import it.sauronsoftware.feed4j.bean.FeedItem;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.news.NewsServer;
import org.yccheok.jstock.news.Utils;

public class GoogleSearchNewsServer
implements NewsServer {
    private static final String TAG = GoogleSearchNewsServer.class.getSimpleName();
    private static final Log log = LogFactory.getLog(GoogleSearchNewsServer.class);

    @Override
    public List<FeedItem> getMessages(StockInfo stockInfo) {
        String feedUrl = this.googleSearchNewsFeedUrl(stockInfo);
        ArrayList<FeedItem> messages = new ArrayList<FeedItem>();
        if (feedUrl == null) {
            return messages;
        }
        HashSet<String> titles = new HashSet<String>();
        try {
            URL url = new URL(feedUrl);
            Feed feed = FeedParser.parse((URL)url);
            int items = feed.getItemCount();
            block2: for (int i = 0; i < items; ++i) {
                FeedItem message = feed.getItem(i);
                message.setPubDate(Utils.getProperPubDate(message));
                if (message.getLink() == null || message.getTitle() == null || message.getTitle().isEmpty() || message.getPubDate() == null) continue;
                for (String paidNewsUrl : Utils.getPaidNewsUrls()) {
                    if (!message.getLink().toString().contains(paidNewsUrl)) continue;
                    continue block2;
                }
                String title = message.getTitle();
                if (!titles.add(title)) continue;
                messages.add(message);
            }
        }
        catch (FeedException | MalformedURLException ex) {
            log.error(null, ex);
        }
        return messages;
    }

    private String googleSearchNewsFeedUrl(StockInfo stockInfo) {
        Country c = org.yccheok.jstock.engine.Utils.toCountry(stockInfo.code);
        if (c == Country.UnitedState) {
            try {
                String query = URLEncoder.encode(stockInfo.symbol.toString(), "UTF-8");
                String url = "https://news.google.com/news/feeds?output=rss&q=" + query;
                return url;
            }
            catch (UnsupportedEncodingException ex) {
                log.error(null, (Throwable)ex);
            }
        } else {
            try {
                String location = URLEncoder.encode(c.humanString, "UTF-8");
                String query = URLEncoder.encode(stockInfo.symbol.toString() + " " + location, "UTF-8");
                String url = "https://news.google.com/news/feeds?output=rss&q=" + query + "&as_nloc=" + location;
                return url;
            }
            catch (UnsupportedEncodingException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        return null;
    }
}

