/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.List;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.CreateOrderDlg;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.gui.trading.SignIn;
import org.yccheok.jstock.trading.api.Instrument;
import org.yccheok.jstock.trading.api.InstrumentManager;
import org.yccheok.jstock.trading.api.OrderManager;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;

public class TradingView {
    private static final Log log = LogFactory.getLog(TradingView.class);
    private final StackPane stackPane = new StackPane();
    private static final TradingView INSTANCE = new TradingView();
    private Node signIn = null;
    private Node portfolio = null;
    private VBox progBox = null;

    private TradingView() {
    }

    public static TradingView getInstance() {
        return INSTANCE;
    }

    public Parent getRoot() {
        return this.stackPane;
    }

    public void showLogin() {
        this.stackPane.getChildren().clear();
        this.signIn = SignIn.getInstance().show();
        this.stackPane.getChildren().add((Object)this.signIn);
        this.portfolio = null;
        this.progBox = null;
    }

    public void showPortfolio() {
        this.stackPane.getChildren().clear();
        this.portfolio = Portfolio.getInstance().show();
        this.stackPane.getChildren().add((Object)this.portfolio);
        this.signIn = null;
        this.progBox = null;
    }

    public void showProgIndicator() {
        ProgressIndicator pi = new ProgressIndicator();
        this.progBox = new VBox(new Node[]{pi});
        this.progBox.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)this.progBox);
        this.portfolio.setDisable(true);
    }

    public void removeProgIndicator() {
        if (this.progBox != null && this.stackPane.getChildren().contains((Object)this.progBox)) {
            this.stackPane.getChildren().remove((Object)this.progBox);
        }
        this.portfolio.setDisable(false);
    }

    public boolean isLoggedIn() {
        User user = SessionManager.getInstance().getUser();
        return user != null && user.getActiveAccount() != null;
    }

    public boolean isPortfolioShowing() {
        return this.isLoggedIn() && this.portfolio != null && this.stackPane.getChildren().contains((Object)this.portfolio);
    }

    public long getTimestamp() {
        if (this.isPortfolioShowing()) {
            return Portfolio.getInstance().getTimestamp();
        }
        return 0L;
    }

    public void refreshPortfolio() {
        if (this.isPortfolioShowing()) {
            Portfolio.getInstance().cancelService();
            Portfolio.getInstance().restartService();
        }
    }

    public void showBuyDialog(final String symbol) {
        if (symbol == null || symbol.isEmpty() || !this.isPortfolioShowing()) {
            return;
        }
        Task<List<Instrument>> task = new Task<List<Instrument>>(){

            protected List<Instrument> call() {
                List<Instrument> list = InstrumentManager.searchExactSymbol(symbol);
                return list;
            }
        };
        task.setOnSucceeded(arg_0 -> TradingView.lambda$showBuyDialog$0((Task)task, arg_0));
        task.setOnFailed(ev -> log.error((Object)"TradingView.showBuyDialog Task Failed"));
        task.setOnCancelled(ev -> log.error((Object)"TradingView.showBuyDialog Task cancelled"));
        new Thread((Runnable)task).start();
    }

    private static /* synthetic */ void lambda$showBuyDialog$0(Task task, WorkerStateEvent t) {
        List result = (List)task.getValue();
        if (result == null || result.isEmpty()) {
            log.warn((Object)"TradingView.showBuyDialog Task - Result NULL or EMPTY");
            return;
        }
        Instrument ins = (Instrument)result.get(0);
        CreateOrderDlg dlg = new CreateOrderDlg(ins, OrderManager.OrderSide.BUY);
        dlg.initDlgAndWait();
    }
}

