/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.ReportManager;

public class Report {
    private static final Report INSTANCE = new Report();
    private static final Log log = LogFactory.getLog(Report.class);
    private VBox reportBox;
    private StackPane reportStack;
    private ProgressIndicator reportPi;
    private ComboBox<Object> typeCombo;
    private ChoiceBox<String> formatChoice;
    private DatePicker startDate;
    private DatePicker endDate;
    private Button getReportBtn;
    private Button closeBtn;
    private TextField dirText;
    private Dialog listStmtDlg;
    private BooleanBinding dirValid;

    public static Report getInstance() {
        return INSTANCE;
    }

    public Node show() {
        this.initUI();
        this.setBtnHandler();
        this.setBtnBinding();
        return this.reportStack;
    }

    private void initUI() {
        Label title = new Label(DriveWealthBundle.getString("Reports"));
        title.getStyleClass().addAll((Object[])new String[]{"title", "underline"});
        Label typeLbl = new Label(DriveWealthBundle.getString("Report_type"));
        Label formatLbl = new Label(DriveWealthBundle.getString("Report_format"));
        Label startLbl = new Label(DriveWealthBundle.getString("Start_date"));
        Label endLbl = new Label(DriveWealthBundle.getString("End_date"));
        Label dirLbl = new Label(DriveWealthBundle.getString("Save_to_directory"));
        this.initTypeCombo();
        this.formatChoice = new ChoiceBox();
        this.formatChoice.getItems().setAll((Object[])new String[]{"PDF", "XLS"});
        this.formatChoice.setValue((Object)"PDF");
        this.startDate = new DatePicker();
        this.startDate = GUIUtils.setDatePickerFormat(this.startDate);
        this.endDate = new DatePicker();
        this.endDate = GUIUtils.setDatePickerFormat(this.endDate);
        LocalDate today = LocalDate.now();
        this.endDate.setValue((Object)today);
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, 1);
        LocalDateTime dateTime = LocalDateTime.ofInstant(cal.toInstant(), ZoneId.of("UTC"));
        LocalDate beginLastMonth = dateTime.toLocalDate();
        this.startDate.setValue((Object)beginLastMonth);
        this.dirText = new TextField();
        this.dirText.setPrefWidth(300.0);
        Button dirChooserBtn = new Button(DriveWealthBundle.getString("Select"));
        HBox dirBox = new HBox();
        dirBox.setSpacing(10.0);
        dirBox.getChildren().addAll((Object[])new Node[]{this.dirText, dirChooserBtn});
        dirChooserBtn.setOnAction(ev -> {
            DirectoryChooser dirChooser = new DirectoryChooser();
            File dir = dirChooser.showDialog(null);
            if (dir != null) {
                this.dirText.setText(dir.getAbsolutePath());
            }
        });
        this.getReportBtn = new Button(DriveWealthBundle.getString("Get_report"));
        this.getReportBtn.getStyleClass().add((Object)"green-btn");
        this.getReportBtn.setMinWidth(120.0);
        this.closeBtn = new Button(DriveWealthBundle.getString("Close"));
        this.closeBtn.getStyleClass().add((Object)"green-btn");
        this.closeBtn.setMinWidth(120.0);
        HBox btnBox = new HBox();
        btnBox.setSpacing(50.0);
        btnBox.setAlignment(Pos.CENTER);
        btnBox.getChildren().addAll((Object[])new Node[]{this.getReportBtn, this.closeBtn});
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.BOTTOM_CENTER);
        grid.setHgap(20.0);
        grid.setVgap(0.0);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        col1.setHalignment(HPos.RIGHT);
        col2.setHalignment(HPos.LEFT);
        grid.getColumnConstraints().add((Object)col1);
        grid.getColumnConstraints().add((Object)col2);
        int i = 0;
        grid.addRow(i++, new Node[]{typeLbl, this.typeCombo});
        grid.addRow(i++, new Node[]{formatLbl, this.formatChoice});
        grid.addRow(i++, new Node[]{startLbl, this.startDate});
        grid.addRow(i++, new Node[]{endLbl, this.endDate});
        grid.addRow(i++, new Node[]{dirLbl, dirBox});
        GridPane.setMargin(this.formatChoice, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)this.startDate, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)this.endDate, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)dirBox, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)formatLbl, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)startLbl, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)endLbl, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        GridPane.setMargin((Node)dirLbl, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        formatLbl.disableProperty().bind((ObservableValue)this.formatChoice.disableProperty());
        startLbl.disableProperty().bind((ObservableValue)this.startDate.disableProperty());
        endLbl.disableProperty().bind((ObservableValue)this.endDate.disableProperty());
        this.endDate.disableProperty().bind((ObservableValue)this.startDate.disableProperty());
        dirLbl.disableProperty().bind((ObservableValue)dirBox.disableProperty());
        dirBox.disableProperty().bind((ObservableValue)this.formatChoice.disableProperty());
        formatLbl.visibleProperty().bind((ObservableValue)formatLbl.disableProperty().not());
        this.formatChoice.visibleProperty().bind((ObservableValue)this.formatChoice.disableProperty().not());
        formatLbl.managedProperty().bind((ObservableValue)formatLbl.visibleProperty());
        this.formatChoice.managedProperty().bind((ObservableValue)this.formatChoice.visibleProperty());
        startLbl.visibleProperty().bind((ObservableValue)startLbl.disableProperty().not());
        this.startDate.visibleProperty().bind((ObservableValue)this.startDate.disableProperty().not());
        startLbl.managedProperty().bind((ObservableValue)startLbl.visibleProperty());
        this.startDate.managedProperty().bind((ObservableValue)this.startDate.visibleProperty());
        endLbl.visibleProperty().bind((ObservableValue)endLbl.disableProperty().not());
        this.endDate.visibleProperty().bind((ObservableValue)this.endDate.disableProperty().not());
        endLbl.managedProperty().bind((ObservableValue)endLbl.visibleProperty());
        this.endDate.managedProperty().bind((ObservableValue)this.endDate.visibleProperty());
        dirLbl.visibleProperty().bind((ObservableValue)dirLbl.disableProperty().not());
        dirBox.visibleProperty().bind((ObservableValue)dirBox.disableProperty().not());
        dirLbl.managedProperty().bind((ObservableValue)dirLbl.visibleProperty());
        dirBox.managedProperty().bind((ObservableValue)dirBox.visibleProperty());
        VBox innerBox = new VBox();
        innerBox.getStyleClass().add((Object)"rounded-white-box");
        innerBox.setMaxWidth(600.0);
        innerBox.setAlignment(Pos.CENTER);
        innerBox.setSpacing(20.0);
        innerBox.setPadding(new Insets(20.0, 0.0, 50.0, 0.0));
        innerBox.getChildren().addAll((Object[])new Node[]{title, grid});
        this.reportBox = new VBox();
        this.reportBox.getStyleClass().add((Object)"border-box");
        this.reportBox.setSpacing(20.0);
        this.reportBox.setPadding(new Insets(40.0, 0.0, 20.0, 0.0));
        this.reportBox.setAlignment(Pos.TOP_CENTER);
        this.reportBox.getChildren().addAll((Object[])new Node[]{innerBox, btnBox});
        this.reportStack = new StackPane();
        this.reportStack.setAlignment(Pos.CENTER);
        this.reportStack.getChildren().add((Object)this.reportBox);
    }

    private void initTypeCombo() {
        this.typeCombo = new ComboBox();
        this.typeCombo.getItems().setAll(new Object[]{ReportManager.ReportName.FIN_TRANS, ReportManager.ReportName.ORDER_TRANS, ReportManager.ReportName.POSITION_RESTING_ORDER, ReportManager.ReportName.INSTRUMENT, ReportManager.StatementType.STATEMENTS, ReportManager.StatementType.TRADE_CONFIRMS, ReportManager.StatementType.DOCUMENTS_1099_B});
        this.typeCombo.setValue((Object)ReportManager.ReportName.FIN_TRANS);
        this.typeCombo.getSelectionModel().selectedItemProperty().addListener((observableValue, oldVal, newVal) -> {
            boolean noDate = false;
            boolean noFormat = false;
            if (newVal instanceof ReportManager.ReportName) {
                ReportManager.ReportName name = (ReportManager.ReportName)((Object)((Object)newVal));
                if (name == ReportManager.ReportName.POSITION_RESTING_ORDER || name == ReportManager.ReportName.INSTRUMENT) {
                    noDate = true;
                }
            } else if (newVal instanceof ReportManager.StatementType) {
                ReportManager.StatementType name = (ReportManager.StatementType)((Object)((Object)newVal));
                if (name == ReportManager.StatementType.DOCUMENTS_1099_B) {
                    noDate = true;
                }
                noFormat = true;
            }
            this.formatChoice.setDisable(noFormat);
            this.startDate.setDisable(noDate);
            this.dirValid.invalidate();
        });
    }

    private void setBtnHandler() {
        this.getReportBtn.setOnAction(ev -> {
            this.disableReportPage();
            if (this.typeCombo.getValue() instanceof ReportManager.ReportName) {
                this.startReportTask();
            } else {
                this.startListStmtTask();
            }
        });
        this.closeBtn.setOnAction(e -> Portfolio.getInstance().removeReportIfShowing());
    }

    private void setBtnBinding() {
        BooleanBinding dateValid = Bindings.createBooleanBinding(() -> {
            if (this.startDate.isDisabled() && this.endDate.isDisabled()) {
                return true;
            }
            LocalDate sd = (LocalDate)this.startDate.getValue();
            LocalDate ed = (LocalDate)this.endDate.getValue();
            return sd != null && ed != null && ed.isAfter(sd);
        }, (Observable[])new Observable[]{this.startDate.valueProperty(), this.startDate.disableProperty(), this.endDate.valueProperty(), this.endDate.disableProperty()});
        BooleanBinding formatValid = Bindings.createBooleanBinding(() -> {
            if (this.formatChoice.isDisabled()) {
                return true;
            }
            return this.formatChoice != null;
        }, (Observable[])new Observable[]{this.formatChoice.valueProperty(), this.formatChoice.disableProperty()});
        this.dirValid = Bindings.createBooleanBinding(() -> {
            if (this.dirText.isDisabled()) {
                return true;
            }
            return !this.dirText.getText().isEmpty();
        }, (Observable[])new Observable[]{this.dirText.textProperty()});
        this.getReportBtn.disableProperty().unbind();
        this.getReportBtn.disableProperty().bind((ObservableValue)dateValid.and((ObservableBooleanValue)formatValid).and((ObservableBooleanValue)this.dirValid).and((ObservableBooleanValue)this.typeCombo.valueProperty().isNotNull()).not());
    }

    private void disableReportPage() {
        this.reportPi = new ProgressIndicator();
        this.reportPi.setMaxHeight(30.0);
        this.reportStack.getChildren().add((Object)this.reportPi);
        this.reportBox.setDisable(true);
    }

    private void enableReportPage() {
        if (this.reportStack.getChildren().contains((Object)this.reportPi)) {
            this.reportStack.getChildren().remove((Object)this.reportPi);
        }
        this.reportBox.setDisable(false);
    }

    private void showListStmtDlg(final ReportManager.StatementType stmtType, List<Map<String, Object>> fileList) {
        this.listStmtDlg = new Dialog();
        GUIUtils.setDlgTitleHeader(this.listStmtDlg, DriveWealthBundle.getString("Generate_report"), stmtType.toString());
        VBox contentBox = new VBox();
        contentBox.setSpacing(20.0);
        Label note = new Label(DriveWealthBundle.getString("Click_link_to_view_report"));
        contentBox.getChildren().add((Object)note);
        VBox linkBox = new VBox();
        linkBox.setSpacing(10.0);
        final HashMap<String, String> linkMap = new HashMap<String, String>();
        for (Map<String, Object> a : fileList) {
            String name = a.get("displayName").toString();
            String file = a.get("fileKey").toString();
            linkMap.put(name, file);
            final Hyperlink link = new Hyperlink(name);
            link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ev) {
                    String fileKey = (String)linkMap.get(link.getText());
                    Task task = Report.this.startGetStmtTask(fileKey);
                    task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                        public void handle(WorkerStateEvent workerStateEvent) {
                            String url = (String)workerStateEvent.getSource().getValue();
                            if (url != null && !url.isEmpty()) {
                                GUIUtils.openURLInBrowser(url);
                            } else {
                                Report.this.showFailedDlg(stmtType.toString());
                            }
                        }
                    });
                    task.setOnCancelled(e -> {
                        log.error((Object)"Get Statement API task is cancelled");
                        Report.this.showFailedDlg(stmtType.toString());
                    });
                    task.setOnFailed(e -> {
                        log.error((Object)"Get Statement API task has failed");
                        Report.this.showFailedDlg(stmtType.toString());
                    });
                }
            });
            linkBox.getChildren().add((Object)link);
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)linkBox);
        scrollPane.setPrefHeight(200.0);
        contentBox.getChildren().add((Object)scrollPane);
        GUIUtils.setDlgContent(this.listStmtDlg, (Node)contentBox, null, null);
        ButtonType cancelBtnType = new ButtonType(DriveWealthBundle.getString("Cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.listStmtDlg.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{cancelBtnType});
        this.listStmtDlg.show();
    }

    private Pair<String, String> getStartEndDate() {
        String startStr = null;
        if (this.startDate.getValue() != null) {
            startStr = ((LocalDate)this.startDate.getValue()).toString() + "T00:00:00.000Z";
        }
        String endStr = null;
        if (this.endDate.getValue() != null) {
            endStr = ((LocalDate)this.endDate.getValue()).toString() + "T23:59:59.999Z";
        }
        return new Pair<Object, Object>(startStr, endStr);
    }

    private Task<Pair<Boolean, String>> startReportTask() {
        final ReportManager.ReportName type = (ReportManager.ReportName)((Object)this.typeCombo.getValue());
        Pair<String, String> dates = this.getStartEndDate();
        final String startStr = (String)dates.first;
        final String endStr = (String)dates.second;
        final String format = (String)this.formatChoice.getValue();
        final String filename = type == ReportManager.ReportName.FIN_TRANS || type == ReportManager.ReportName.ORDER_TRANS ? this.dirText.getText() + "/" + type.value + "_" + ((LocalDate)this.startDate.getValue()).toString().replaceAll("-", "") + "_" + ((LocalDate)this.endDate.getValue()).toString().replaceAll("-", "") + "." + format.toLowerCase() : this.dirText.getText() + "/" + type.value + "." + format.toLowerCase();
        log.info((Object)("Report filename: " + filename));
        Task<String> task = new Task<String>(){

            protected String call() throws Exception {
                Boolean status = null;
                switch (type) {
                    case FIN_TRANS: {
                        status = ReportManager.financialTxn(filename, format, startStr, endStr);
                        break;
                    }
                    case ORDER_TRANS: {
                        status = ReportManager.orderTxn(filename, format, startStr, endStr, null);
                        break;
                    }
                    case POSITION_RESTING_ORDER: {
                        status = ReportManager.openPosRestingOrder(filename, format);
                        break;
                    }
                    case INSTRUMENT: {
                        status = ReportManager.stocksOffered(filename, format);
                        break;
                    }
                }
                if (status == null || !status.booleanValue()) {
                    return null;
                }
                return filename;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent workerStateEvent) {
                Report.this.enableReportPage();
                String filename = (String)workerStateEvent.getSource().getValue();
                if (filename == null || filename.isEmpty()) {
                    log.error((Object)"Download report failed");
                    Report.this.showFailedDlg(type.toString());
                    return;
                }
                File reportFile = new File(filename);
                try {
                    Desktop.getDesktop().open(reportFile);
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        });
        task.setOnCancelled(e -> {
            log.error((Object)"Report API task is cancelled");
            this.enableReportPage();
            this.showFailedDlg(type.toString());
        });
        task.setOnFailed(e -> {
            log.error((Object)"Report API task has failed");
            this.enableReportPage();
            this.showFailedDlg(type.toString());
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        return task;
    }

    private Task<List<Map<String, Object>>> startListStmtTask() {
        final ReportManager.StatementType type = (ReportManager.StatementType)((Object)this.typeCombo.getValue());
        Pair<String, String> dates = this.getStartEndDate();
        final String startStr = (String)dates.first;
        final String endStr = (String)dates.second;
        Task<List<Map<String, Object>>> task = new Task<List<Map<String, Object>>>(){

            protected List<Map<String, Object>> call() throws Exception {
                List<Map<String, Object>> result = null;
                switch (type) {
                    case TRADE_CONFIRMS: {
                        result = ReportManager.listStatements(ReportManager.StatementType.TRADE_CONFIRMS, startStr, endStr);
                        break;
                    }
                    case STATEMENTS: {
                        result = ReportManager.listStatements(ReportManager.StatementType.STATEMENTS, startStr, endStr);
                        break;
                    }
                    case DOCUMENTS_1099_B: {
                        result = ReportManager.listStatements(ReportManager.StatementType.DOCUMENTS_1099_B, startStr, endStr);
                        break;
                    }
                }
                return result;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent workerStateEvent) {
                Report.this.enableReportPage();
                List result = (List)workerStateEvent.getSource().getValue();
                if (result == null || result.isEmpty()) {
                    Alert dlg = GUIUtils.alertDlg(Alert.AlertType.INFORMATION, DriveWealthBundle.getString("Generate_report"), type.toString(), "No report found.");
                    dlg.show();
                    return;
                }
                Report.this.showListStmtDlg(type, result);
            }
        });
        task.setOnCancelled(e -> {
            log.error((Object)"Statement API task is cancelled");
            this.enableReportPage();
            this.showFailedDlg(type.toString());
        });
        task.setOnFailed(e -> {
            log.error((Object)"Statement API task has failed");
            this.enableReportPage();
            this.showFailedDlg(type.toString());
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        return task;
    }

    private Task<String> startGetStmtTask(final String fileKey) {
        Task<String> task = new Task<String>(){

            protected String call() throws Exception {
                return ReportManager.getStatement(fileKey);
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
        return task;
    }

    private void showFailedDlg(String reportName) {
        Alert dlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Generate_report_fail"), reportName, ApiError.commonMsg());
        dlg.show();
    }
}

