/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.HashMap;
import java.util.Map;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.AccountSummaryHeader;
import org.yccheok.jstock.gui.trading.CancelOrderDlg;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.CountryUtils;
import org.yccheok.jstock.trading.api.SessionManager;
import org.yccheok.jstock.trading.api.User;
import org.yccheok.jstock.trading.api.UserManager;

public class Profile {
    private static final Profile INSTANCE = new Profile();
    private static final Log log = LogFactory.getLog(CancelOrderDlg.class);
    private VBox vBox;
    private StackPane stackPane;
    private ProgressIndicator pi;
    private Button editBtn;
    private Button saveBtn;
    private Button closeBtn;
    private Label email;
    private TextField emailT;
    private Label phone;
    private TextField phoneT;

    public static Profile getInstance() {
        return INSTANCE;
    }

    public Node show() {
        this.initUI();
        this.setBtnHandler();
        return this.stackPane;
    }

    public void initUI() {
        User user = SessionManager.getInstance().getUser();
        this.editBtn = new Button(DriveWealthBundle.getString("Edit"));
        this.editBtn.getStyleClass().add((Object)"green-btn");
        this.editBtn.setMinWidth(80.0);
        this.saveBtn = new Button(DriveWealthBundle.getString("Save"));
        this.saveBtn.getStyleClass().add((Object)"green-btn");
        this.saveBtn.setMinWidth(80.0);
        StackPane btnStake = new StackPane();
        btnStake.getChildren().addAll((Object[])new Node[]{this.saveBtn, this.editBtn});
        this.editBtn.setVisible(true);
        this.saveBtn.setVisible(false);
        this.closeBtn = new Button(DriveWealthBundle.getString("Close"));
        this.closeBtn.getStyleClass().add((Object)"green-btn");
        this.closeBtn.setMinWidth(80.0);
        HBox btnBox = new HBox();
        btnBox.setSpacing(50.0);
        btnBox.setAlignment(Pos.CENTER);
        btnBox.getChildren().addAll((Object[])new Node[]{btnStake, this.closeBtn});
        Label title = new Label(DriveWealthBundle.getString("Profile"));
        title.getStyleClass().addAll((Object[])new String[]{"title", "underline"});
        Label lfirstname = new Label(DriveWealthBundle.getString("First_name") + " :");
        Label llastname = new Label(DriveWealthBundle.getString("Last_name") + " :");
        Label laddress1 = new Label(DriveWealthBundle.getString("Address") + " :");
        Label lcity = new Label(DriveWealthBundle.getString("City") + " :");
        Label lstate = new Label(DriveWealthBundle.getString("State") + " :");
        Label lzipCode = new Label(DriveWealthBundle.getString("Zip") + " :");
        Label lcountryID = new Label(DriveWealthBundle.getString("Country") + " :");
        Label lemail = new Label(DriveWealthBundle.getString("Email") + " :");
        Label llanguageID = new Label(DriveWealthBundle.getString("Language") + " :");
        Label lphone = new Label(DriveWealthBundle.getString("Phone_number") + " :");
        Label firstname = new Label(user.firstName);
        Label lastname = new Label(user.lastName);
        Label address1 = new Label(user.addressLine1);
        Label address2 = new Label(user.addressLine2);
        Label city = new Label(user.city);
        Label state = new Label(user.stateProvince);
        Label zipCode = new Label(user.zipPostalCode);
        String translatedCountryName = CountryUtils.getInstance().getTranslatedName(user.countryID);
        Label countryID = new Label(translatedCountryName);
        Label languageID = new Label(user.getLanguage());
        this.email = new Label(user.getEmailAddress1());
        this.emailT = new TextField(user.getEmailAddress1());
        StackPane emailStack = new StackPane();
        emailStack.setAlignment(Pos.CENTER_LEFT);
        emailStack.getChildren().addAll((Object[])new Node[]{this.email, this.emailT});
        this.email.setVisible(true);
        this.emailT.setVisible(false);
        this.phone = new Label(user.getPhoneHome());
        this.phoneT = new TextField(user.getPhoneHome());
        StackPane phoneStack = new StackPane();
        phoneStack.setAlignment(Pos.CENTER_LEFT);
        phoneStack.getChildren().addAll((Object[])new Node[]{this.phone, this.phoneT});
        this.phone.setVisible(true);
        this.phoneT.setVisible(false);
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(20.0);
        grid.setVgap(10.0);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        col1.setHalignment(HPos.RIGHT);
        col2.setHalignment(HPos.LEFT);
        grid.getColumnConstraints().add((Object)col1);
        grid.getColumnConstraints().add((Object)col2);
        int i = 0;
        grid.addRow(i++, new Node[]{lfirstname, firstname});
        grid.addRow(i++, new Node[]{llastname, lastname});
        grid.addRow(i++, new Node[]{laddress1, address1});
        grid.add((Node)address2, 1, i++);
        grid.addRow(i++, new Node[]{lcity, city});
        grid.addRow(i++, new Node[]{lstate, state});
        grid.addRow(i++, new Node[]{lzipCode, zipCode});
        grid.addRow(i++, new Node[]{lcountryID, countryID});
        grid.addRow(i++, new Node[]{lemail, emailStack});
        grid.addRow(i++, new Node[]{llanguageID, languageID});
        grid.addRow(i++, new Node[]{lphone, phoneStack});
        VBox innerBox = new VBox();
        innerBox.getStyleClass().add((Object)"rounded-white-box");
        innerBox.setMaxWidth(600.0);
        innerBox.setAlignment(Pos.CENTER);
        innerBox.setSpacing(20.0);
        innerBox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        innerBox.getChildren().addAll((Object[])new Node[]{title, grid});
        this.vBox = new VBox();
        this.vBox.getStyleClass().add((Object)"border-box");
        this.vBox.setSpacing(15.0);
        this.vBox.setPadding(new Insets(20.0, 0.0, 15.0, 0.0));
        this.vBox.setAlignment(Pos.TOP_CENTER);
        this.vBox.getChildren().addAll((Object[])new Node[]{innerBox, btnBox});
        this.stackPane = new StackPane();
        this.stackPane.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)this.vBox);
    }

    private void setBtnHandler() {
        this.editBtn.setOnAction(e -> {
            this.email.setVisible(false);
            this.phone.setVisible(false);
            this.emailT.setVisible(true);
            this.phoneT.setVisible(true);
            this.editBtn.setVisible(false);
            this.saveBtn.setVisible(true);
        });
        this.saveBtn.setOnAction(e -> {
            this.pi = new ProgressIndicator();
            this.pi.setMaxHeight(30.0);
            this.stackPane.getChildren().add((Object)this.pi);
            this.vBox.setDisable(true);
            Task<Pair<Boolean, Map<String, Object>>> task = new Task<Pair<Boolean, Map<String, Object>>>(){

                protected Pair<Boolean, Map<String, Object>> call() {
                    String email = Profile.this.emailT.getText().trim();
                    String phone = Profile.this.phoneT.getText().trim();
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put("emailAddress1", email);
                    args.put("phoneHome", phone);
                    String userID = SessionManager.getInstance().getUser().userID;
                    Boolean result = UserManager.updateUser(userID, args);
                    if (result.booleanValue()) {
                        Map<String, Object> userMap = UserManager.getUser(userID);
                        return new Pair<Boolean, Map<String, Object>>(true, userMap);
                    }
                    return new Pair<Boolean, Object>(false, null);
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.start();
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    Pair result = (Pair)workerStateEvent.getSource().getValue();
                    Boolean status = (Boolean)result.first;
                    Map userMap = (Map)result.second;
                    if (status.booleanValue()) {
                        Profile.this.stackPane.getChildren().remove((Object)Profile.this.pi);
                        Profile.this.vBox.setDisable(false);
                        if (userMap != null) {
                            String emailStr = null;
                            String phoneStr = null;
                            String avatar = null;
                            if (userMap.containsKey("emailAddress1")) {
                                emailStr = userMap.get("emailAddress1").toString();
                            }
                            if (userMap.containsKey("phoneHome")) {
                                phoneStr = userMap.get("phoneHome").toString();
                            }
                            if (userMap.containsKey("avatarUrl")) {
                                avatar = userMap.get("avatarUrl").toString();
                            }
                            User user = SessionManager.getInstance().getUser();
                            user.setEmailAddress1(emailStr);
                            user.setPhoneHome(phoneStr);
                            user.setAvatarUrl(avatar);
                            AccountSummaryHeader.getInstance().updateAvatar();
                            Profile.this.email.setText(emailStr);
                            Profile.this.phone.setText(phoneStr);
                        }
                        Profile.this.emailT.setVisible(false);
                        Profile.this.phoneT.setVisible(false);
                        Profile.this.email.setVisible(true);
                        Profile.this.phone.setVisible(true);
                        Profile.this.editBtn.setVisible(true);
                        Profile.this.saveBtn.setVisible(false);
                    } else {
                        log.warn((Object)"Profile - Update User API failed");
                        Profile.this.showUpdateError();
                    }
                }
            });
            task.setOnCancelled(ev -> {
                log.warn((Object)"Profile - Update User task is cancelled");
                this.showUpdateError();
            });
            task.setOnFailed(ev -> {
                log.warn((Object)"Profile - Update User task has failed");
                this.showUpdateError();
            });
        });
        this.closeBtn.setOnAction(e -> Portfolio.getInstance().removeProfileIfShowing());
    }

    private void showUpdateError() {
        this.stackPane.getChildren().remove((Object)this.pi);
        this.vBox.setDisable(false);
        Alert dlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Update_profile"), null, ApiError.commonMsg());
        dlg.show();
    }
}

