/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.PauseTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.trading.CancelOrderDlg;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.Portfolio;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.OpenPosition;
import org.yccheok.jstock.trading.PendingOrder;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.Instrument;

public class OrdersTable {
    private static final Log log = LogFactory.getLog(OrdersTable.class);
    private static final OrdersTable INSTANCE = new OrdersTable();
    private TableView<PendingOrder> ordTable;
    private ObservableList<PendingOrder> ordList;
    TableColumn<PendingOrder, OpenPosition.SymbolUrl> symbolCol;
    private final ObjectProperty<List<? extends PendingOrder>> recentlyAdded = new SimpleObjectProperty();
    private boolean isChangeListenerSet = false;

    private OrdersTable() {
    }

    public static OrdersTable getInstance() {
        return INSTANCE;
    }

    public ObservableList<PendingOrder> getOrdList() {
        return this.ordList;
    }

    private void setChangeListener() {
        Duration timeToGetOld = Duration.seconds((double)5.0);
        this.ordTable.getItems().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                List addedList = change.getAddedSubList();
                ArrayList newList = new ArrayList();
                newList.addAll(addedList);
                this.recentlyAdded.set(newList);
                PauseTransition agingTime = new PauseTransition(timeToGetOld);
                agingTime.setOnFinished(event -> {
                    if (this.recentlyAdded.get() == newList) {
                        this.recentlyAdded.set(null);
                    }
                });
                agingTime.play();
            }
        });
    }

    private void setRowContextMenu() {
        this.ordTable.setRowFactory((Callback)new Callback<TableView<PendingOrder>, TableRow<PendingOrder>>(){

            public TableRow<PendingOrder> call(TableView<PendingOrder> tableView) {
                TableRow<PendingOrder> row = new TableRow<PendingOrder>(){
                    private final BooleanBinding itemIsNew;
                    {
                        this.itemIsNew = Bindings.createBooleanBinding(() -> {
                            if (this.itemProperty() != null && this.itemProperty().get() != null && OrdersTable.this.recentlyAdded.get() != null && ((List)OrdersTable.this.recentlyAdded.get()).contains(this.itemProperty().get())) {
                                return true;
                            }
                            return false;
                        }, (Observable[])new Observable[]{this.itemProperty(), OrdersTable.this.recentlyAdded});
                        this.itemIsNew.addListener((obs, wasNew, isNew) -> this.pseudoClassStateChanged(GUIUtils.newRow, (boolean)isNew));
                    }
                };
                ContextMenu rowMenu = new ContextMenu();
                MenuItem cancelItem = new MenuItem(DriveWealthBundle.getString("Cancel"));
                cancelItem.setOnAction((EventHandler)new EventHandler<ActionEvent>((TableRow)row){
                    final /* synthetic */ TableRow val$row;
                    {
                        this.val$row = tableRow;
                    }

                    public void handle(ActionEvent event) {
                        CancelOrderDlg dlg = new CancelOrderDlg((PendingOrder)this.val$row.getItem());
                        dlg.initDlgAndWait();
                    }
                });
                rowMenu.getItems().addAll((Object[])new MenuItem[]{cancelItem});
                row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise((Object)null));
                return row;
            }
        });
    }

    private void symbolColComparator() {
        class SymbolComparator
        implements Comparator<OpenPosition.SymbolUrl> {
            SymbolComparator() {
            }

            @Override
            public int compare(OpenPosition.SymbolUrl o1, OpenPosition.SymbolUrl o2) {
                return o1.getSymbol().compareTo(o2.getSymbol());
            }
        }
        this.symbolCol.setComparator((Comparator)new SymbolComparator());
    }

    public TableView show() {
        this.ordTable = new TableView();
        this.symbolCol = new TableColumn(DriveWealthBundle.getString("Symbol"));
        this.symbolCol.setCellValueFactory((Callback)new PropertyValueFactory("symbolObj"));
        this.symbolCol.setCellFactory(col -> new SymbolCell());
        this.symbolCol.getStyleClass().add((Object)"left");
        this.symbolColComparator();
        TableColumn nameCol = new TableColumn(DriveWealthBundle.getString("Company"));
        nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameCol.getStyleClass().add((Object)"left");
        TableColumn orderQtyCol = new TableColumn(DriveWealthBundle.getString("Order_qty"));
        orderQtyCol.setCellValueFactory((Callback)new PropertyValueFactory("orderQty"));
        orderQtyCol.setCellFactory(col -> new OrderQtyCell());
        orderQtyCol.getStyleClass().add((Object)"right");
        TableColumn cumQtyCol = new TableColumn(DriveWealthBundle.getString("Cumulative_qty"));
        cumQtyCol.setCellValueFactory((Callback)new PropertyValueFactory("cumQty"));
        cumQtyCol.setCellFactory(col -> new CumQtyCell());
        cumQtyCol.getStyleClass().add((Object)"right");
        TableColumn cashCol = new TableColumn(DriveWealthBundle.getString("Cash_amount"));
        cashCol.setCellValueFactory((Callback)new PropertyValueFactory("orderCashAmt"));
        cashCol.setCellFactory(col -> new DoubleCell());
        cashCol.getStyleClass().add((Object)"right");
        TableColumn mktPriceCol = new TableColumn(DriveWealthBundle.getString("Current_price"));
        mktPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("marketPrice"));
        mktPriceCol.setCellFactory(col -> new MarketPriceCell());
        mktPriceCol.getStyleClass().add((Object)"right");
        TableColumn typeCol = new TableColumn(DriveWealthBundle.getString("Order_type"));
        typeCol.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        typeCol.getStyleClass().add((Object)"left");
        TableColumn sideCol = new TableColumn(DriveWealthBundle.getString("Action"));
        sideCol.setCellValueFactory((Callback)new PropertyValueFactory("side"));
        sideCol.getStyleClass().add((Object)"left");
        TableColumn ordPriceCol = new TableColumn(DriveWealthBundle.getString("Order_price"));
        ordPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("orderPrice"));
        ordPriceCol.setCellFactory(col -> new DoubleCell());
        ordPriceCol.getStyleClass().add((Object)"right");
        TableColumn statusCol = new TableColumn(DriveWealthBundle.getString("Status"));
        statusCol.setCellValueFactory((Callback)new PropertyValueFactory("orderStatus"));
        statusCol.setCellFactory(col -> new OrderStatusCell());
        statusCol.getStyleClass().add((Object)"left");
        TableColumn cancelCol = new TableColumn(DriveWealthBundle.getString("Cancel_order"));
        cancelCol.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        cancelCol.setCellFactory(col -> new TableCell<PendingOrder, PendingOrder>(){
            final Button cancelBtn = new Button(DriveWealthBundle.getString("Cancel"));

            public void updateItem(final PendingOrder item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!this.isEmpty()) {
                    this.setGraphic((Node)this.cancelBtn);
                    this.setAlignment(Pos.CENTER);
                    this.cancelBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent e) {
                            CancelOrderDlg dlg = new CancelOrderDlg(item);
                            dlg.initDlgAndWait();
                        }
                    });
                } else {
                    this.setGraphic(null);
                }
            }
        });
        cancelCol.setSortable(false);
        this.ordTable.getColumns().setAll((Object[])new TableColumn[]{this.symbolCol, nameCol, orderQtyCol, cumQtyCol, cashCol, mktPriceCol, typeCol, sideCol, ordPriceCol, statusCol, cancelCol});
        this.ordTable.setEditable(false);
        this.ordTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.ordTable.setPlaceholder((Node)new Label());
        this.ordTable.setTableMenuButtonVisible(true);
        this.setTableModel();
        return this.ordTable;
    }

    public void setTableModel() {
        this.ordList = FXCollections.observableArrayList();
        this.ordTable.setItems(this.ordList);
        this.ordTable.setFixedCellSize(30.0);
        this.ordTable.prefHeightProperty().unbind();
        this.ordTable.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.ordTable.getItems()).multiply(this.ordTable.getFixedCellSize()).add(30.0));
        this.setRowContextMenu();
        this.isChangeListenerSet = false;
    }

    private void sortTable() {
        if (this.ordTable.getSortOrder().isEmpty()) {
            this.symbolCol.setSortType(TableColumn.SortType.ASCENDING);
            this.ordTable.getSortOrder().add(this.symbolCol);
        }
        this.ordTable.sort();
    }

    public void initData(List<PendingOrder> orders, Map<String, Instrument> instruments, Map<String, Double> marketPrices) {
        PendingOrder oldSelect = (PendingOrder)this.ordTable.getSelectionModel().getSelectedItem();
        String oldSym = oldSelect != null ? oldSelect.getSymbol() : null;
        HashMap<String, PendingOrder> newOrdMap = new HashMap<String, PendingOrder>();
        for (PendingOrder pendingOrder : orders) {
            newOrdMap.put(pendingOrder.getOrderID(), pendingOrder);
        }
        HashMap<String, PendingOrder> ordMap = new HashMap<String, PendingOrder>();
        for (Object ord : this.ordList) {
            ordMap.put(((PendingOrder)ord).getOrderID(), (PendingOrder)ord);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object ord : this.ordList) {
            String id = ((PendingOrder)ord).getOrderID();
            if (newOrdMap.containsKey(id)) {
                PendingOrder newOrd = (PendingOrder)newOrdMap.get(id);
                ((PendingOrder)ord).compareAndUpdate(newOrd);
                continue;
            }
            arrayList.add(ord);
            ordMap.remove(id);
        }
        if (!arrayList.isEmpty()) {
            this.ordList.removeAll(arrayList);
        }
        ArrayList<PendingOrder> addedList = new ArrayList<PendingOrder>();
        for (PendingOrder ord : orders) {
            String id = ord.getOrderID();
            if (ordMap.containsKey(id)) continue;
            addedList.add(ord);
            ordMap.put(id, ord);
        }
        if (!addedList.isEmpty()) {
            this.ordList.addAll(addedList);
        }
        if (!instruments.isEmpty()) {
            this.updateNameUrl(instruments);
        }
        this.updatePrices(marketPrices);
        this.sortTable();
        PendingOrder newSelect = null;
        for (PendingOrder ord : this.ordList) {
            if (!ord.getSymbol().equals(oldSym)) continue;
            newSelect = ord;
            break;
        }
        if (newSelect != null) {
            this.ordTable.getSelectionModel().select(newSelect);
        }
        if (!this.isChangeListenerSet) {
            this.setChangeListener();
            this.isChangeListenerSet = true;
        }
    }

    public void updateNameUrl(Map<String, Instrument> instruments) {
        for (PendingOrder ord : this.ordList) {
            String symbol = ord.getSymbol();
            if (!instruments.containsKey(symbol)) continue;
            Instrument ins = instruments.get(symbol);
            ord.setName(ins.name);
            ord.setUrlImage(ins.urlImage);
        }
    }

    public void updatePrices(Map<String, Double> marketPrices) {
        if (marketPrices == null || marketPrices.isEmpty()) {
            return;
        }
        for (PendingOrder ord : this.ordList) {
            String symbol = ord.getSymbol();
            if (!marketPrices.containsKey(symbol)) continue;
            ord.updatePrice(marketPrices.get(symbol));
        }
    }

    private static class OrderStatusCell
    extends TableCell<PendingOrder, String> {
        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setText(item);
            this.pseudoClassStateChanged(GUIUtils.downCell, false);
            if (this.getTableRow().getItem() == null) {
                return;
            }
            Boolean change = ((PendingOrder)this.getTableRow().getItem()).diff.orderStatusPty.get();
            if (!change.booleanValue()) {
                return;
            }
            this.pseudoClassStateChanged(GUIUtils.downCell, true);
            PauseTransition agingTime = new PauseTransition(Duration.seconds((double)5.0));
            agingTime.setOnFinished(event -> this.pseudoClassStateChanged(GUIUtils.downCell, false));
            agingTime.play();
        }
    }

    private static class MarketPriceCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((PendingOrder)this.getTableRow().getItem()).diff.marketPricePty.get();
        }
    }

    private static class CumQtyCell
    extends DoubleCell {
        @Override
        protected int comparePrevious() {
            if (this.getTableRow().getItem() == null) {
                return 0;
            }
            return ((PendingOrder)this.getTableRow().getItem()).diff.cumQtyPty.get();
        }

        @Override
        protected String formatDouble(Double item) {
            return Utils.formatNumber(item, 4);
        }
    }

    private static class OrderQtyCell
    extends DoubleCell {
        @Override
        protected String formatDouble(Double item) {
            return Utils.formatNumber(item, 4);
        }
    }

    private static class DoubleCell
    extends TableCell<PendingOrder, Double> {
        protected int comparePrevious() {
            return 0;
        }

        protected String formatDouble(Double item) {
            return Utils.monetaryFormat(item);
        }

        protected void updateItem(Double item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            this.setText(this.formatDouble(item));
            this.pseudoClassStateChanged(GUIUtils.upCell, false);
            this.pseudoClassStateChanged(GUIUtils.downCell, false);
            int diff = this.comparePrevious();
            if (diff == 0) {
                return;
            }
            PseudoClass pClass = diff > 0 ? GUIUtils.upCell : GUIUtils.downCell;
            this.pseudoClassStateChanged(pClass, true);
            PauseTransition agingTime = new PauseTransition(Duration.seconds((double)2.0));
            agingTime.setOnFinished(event -> {
                this.pseudoClassStateChanged(GUIUtils.upCell, false);
                this.pseudoClassStateChanged(GUIUtils.downCell, false);
            });
            agingTime.play();
        }
    }

    private class SymbolCell
    extends TableCell<PendingOrder, OpenPosition.SymbolUrl> {
        private final HBox hbox = new HBox();
        private final Label symLabel = new Label();
        private final ImageView imageView = new ImageView();

        public SymbolCell() {
            this.symLabel.setPrefWidth(70.0);
            this.imageView.setFitHeight(25.0);
            this.imageView.setFitWidth(25.0);
            this.hbox.setSpacing(10.0);
            this.hbox.setAlignment(Pos.CENTER_LEFT);
            this.hbox.getChildren().addAll((Object[])new Node[]{this.symLabel, this.imageView});
            this.setGraphic((Node)this.hbox);
        }

        protected void updateItem(OpenPosition.SymbolUrl item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                String symbol = item.getSymbol();
                String url = item.getUrl();
                this.symLabel.setText(symbol);
                if (url != null && !url.isEmpty()) {
                    this.imageView.setImage(Portfolio.getInstance().getIcon(url));
                } else {
                    this.imageView.setImage(null);
                }
            }
        }
    }
}

