/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.UserManager;

public class ForgotPassword {
    private static final ForgotPassword INSTANCE = new ForgotPassword();
    private static final Log log = LogFactory.getLog(ForgotPassword.class);
    private Dialog dlg;

    public static ForgotPassword getInstance() {
        return INSTANCE;
    }

    public Dialog show() {
        this.initUI();
        return this.dlg;
    }

    private void initUI() {
        this.dlg = new Dialog();
        DialogPane dlgPane = this.dlg.getDialogPane();
        dlgPane.getStylesheets().add((Object)this.getClass().getResource("/css/trading.css").toExternalForm());
        dlgPane.getStyleClass().add((Object)"lost-pwd-dlg");
        dlgPane.setPrefWidth(400.0);
        Label usernameLbl = new Label(DriveWealthBundle.getString("Username"));
        TextField usernameTxt = new TextField();
        GridPane.setHgrow((Node)usernameTxt, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)usernameTxt, (Boolean)true);
        GridPane grid = new GridPane();
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setAlignment(Pos.CENTER_LEFT);
        grid.addRow(0, new Node[]{usernameLbl, usernameTxt});
        String title = DriveWealthBundle.getString("Forgot_password");
        String header = DriveWealthBundle.getString("Enter_username_for_reset_password");
        GUIUtils.setDlgTitleHeader(this.dlg, title, header);
        GUIUtils.setDlgContent(this.dlg, (Node)grid, null, null);
        ButtonType okBtnType = new ButtonType(DriveWealthBundle.getString("Reset_password"), ButtonBar.ButtonData.OK_DONE);
        dlgPane.getButtonTypes().addAll((Object[])new ButtonType[]{okBtnType, ButtonType.CANCEL});
        ValidationSupport vs = new ValidationSupport();
        vs.initInitialDecoration();
        vs.registerValidator((Control)usernameTxt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Enter_username")));
        Node okBtn = dlgPane.lookupButton(okBtnType);
        okBtn.disableProperty().bind((ObservableValue)vs.invalidProperty());
        this.sendCodeBtnHandler(this.dlg, okBtn, usernameTxt);
    }

    private void sendCodeBtnHandler(final Dialog forgotDlg, Node okBtn, final TextField usernameTxt) {
        okBtn.addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            GUIUtils.dlgShowProgressIn(forgotDlg);
            Task<String> task = new Task<String>(){

                protected String call() throws Exception {
                    String username = usernameTxt.getText();
                    return UserManager.forgotPassword(username);
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.start();
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    String resetID = (String)workerStateEvent.getSource().getValue();
                    forgotDlg.close();
                    if (resetID == null) {
                        Alert dlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, DriveWealthBundle.getString("Forgot_password"), null, ApiError.commonMsg());
                        dlg.show();
                        return;
                    }
                    Dialog resetDlg = ForgotPassword.this.resetPwdDlg(resetID);
                    resetDlg.show();
                }
            });
            task.setOnCancelled(ev -> log.warn((Object)"Forgot password task is cancelled"));
            task.setOnFailed(ev -> log.warn((Object)"Forgot password task has failed"));
        });
    }

    private Dialog resetPwdDlg(String resetID) {
        Dialog dlg = new Dialog();
        DialogPane dlgPane = dlg.getDialogPane();
        dlgPane.getStylesheets().add((Object)this.getClass().getResource("/css/trading.css").toExternalForm());
        Label codeLbl = new Label(DriveWealthBundle.getString("Reset_code"));
        Label pwd1Lbl = new Label(DriveWealthBundle.getString("Enter_new_password"));
        Label pwd2Lbl = new Label(DriveWealthBundle.getString("Confirm_password"));
        TextField codeTxt = new TextField();
        PasswordField pwd1Txt = new PasswordField();
        PasswordField pwd2Txt = new PasswordField();
        GridPane.setHgrow((Node)codeTxt, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)codeTxt, (Boolean)true);
        GridPane.setHgrow((Node)pwd1Txt, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)pwd1Txt, (Boolean)true);
        GridPane.setHgrow((Node)pwd2Txt, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)pwd2Txt, (Boolean)true);
        GridPane grid = new GridPane();
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.setAlignment(Pos.CENTER_LEFT);
        grid.addRow(0, new Node[]{codeLbl, codeTxt});
        grid.addRow(1, new Node[]{pwd1Lbl, pwd1Txt});
        grid.addRow(2, new Node[]{pwd2Lbl, pwd2Txt});
        String title = DriveWealthBundle.getString("Forgot_password");
        String header = DriveWealthBundle.getString("Enter_reset_code_from_email");
        GUIUtils.setDlgTitleHeader(dlg, title, header);
        GUIUtils.setDlgContent(dlg, (Node)grid, null, null);
        Platform.runLater(() -> codeTxt.requestFocus());
        ButtonType okBtnType = new ButtonType(DriveWealthBundle.getString("Reset_password"), ButtonBar.ButtonData.OK_DONE);
        dlgPane.getButtonTypes().addAll((Object[])new ButtonType[]{okBtnType, ButtonType.CANCEL});
        ValidationSupport vs = new ValidationSupport();
        vs.initInitialDecoration();
        Platform.runLater(() -> {
            vs.registerValidator((Control)codeTxt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Please_enter_reset_code")));
            vs.registerValidator((Control)pwd1Txt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Please_enter_new_password")));
            vs.registerValidator((Control)pwd2Txt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Please_confirm_password")));
        });
        BooleanBinding pwd1Match = Bindings.createBooleanBinding(() -> pwd1Txt.getText().equals(pwd2Txt.getText()), (Observable[])new Observable[]{pwd1Txt.textProperty()});
        BooleanBinding pwd2Match = Bindings.createBooleanBinding(() -> pwd2Txt.getText().equals(pwd1Txt.getText()), (Observable[])new Observable[]{pwd2Txt.textProperty()});
        pwd2Txt.textProperty().addListener((observable, oldVal, newVal) -> pwd1Match.invalidate());
        pwd1Txt.textProperty().addListener((observable, oldVal, newVal) -> pwd2Match.invalidate());
        BooleanBinding passwordsMatch = pwd1Match.or((ObservableBooleanValue)pwd2Match);
        Node okBtn = dlgPane.lookupButton(okBtnType);
        okBtn.disableProperty().bind((ObservableValue)vs.invalidProperty().or((ObservableBooleanValue)passwordsMatch.not()));
        this.resetBtnHandler(resetID, dlg, okBtn, grid);
        return dlg;
    }

    private void resetBtnHandler(final String resetID, final Dialog resetDlg, Node okBtn, final GridPane grid) {
        okBtn.addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            GUIUtils.dlgShowProgressIn(resetDlg);
            Task<Boolean> task = new Task<Boolean>(){

                protected Boolean call() throws Exception {
                    TextField codeTxt = (TextField)GUIUtils.getNodeFromGridPane(grid, 0, 1);
                    PasswordField pwd1Txt = (PasswordField)GUIUtils.getNodeFromGridPane(grid, 1, 1);
                    PasswordField pwd2Txt = (PasswordField)GUIUtils.getNodeFromGridPane(grid, 2, 1);
                    String resetCode = codeTxt.getText();
                    String password = pwd1Txt.getText();
                    String password2 = pwd2Txt.getText();
                    return UserManager.resetPassword(resetID, resetCode, password);
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.start();
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    resetDlg.close();
                    String title = DriveWealthBundle.getString("Forgot_password");
                    Boolean status = (Boolean)workerStateEvent.getSource().getValue();
                    if (!status.booleanValue()) {
                        Alert dlg = GUIUtils.alertDlg(Alert.AlertType.ERROR, title, null, ApiError.commonMsg());
                        dlg.show();
                        return;
                    }
                    Alert dlg = GUIUtils.alertDlg(Alert.AlertType.INFORMATION, title, null, DriveWealthBundle.getString("Password_was_reset"));
                    dlg.show();
                }
            });
            task.setOnCancelled(ev -> log.warn((Object)"Reset password task is cancelled"));
            task.setOnFailed(ev -> log.warn((Object)"Reset password task has failed"));
        });
    }
}

