/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class RenameStockJDialog
extends JDialog {
    private final StockInfo originalStockInfo;
    private final PortfolioManagementJPanel portfolioManagementJPanel;
    private final MyDocumentListener documentListener = new MyDocumentListener();
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JXHeader jXHeader1;

    public RenameStockJDialog(Frame parent, boolean modal, StockInfo originalStockInfo, PortfolioManagementJPanel portfolioManagementJPanel) {
        super(parent, modal);
        this.originalStockInfo = originalStockInfo;
        this.portfolioManagementJPanel = portfolioManagementJPanel;
        this.initComponents();
        this.pack();
        Dimension dimension = JStock.instance().getUIOptions().getDimension("RENAME_STOCK_JDIALOG");
        if (dimension != null) {
            this.setSize(dimension);
        }
        ((AbstractDocument)this.jTextField2.getDocument()).setDocumentFilter(new UppercaseDocumentFilter());
        this.jTextField2.getDocument().addDocumentListener(this.documentListener);
        this.jTextField1.getDocument().addDocumentListener(this.documentListener);
        this.jTextField2.setText(originalStockInfo.code.toString());
        this.jTextField1.setText(originalStockInfo.symbol.toString());
        this.jTextField3.setText(originalStockInfo.code.toString());
        this.jTextField4.setText(originalStockInfo.symbol.toString());
        this.updateOkButton();
    }

    private String getNewCodeAsString() {
        String newCode = this.jTextField2.getText().trim();
        return newCode;
    }

    private String getNewSymbolAsString() {
        String newCode = this.jTextField1.getText().trim();
        return newCode;
    }

    private void updateOkButton() {
        String newCodeAsString = this.getNewCodeAsString();
        String newSymbolAsString = this.getNewSymbolAsString();
        if (newCodeAsString.isEmpty() || newSymbolAsString.isEmpty()) {
            this.jButton1.setEnabled(false);
            return;
        }
        if (!newCodeAsString.equalsIgnoreCase(this.originalStockInfo.code.toString())) {
            this.jButton1.setEnabled(true);
            return;
        }
        if (!newSymbolAsString.equals(this.originalStockInfo.symbol.toString())) {
            this.jButton1.setEnabled(true);
            return;
        }
        this.jButton1.setEnabled(false);
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jTextField4 = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("RenameStockJDialog_Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                RenameStockJDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jXHeader1.setDescription(bundle.getString("RenameStockJDialog_Description"));
        this.jXHeader1.setTitle(bundle.getString("RenameStockJDialog_Title"));
        this.getContentPane().add((Component)this.jXHeader1, "First");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("RenameStockJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameStockJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("RenameStockJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameStockJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setLayout(new GridLayout(2, 1, 5, 5));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameStockJDialog_Original")));
        this.jLabel3.setText(bundle.getString("RenameStockJDialog_OriginalCode"));
        this.jLabel3.setPreferredSize(new Dimension(76, 14));
        this.jLabel4.setText(bundle.getString("RenameStockJDialog_OriginalSymbol"));
        this.jLabel4.setMaximumSize(new Dimension(76, 14));
        this.jLabel4.setMinimumSize(new Dimension(76, 14));
        this.jLabel4.setPreferredSize(new Dimension(76, 14));
        this.jTextField3.setEditable(false);
        this.jTextField4.setEditable(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField4, -1, 200, Short.MAX_VALUE).addComponent(this.jTextField3)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.jTextField3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.jTextField4, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.add(this.jPanel3);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("RenameStockJDialog_New")));
        this.jLabel1.setText(bundle.getString("RenameStockDialog_NewCode"));
        this.jLabel2.setText(bundle.getString("RenameStockJDialog_NewSymbol"));
        this.jLabel2.setMaximumSize(new Dimension(76, 14));
        this.jLabel2.setMinimumSize(new Dimension(76, 14));
        this.jLabel2.setPreferredSize(new Dimension(76, 14));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -1, 200, Short.MAX_VALUE).addComponent(this.jTextField1)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.add(this.jPanel2);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setBounds(0, 0, 342, 330);
    }

    private void formWindowClosed(WindowEvent evt) {
        JStock.instance().getUIOptions().setDimension("RENAME_STOCK_JDIALOG", this.getSize());
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        StockInfo oldStockInfo;
        StockInfo newStockInfo;
        int result;
        String output;
        String newCodeAsString = this.getNewCodeAsString();
        String newSymbolAsString = this.getNewSymbolAsString();
        String oldCodeAsString = this.originalStockInfo.code.toString();
        String oldSymbolAsString = this.originalStockInfo.symbol.toString();
        if (!newCodeAsString.equals(oldCodeAsString)) {
            output = MessageFormat.format(MessagesBundle.getString("question_message_rename_code_template"), oldCodeAsString, newCodeAsString);
            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_rename"), 0, 3);
            if (result != 0) {
                return;
            }
        }
        if (!newSymbolAsString.equals(oldSymbolAsString)) {
            output = MessageFormat.format(MessagesBundle.getString("question_message_rename_symbol_template"), oldSymbolAsString, newSymbolAsString);
            result = JOptionPane.showConfirmDialog(JStock.instance(), output, MessagesBundle.getString("question_title_rename"), 0, 3);
            if (result != 0) {
                return;
            }
        }
        if (!this.portfolioManagementJPanel.rename(newStockInfo = StockInfo.newInstance(Code.newInstance(newCodeAsString), Symbol.newInstance(newSymbolAsString)), oldStockInfo = StockInfo.newInstance(Code.newInstance(oldCodeAsString), Symbol.newInstance(oldSymbolAsString)))) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RenameStockJDialog.this.updateOkButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RenameStockJDialog.this.updateOkButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RenameStockJDialog.this.updateOkButton();
        }
    }

    private static class UppercaseDocumentFilter
    extends DocumentFilter {
        private UppercaseDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, text.toUpperCase(), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            fb.replace(offset, length, text.toUpperCase(), attrs);
        }
    }
}

