/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.news;

import java.net.URL;
import java.util.ArrayList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;

public class StockNewsContent {
    public final TabPane tabPane = new TabPane();
    public final ArrayList<Pair<URL, String>> tabsInfo = new ArrayList();

    public void addNewsTab(URL link, String title) {
        if (!this.tabsInfo.isEmpty()) {
            for (int i = 0; i < this.tabsInfo.size(); ++i) {
                if (!link.equals(this.tabsInfo.get((int)i).first)) continue;
                SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
                selectionModel.select(i);
                return;
            }
        }
        this.tabsInfo.add(new Pair<URL, String>(link, title));
        final Tab tab = new Tab();
        tab.setTooltip(new Tooltip(title));
        final ProgressIndicator progressIn = new ProgressIndicator();
        progressIn.setMaxSize(15.0, 15.0);
        tab.setGraphic((Node)progressIn);
        final WebView webView = new WebView();
        Image image = new Image(this.getClass().getResource("/images/32x32/browser.png").toString());
        ImageView imageView = new ImageView(image);
        Button button = new Button(GUIBundle.getString("SimpleSwingBrowser_OpenInBrowser"), (Node)imageView);
        button.setOnAction(event -> Utils.launchWebBrowser(link));
        HBox hbox = new HBox();
        hbox.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        hbox.getChildren().addAll((Object[])new Node[]{button});
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)hbox);
        borderPane.setCenter((Node)webView);
        tab.setContent((Node)borderPane);
        tab.setOnCloseRequest((EventHandler)new EventHandler<Event>(){

            public void handle(Event e) {
                StockNewsContent.this.tabsInfo.remove(StockNewsContent.this.tabPane.getSelectionModel().getSelectedIndex());
                webView.getEngine().load(null);
            }
        });
        this.tabPane.getTabs().add((Object)tab);
        WebEngine webEngine = webView.getEngine();
        webEngine.load(link.toString());
        webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED || newState == Worker.State.FAILED) {
                    if (progressIn.isVisible()) {
                        progressIn.setVisible(false);
                    }
                    if (tab.getGraphic() != null) {
                        tab.setGraphic(null);
                    }
                }
            }
        });
        String[] result = title.split(" ", 4);
        String shortTitle = "";
        for (int i = 0; i < 3; ++i) {
            shortTitle = shortTitle + " " + result[i];
        }
        shortTitle = shortTitle + "....";
        tab.setText(shortTitle);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)15.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (progressIn.isVisible()) {
                    progressIn.setVisible(false);
                }
                if (tab.getGraphic() != null) {
                    tab.setGraphic(null);
                }
            }
        }, new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
        this.tabPane.getSelectionModel().select((Object)tab);
    }
}

