/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.CodeBucketLists;
import org.yccheok.jstock.engine.Factories;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.gui.GA;

public class RealTimeStockMonitor
extends Subject<RealTimeStockMonitor, Result> {
    private volatile long delay;
    private static final long MIN_DELAY = 5000L;
    private static final long MIN_DELAY_COUNTER = 3L;
    private final int maxThread;
    private final CodeBucketLists codeBucketLists;
    private final List<StockMonitor> stockMonitors;
    private static final Log log = LogFactory.getLog(RealTimeStockMonitor.class);

    public RealTimeStockMonitor(int maxThread, int maxBucketSize, long delay) {
        if (maxThread <= 0 || maxBucketSize <= 0 || delay <= 0L) {
            throw new IllegalArgumentException("maxThread : " + maxThread + ", maxBucketSize : " + maxBucketSize + ", delay : " + delay);
        }
        this.maxThread = maxThread;
        this.delay = delay;
        this.codeBucketLists = new CodeBucketLists(maxBucketSize);
        this.stockMonitors = new ArrayList<StockMonitor>();
    }

    public synchronized boolean addStockCode(Code code) {
        return this.codeBucketLists.add(code);
    }

    public synchronized boolean isEmpty() {
        return this.codeBucketLists.isEmpty();
    }

    public synchronized boolean clearStockCodes() {
        this.codeBucketLists.clear();
        while (this.stockMonitors.size() > 0) {
            StockMonitor stockMonitor = this.stockMonitors.remove(this.stockMonitors.size() - 1);
            stockMonitor._stop();
        }
        return true;
    }

    public synchronized boolean removeStockCode(Code code) {
        boolean status = this.codeBucketLists.remove(code);
        int numOfMonitorRequired = this.getNumOfRequiredThread();
        if (this.stockMonitors.size() > numOfMonitorRequired) {
            StockMonitor stockMonitor = this.stockMonitors.remove(this.stockMonitors.size() - 1);
            stockMonitor._stop();
        }
        return status;
    }

    public synchronized void resume() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._resume();
        }
    }

    public synchronized void suspend() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._suspend();
        }
    }

    public synchronized void startNewThreadsIfNecessary() {
        int numOfMonitorRequired = this.getNumOfRequiredThread();
        assert (numOfMonitorRequired <= this.maxThread);
        for (int i = this.stockMonitors.size(); i < numOfMonitorRequired; ++i) {
            log.info((Object)("Before adding : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
            StockMonitor stockMonitor = new StockMonitor(i);
            this.stockMonitors.add(stockMonitor);
            stockMonitor.start();
            log.info((Object)("After adding : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
        }
    }

    public synchronized void rebuild() {
        this.codeBucketLists.rebuild();
        this.startNewThreadsIfNecessary();
        int numOfMonitorRequired = this.getNumOfRequiredThread();
        assert (numOfMonitorRequired <= this.maxThread);
        while (this.stockMonitors.size() > numOfMonitorRequired) {
            StockMonitor stockMonitor = this.stockMonitors.remove(this.stockMonitors.size() - 1);
            stockMonitor._stop();
        }
    }

    public synchronized void stop() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._stop();
            try {
                stockMonitor.join();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        this.stockMonitors.clear();
    }

    public synchronized void refresh() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor.refresh();
        }
    }

    public synchronized void setDelay(int delay) {
        this.delay = delay;
    }

    private int getNumOfRequiredThread() {
        int numOfThreadRequired = this.codeBucketLists.size();
        return Math.min(numOfThreadRequired, this.maxThread);
    }

    private class StockMonitor
    extends Thread {
        private boolean suspend = false;
        private volatile boolean isRefresh = false;
        private volatile int minDelayCounter = 0;
        private final int index;
        private volatile Thread thread;

        public StockMonitor(int index) {
            this.index = index;
            this.thread = this;
        }

        private synchronized void _wait() throws InterruptedException {
            while (this.suspend) {
                this.wait();
            }
        }

        public synchronized void _resume() {
            this.suspend = false;
            this.notify();
        }

        public synchronized void _suspend() {
            this.suspend = true;
        }

        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            int step = RealTimeStockMonitor.this.maxThread;
            block6: while (thisThread == this.thread) {
                block7: while (true) {
                    try {
                        while (thisThread == this.thread) {
                            List<Code> codes;
                            block18: {
                                try {
                                    this._wait();
                                }
                                catch (InterruptedException exp) {
                                    log.error(null, (Throwable)exp);
                                    if (this.refreshed()) break block18;
                                    if (this.thread != null) {
                                        GA.trackAsynchronously("realTimeStockMonitorFatal:_wait");
                                    }
                                    this.thread = null;
                                    continue block6;
                                }
                            }
                            int fail = 0;
                            boolean codeBucketListsChanged = false;
                            int currIndex = this.index;
                            while (thisThread == this.thread && !(codes = RealTimeStockMonitor.this.codeBucketLists.get(currIndex)).isEmpty()) {
                                int size = codes.size();
                                List<Code> zeroPriceCodes = codes;
                                HashSet<Code> nonZeroPriceCodes = new HashSet<Code>();
                                ArrayList<Stock> stocks = new ArrayList<Stock>();
                                List<StockServerFactory> stockServerFactories = Factories.INSTANCE.getStockServerFactories(zeroPriceCodes.get(0));
                                int stockServerFactorySize = stockServerFactories.size();
                                for (int stockServerFactoryIndex = 0; thisThread == this.thread && stockServerFactoryIndex < stockServerFactorySize; ++stockServerFactoryIndex) {
                                    StockServerFactory factory = stockServerFactories.get(stockServerFactoryIndex);
                                    StockServer stockServer = factory.getStockServer();
                                    if (stockServer == null) continue;
                                    List<Stock> tmpStocks = stockServer.getStocks(zeroPriceCodes);
                                    if (thisThread != this.thread) break;
                                    if (tmpStocks.isEmpty()) {
                                        if (!this.refreshed()) continue;
                                        --stockServerFactoryIndex;
                                        continue;
                                    }
                                    if (tmpStocks.size() != zeroPriceCodes.size() && this.refreshed()) {
                                        --stockServerFactoryIndex;
                                    }
                                    if ((zeroPriceCodes = Utils.getZeroPriceCodes(zeroPriceCodes, tmpStocks, stocks, nonZeroPriceCodes)).isEmpty()) break;
                                }
                                if (thisThread != this.thread) break;
                                fail += zeroPriceCodes.size();
                                Result result = Result.newInstance(stocks, zeroPriceCodes);
                                RealTimeStockMonitor.this.notify(RealTimeStockMonitor.this, result);
                                if (size != RealTimeStockMonitor.this.codeBucketLists.get(currIndex).size()) {
                                    codeBucketListsChanged = true;
                                }
                                currIndex += step;
                            }
                            if (thisThread != this.thread) continue block6;
                            if (codeBucketListsChanged) continue;
                            try {
                                if (fail == 0) {
                                    Thread.sleep(RealTimeStockMonitor.this.delay);
                                    continue block7;
                                }
                                if ((long)this.minDelayCounter < 3L) {
                                    ++this.minDelayCounter;
                                    Thread.sleep(5000L);
                                    continue block7;
                                }
                                Thread.sleep(RealTimeStockMonitor.this.delay);
                                continue block7;
                            }
                            catch (InterruptedException exp) {
                                log.error((Object)("index=" + this.index), (Throwable)exp);
                                if (this.refreshed()) continue;
                                if (this.thread != null) {
                                    GA.trackAsynchronously("realTimeStockMonitorFatal:sleep");
                                }
                                this.thread = null;
                            }
                        }
                        continue block6;
                    }
                    catch (Exception exp) {
                        log.error((Object)"Our thread just recover from unexpected error", (Throwable)exp);
                        break;
                    }
                }
            }
        }

        public synchronized void refresh() {
            if (this.suspend) {
                return;
            }
            this.isRefresh = true;
            this.minDelayCounter = 0;
            this.interrupt();
        }

        private synchronized boolean refreshed() {
            if (this.isRefresh) {
                this.isRefresh = false;
                StockMonitor.interrupted();
                return true;
            }
            return false;
        }

        public void _stop() {
            this.thread = null;
            this.interrupt();
        }
    }

    public static final class Result {
        public final List<Stock> stocks;
        public final List<Code> failedCodes;

        private Result(List<Stock> stocks, List<Code> failedCodes) {
            this.stocks = new ArrayList<Stock>(stocks);
            this.failedCodes = new ArrayList<Code>(failedCodes);
        }

        public static Result newInstance(List<Stock> stocks, List<Code> failedCodes) {
            return new Result(stocks, failedCodes);
        }
    }
}

