/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse;
import org.yccheok.jstock.engine.yahoo.quote.QuoteResponse_;
import org.yccheok.jstock.engine.yahoo.quote.Result;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import retrofit2.Call;

public abstract class AbstractYahooStockServer
implements StockServer {
    private static final int MAX_STOCK_PER_ITERATION = 180;
    private static final int NUM_OF_RETRY = 2;
    private static final String TAG = "AbstractYahooStockServe";
    private static final Log log = LogFactory.getLog(AbstractYahooStockServer.class);

    @Override
    public List<Stock> getStocks(List<Code> codes) {
        return this._getStocks(codes);
    }

    @Override
    public Stock getStock(Code code) {
        return this._getStock(code);
    }

    private List<Stock> getStocks(String codes) {
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        try {
            Call<QuoteResponse> call = Utils.getYahooFinanceApi().quote(codes);
            QuoteResponse quoteResponse = (QuoteResponse)call.execute().body();
            QuoteResponse_ quoteResponse_ = quoteResponse.getQuoteResponse();
            List<Result> results = quoteResponse_.getResult();
            for (Result result : results) {
                Code code = Code.newInstance(result.getSymbol());
                JStockOptions jStockOptions = JStock.instance().getJStockOptions();
                Symbol symbol = jStockOptions.isPreferLongName(jStockOptions.getCountry()) ? (org.yccheok.jstock.gui.Utils.isNullOrEmpty(result.getLongName()) ? (org.yccheok.jstock.gui.Utils.isNullOrEmpty(result.getShortName()) ? Symbol.newInstance(code.toString()) : Symbol.newInstance(result.getShortName())) : Symbol.newInstance(StringEscapeUtils.unescapeHtml((String)result.getLongName()))) : (org.yccheok.jstock.gui.Utils.isNullOrEmpty(result.getShortName()) ? (org.yccheok.jstock.gui.Utils.isNullOrEmpty(result.getLongName()) ? Symbol.newInstance(code.toString()) : Symbol.newInstance(StringEscapeUtils.unescapeHtml((String)result.getLongName()))) : Symbol.newInstance(result.getShortName()));
                String name = org.yccheok.jstock.gui.Utils.isNullOrEmpty(result.getLongName()) ? symbol.toString() : result.getLongName();
                Currency currency = null;
                String currencyText = result.getCurrency();
                if (currencyText != null) {
                    if ((currencyText = currencyText.trim()).equals("GBp")) {
                        currencyText = "GBX";
                    } else if (currencyText.equals("ILS")) {
                        currencyText = "ILA";
                    }
                    try {
                        currency = Currency.valueOfWithVerification(currencyText);
                    }
                    catch (IllegalArgumentException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                int priceHint = Math.min(4, Math.max(2, result.getPriceHint()));
                Board board = Board.Unknown;
                Industry industry = Industry.Unknown;
                double prevPrice = result.getRegularMarketPreviousClose();
                double openPrice = result.getRegularMarketOpen();
                double lastPrice = result.getRegularMarketPrice();
                lastPrice = BigDecimal.valueOf(lastPrice).setScale(priceHint, 4).doubleValue();
                double highPrice = result.getRegularMarketDayHigh();
                double lowPrice = result.getRegularMarketDayLow();
                long volume = result.getRegularMarketVolume();
                double changePrice = result.getRegularMarketChange();
                double changePricePercentage = result.getRegularMarketChangePercent();
                changePricePercentage = BigDecimal.valueOf(changePricePercentage).setScale(priceHint, 4).doubleValue();
                int lastVolume = 0;
                double buyPrice = result.getBid();
                int buyQuantity = result.getBidSize();
                double sellPrice = result.getAsk();
                int sellQuantity = result.getAskSize();
                double secondBuyPrice = 0.0;
                boolean secondBuyQuantity = false;
                double secondSellPrice = 0.0;
                boolean secondSellQuantity = false;
                double thirdBuyPrice = 0.0;
                boolean thirdBuyQuantity = false;
                double thirdSellPrice = 0.0;
                boolean thirdSellQuantity = false;
                long timestamp = result.getRegularMarketTime() * 1000L;
                Stock stock = new Stock(code, symbol, name, currency, board, industry, prevPrice, openPrice, lastPrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, lastVolume, buyPrice, buyQuantity, sellPrice, sellQuantity, timestamp);
                stocks.add(stock);
            }
        }
        catch (Exception | IncompatibleClassChangeError | OutOfMemoryError e) {
            log.error(null, e);
        }
        return stocks;
    }

    private List<Stock> _getStocks(List<Code> codes) {
        if (codes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        HashMap<Code, Code> yahooFormatCodes = new HashMap<Code, Code>();
        for (Code code : codes) {
            yahooFormatCodes.put(code, Utils.toYahooFormatCode(code));
        }
        int time = codes.size() / 180;
        int remainder = codes.size() % 180;
        for (int i = 0; i < time; ++i) {
            int start = i * 180;
            int end = start + 180;
            StringBuilder codeBuilder = new StringBuilder();
            for (int j = start; j < end; ++j) {
                Code yahooFormatCode = (Code)yahooFormatCodes.get(codes.get(j));
                assert (yahooFormatCode != null);
                String yahooFormatCodeString = yahooFormatCode.toString();
                codeBuilder.append(yahooFormatCodeString).append(",");
            }
            String _code = codeBuilder.toString();
            if (_code.endsWith(",")) {
                _code = _code.substring(0, _code.length() - 1);
            }
            if (_code.isEmpty()) continue;
            List<Stock> bestStocks = null;
            for (int retry = 0; retry < 2; ++retry) {
                List<Stock> tmpStocks = this.getStocks(_code);
                int tmpStocksSize = tmpStocks.size();
                if (bestStocks == null) {
                    bestStocks = tmpStocks;
                } else if (bestStocks.size() < tmpStocksSize) {
                    bestStocks = tmpStocks;
                }
                if (tmpStocksSize == 180) break;
            }
            if (bestStocks == null) continue;
            stocks.addAll(bestStocks);
        }
        int start = codes.size() - remainder;
        int end = start + remainder;
        StringBuilder codeBuilder = new StringBuilder();
        for (int i = start; i < end; ++i) {
            Code yahooFormatCode = (Code)yahooFormatCodes.get(codes.get(i));
            assert (yahooFormatCode != null);
            String yahooFormatCodeString = yahooFormatCode.toString();
            codeBuilder.append(yahooFormatCodeString).append(",");
        }
        String _code = codeBuilder.toString();
        if (_code.endsWith(",")) {
            _code = _code.substring(0, _code.length() - 1);
        }
        if (_code.isEmpty()) {
            return AbstractYahooStockServer.normalize(codes, yahooFormatCodes, stocks);
        }
        List<Stock> bestStocks = null;
        for (int retry = 0; retry < 2; ++retry) {
            List<Stock> tmpStocks = this.getStocks(_code);
            int tmpStocksSize = tmpStocks.size();
            if (bestStocks == null) {
                bestStocks = tmpStocks;
            } else if (bestStocks.size() < tmpStocksSize) {
                bestStocks = tmpStocks;
            }
            if (tmpStocksSize == remainder) break;
        }
        if (bestStocks != null) {
            stocks.addAll(bestStocks);
        }
        return AbstractYahooStockServer.normalize(codes, yahooFormatCodes, stocks);
    }

    private static List<Stock> normalize(List<Code> codes, Map<Code, Code> yahooFormatCodes, List<Stock> stocks) {
        HashMap<Code, Stock> yahooFormatCodeToStocks = new HashMap<Code, Stock>();
        for (Stock stock : stocks) {
            yahooFormatCodeToStocks.put(stock.code, stock);
        }
        ArrayList<Stock> normalizedStocks = new ArrayList<Stock>();
        for (Code code : codes) {
            Code yahooFormatCode = yahooFormatCodes.get(code);
            assert (yahooFormatCode != null);
            Stock normalizedStock = (Stock)yahooFormatCodeToStocks.get(yahooFormatCode);
            if (normalizedStock == null) continue;
            if (normalizedStock.code.equals(code)) {
                normalizedStocks.add(normalizedStock);
                continue;
            }
            normalizedStock = normalizedStock.deriveStock(code);
            normalizedStocks.add(normalizedStock);
        }
        return normalizedStocks;
    }

    private Stock _getStock(Code code) {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(code);
        List<Stock> stocks = this._getStocks(codes);
        if (!stocks.isEmpty()) {
            return stocks.get(0);
        }
        return null;
    }
}

