/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.app.ExportableView;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.samples.odg.ODGDrawing;
import org.jhotdraw.samples.odg.ODGPropertiesPanel;
import org.jhotdraw.samples.odg.io.ODGInputFormat;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGView
extends AbstractView
implements ExportableView {
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    protected JFileChooser exportChooser;
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private HashMap<FileFilter, InputFormat> fileFilterInputFormatMap;
    private HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap;
    private GridConstrainer visibleConstrainer = new GridConstrainer(10.0, 10.0);
    private GridConstrainer invisibleConstrainer = new GridConstrainer(1.0, 1.0);
    private ODGPropertiesPanel propertiesPanel;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    @Override
    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ODGView.this.setHasUnsavedChanges(ODGView.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "view.toggleGrid.placard");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
        this.propertiesPanel.setVisible(this.preferences.getBoolean("propertiesPanelVisible", false));
        this.propertiesPanel.setView(this.view);
    }

    protected Drawing createDrawing() {
        ODGDrawing drawing = new ODGDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new ODGInputFormat());
        inputFormats.add(new ImageInputFormat(new SVGImageFigure()));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        inputFormats.add(new ImageInputFormat(new SVGImageFigure(), "GIF", "Graphics Interchange Format (GIF)", "gif", 2));
        inputFormats.add(new TextInputFormat(new SVGTextFigure()));
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new SVGZOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        outputFormats.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        outputFormats.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        outputFormats.add(new ImageMapOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        this.propertiesPanel.setEditor(this.editor);
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    private void initActions() {
        this.putAction("edit.undo", this.undo.getUndoAction());
        this.putAction("edit.redo", this.undo.getRedoAction());
    }

    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File f) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            new SVGOutputFormat().write(f, this.view.getDrawing());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void read(File f) throws IOException {
        try {
            JFileChooser fc = this.getOpenChooser();
            final Drawing drawing = this.createDrawing();
            InputFormat sf = this.fileFilterInputFormatMap.get(fc.getFileFilter());
            if (sf == null) {
                sf = drawing.getInputFormats().get(0);
            }
            sf.read(f, drawing, true);
            System.out.println("ODCView read(" + f + ") drawing.childCount=" + drawing.getChildCount());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ODGView.this.view.getDrawing().removeUndoableEditListener(ODGView.this.undo);
                    ODGView.this.view.setDrawing(drawing);
                    ODGView.this.view.getDrawing().addUndoableEditListener(ODGView.this.undo);
                    ODGView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.view.setEnabled(newValue);
        super.setEnabled(newValue);
    }

    public void setPropertiesPanelVisible(boolean newValue) {
        boolean oldValue = this.propertiesPanel.isVisible();
        this.propertiesPanel.setVisible(newValue);
        this.firePropertyChange("propertiesPanelVisible", oldValue, newValue);
        this.preferences.putBoolean("propertiesPanelVisible", newValue);
        this.validate();
    }

    public boolean isPropertiesPanelVisible() {
        return this.propertiesPanel.isVisible();
    }

    public boolean isGridVisible() {
        return this.view.isConstrainerVisible();
    }

    public void setGridVisible(boolean newValue) {
        boolean oldValue = this.isGridVisible();
        this.view.setConstrainerVisible(newValue);
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, newValue);
    }

    public double getScaleFactor() {
        return this.view.getScaleFactor();
    }

    public void setScaleFactor(double newValue) {
        double oldValue = this.getScaleFactor();
        this.view.setScaleFactor(newValue);
        this.firePropertyChange("scaleFactor", oldValue, newValue);
    }

    @Override
    public void clear() {
        final Drawing newDrawing = this.createDrawing();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ODGView.this.view.getDrawing().removeUndoableEditListener(ODGView.this.undo);
                    ODGView.this.view.setDrawing(newDrawing);
                    ODGView.this.view.getDrawing().addUndoableEditListener(ODGView.this.undo);
                    ODGView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected JFileChooser createOpenChooser() {
        final JFileChooser c = new JFileChooser();
        this.fileFilterInputFormatMap = new HashMap();
        FileFilter firstFF = null;
        for (InputFormat format : this.view.getDrawing().getInputFormats()) {
            FileFilter ff = format.getFileFilter();
            if (firstFF == null) {
                firstFF = ff;
            }
            this.fileFilterInputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        c.setFileFilter(firstFF);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    InputFormat inputFormat = (InputFormat)ODGView.this.fileFilterInputFormatMap.get(evt.getNewValue());
                    c.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                }
            }
        });
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    protected JFileChooser createSaveChooser() {
        JFileChooser c = new JFileChooser();
        this.fileFilterOutputFormatMap = new HashMap();
        Iterator<OutputFormat> i$ = this.view.getDrawing().getOutputFormats().iterator();
        if (i$.hasNext()) {
            OutputFormat format = i$.next();
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        if (this.preferences != null) {
            c.setSelectedFile(new File(this.preferences.get("projectFile", System.getProperty("user.home"))));
        }
        return c;
    }

    @Override
    public boolean canSaveTo(File file) {
        return file.getName().endsWith(".odg");
    }

    protected JFileChooser createExportChooser() {
        JFileChooser c = new JFileChooser();
        this.fileFilterOutputFormatMap = new HashMap();
        FileFilter currentFilter = null;
        for (OutputFormat format : this.view.getDrawing().getOutputFormats()) {
            FileFilter ff = format.getFileFilter();
            this.fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
            if (!ff.getDescription().equals(this.preferences.get("viewExportFormat", ""))) continue;
            currentFilter = ff;
        }
        if (currentFilter != null) {
            c.setFileFilter(currentFilter);
        }
        c.setSelectedFile(new File(this.preferences.get("viewExportFile", System.getProperty("user.home"))));
        return c;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.propertiesPanel = new ODGPropertiesPanel();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.propertiesPanel, "South");
    }

    @Override
    public JFileChooser getExportChooser() {
        if (this.exportChooser == null) {
            this.exportChooser = this.createExportChooser();
        }
        return this.exportChooser;
    }

    @Override
    public void export(File f, FileFilter filter, Component accessory) throws IOException {
        OutputFormat format = this.fileFilterOutputFormatMap.get(filter);
        if (!f.getName().endsWith("." + format.getFileExtension())) {
            f = new File(f.getPath() + "." + format.getFileExtension());
        }
        format.write(f, this.view.getDrawing());
        this.preferences.put("viewExportFile", f.getPath());
        this.preferences.put("viewExportFormat", filter.getDescription());
    }
}

