/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.FontSizeLocator;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class FontSizeHandle
extends LocatorHandle {
    private float oldSize;
    private float newSize;
    private Object restoreData;

    public FontSizeHandle(TextHolderFigure owner) {
        super(owner, new FontSizeLocator());
    }

    public FontSizeHandle(TextHolderFigure owner, Locator locator) {
        super(owner, locator);
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(9);
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        TextHolderFigure textOwner = (TextHolderFigure)this.getOwner();
        this.oldSize = this.newSize = textOwner.getFontSize();
        this.restoreData = textOwner.getAttributesRestoreData();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        TextHolderFigure textOwner = (TextHolderFigure)this.getOwner();
        Point2D.Double anchor2D = this.view.viewToDrawing(anchor);
        Point2D.Double lead2D = this.view.viewToDrawing(lead);
        if (AttributeKeys.TRANSFORM.get(textOwner) != null) {
            try {
                AttributeKeys.TRANSFORM.get(textOwner).inverseTransform(anchor2D, anchor2D);
                AttributeKeys.TRANSFORM.get(textOwner).inverseTransform(lead2D, lead2D);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        this.newSize = (float)Math.max(1.0, (double)this.oldSize + lead2D.y - anchor2D.y);
        textOwner.willChange();
        textOwner.setFontSize(this.newSize);
        textOwner.changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        final TextHolderFigure textOwner = (TextHolderFigure)this.getOwner();
        final Object editRestoreData = this.restoreData;
        float editNewSize = this.newSize;
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
                return labels.getString("attribute.fontSize.text");
            }

            @Override
            public void undo() {
                super.undo();
                textOwner.willChange();
                textOwner.restoreAttributesTo(editRestoreData);
                textOwner.changed();
            }

            @Override
            public void redo() {
                super.redo();
                textOwner.willChange();
                textOwner.setFontSize(FontSizeHandle.this.newSize);
                textOwner.changed();
            }
        };
        this.fireUndoableEditHappened(edit);
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        final TextHolderFigure textOwner = (TextHolderFigure)this.getOwner();
        this.oldSize = this.newSize = textOwner.getFontSize();
        switch (evt.getKeyCode()) {
            case 38: {
                if (this.newSize > 1.0f) {
                    this.newSize -= 1.0f;
                }
                evt.consume();
                break;
            }
            case 40: {
                this.newSize += 1.0f;
                evt.consume();
                break;
            }
            case 37: {
                evt.consume();
                break;
            }
            case 39: {
                evt.consume();
            }
        }
        if (this.newSize != this.oldSize) {
            this.restoreData = textOwner.getAttributesRestoreData();
            textOwner.willChange();
            textOwner.setFontSize(this.newSize);
            textOwner.changed();
            final Object editRestoreData = this.restoreData;
            float editNewSize = this.newSize;
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
                    return labels.getString("attribute.fontSize");
                }

                @Override
                public void undo() {
                    super.undo();
                    textOwner.willChange();
                    textOwner.restoreAttributesTo(editRestoreData);
                    textOwner.changed();
                }

                @Override
                public void redo() {
                    super.redo();
                    textOwner.willChange();
                    textOwner.setFontSize(FontSizeHandle.this.newSize);
                    textOwner.changed();
                }
            };
            this.fireUndoableEditHappened(edit);
        }
    }

    @Override
    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.fontSize.toolTipText");
    }
}

