/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.util.ResourceBundleUtil;

public class DefaultApplicationModel
extends AbstractBean
implements ApplicationModel {
    private HashMap<String, Action> actions;
    private String name;
    private String version;
    private String copyright;
    private Class viewClass;
    private String viewClassName;
    public static final String NAME_PROPERTY = "name";
    public static final String VERSION_PROPERTY = "version";
    public static final String COPYRIGHT_PROPERTY = "copyright";
    public static final String VIEW_CLASS_NAME_PROPERTY = "viewClassName";
    public static final String VIEW_CLASS_PROPERTY = "viewClass";

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange(NAME_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String newValue) {
        String oldValue = this.version;
        this.version = newValue;
        this.firePropertyChange(VERSION_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCopyright(String newValue) {
        String oldValue = this.copyright;
        this.copyright = newValue;
        this.firePropertyChange(COPYRIGHT_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setViewClassName(String newValue) {
        String oldValue = this.viewClassName;
        this.viewClassName = newValue;
        this.firePropertyChange(VIEW_CLASS_NAME_PROPERTY, oldValue, newValue);
    }

    public void setViewClass(Class newValue) {
        Class oldValue = this.viewClass;
        this.viewClass = newValue;
        this.firePropertyChange(VIEW_CLASS_PROPERTY, oldValue, newValue);
    }

    public Class getViewClass() {
        if (this.viewClass == null && this.viewClassName != null) {
            try {
                this.viewClass = Class.forName(this.viewClassName);
            }
            catch (Exception e) {
                InternalError error = new InternalError("unable to get view class");
                error.initCause(e);
                throw error;
            }
        }
        return this.viewClass;
    }

    @Override
    public View createView() {
        try {
            return (View)this.getViewClass().newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("unable to create view");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public List<JToolBar> createToolBars(Application app, View p) {
        JButton b;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        JToolBar tb = new JToolBar();
        tb.setName(labels.getString("standardToolBarTitle"));
        Action a = this.getAction("file.new");
        if (null != a) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if (null != (a = this.getAction("file.open"))) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        if (null != (a = this.getAction("file.load"))) {
            b = tb.add(a);
            b.setFocusable(false);
        }
        b = tb.add(this.getAction("file.save"));
        tb.addSeparator();
        b = tb.add(this.getAction("edit.undo"));
        b.setFocusable(false);
        b = tb.add(this.getAction("edit.redo"));
        b.setFocusable(false);
        tb.addSeparator();
        b = tb.add(this.getAction("edit.cut"));
        b.setFocusable(false);
        b = tb.add(this.getAction("edit.copy"));
        b.setFocusable(false);
        b = tb.add(this.getAction("edit.paste"));
        b.setFocusable(false);
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        list.add(tb);
        return list;
    }

    @Override
    public List<JMenu> createMenus(Application a, View p) {
        LinkedList<JMenu> list = new LinkedList<JMenu>();
        list.add(this.createEditMenu(a, p));
        return list;
    }

    protected JMenu createEditMenu(Application a, View p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        JMenu m = new JMenu();
        labels.configureMenu(m, "edit");
        JMenuItem mi = m.add(this.getAction("edit.undo"));
        mi.setIcon(null);
        mi = m.add(this.getAction("edit.redo"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("edit.cut"));
        mi.setIcon(null);
        mi = m.add(this.getAction("edit.copy"));
        mi.setIcon(null);
        mi = m.add(this.getAction("edit.paste"));
        mi.setIcon(null);
        mi = m.add(this.getAction("edit.duplicate"));
        mi.setIcon(null);
        mi = m.add(this.getAction("edit.delete"));
        mi.setIcon(null);
        m.addSeparator();
        mi = m.add(this.getAction("edit.selectAll"));
        mi.setIcon(null);
        if (this.getAction("edit.find") != null) {
            m.addSeparator();
            m.add(this.getAction("edit.find"));
        }
        return m;
    }

    @Override
    public void initView(Application a, View p) {
    }

    @Override
    public void initApplication(Application a) {
    }

    @Override
    public Action getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    @Override
    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }
}

