/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;

public class UppercaseSentenceStartRuleTest {
    @Test
    public void testRule() throws IOException {
        UppercaseSentenceStartRule rule = new UppercaseSentenceStartRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        JLanguageTool langTool = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("a) This is a test sentence."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("iv. This is a test sentence..."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\"iv. This is a test sentence...\""));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u00bbiv. This is a test sentence..."));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("this is a sentence"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence(""));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("http://www.languagetool.org"));
        Assert.assertEquals((long)0L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("this is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)0L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)4L, (long)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("this"));
        Assert.assertEquals((long)1L, (long)matches.length);
        Assert.assertEquals((long)0L, (long)matches[0].getFromPos());
        Assert.assertEquals((long)4L, (long)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("'this is a sentence'."));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\"this is a sentence.\""));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u201ethis is a sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u00abthis is a sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u2018this is a sentence."));
        Assert.assertEquals((long)1L, (long)matches.length);
    }
}

