/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class Counter<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<E, Double> entries = new HashMap<E, Double>();
    private boolean dirty = true;
    private double cacheTotal = 0.0;
    private double defaultCount = 0.0;

    public double getDefaultCount() {
        return this.defaultCount;
    }

    public void setDefaultCount(double deflt) {
        this.defaultCount = deflt;
    }

    public Set<E> keySet() {
        return this.entries.keySet();
    }

    public Set<Map.Entry<E, Double>> entrySet() {
        return this.entries.entrySet();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(E key) {
        return this.entries.containsKey(key);
    }

    public double getCount(E key) {
        Double value = this.entries.get(key);
        if (value == null) {
            return this.defaultCount;
        }
        return value;
    }

    public double getProbability(E key) {
        double count = this.getCount(key);
        double total = this.totalCount();
        if (total < 0.0) {
            throw new RuntimeException("Can't call getProbability() with totalCount < 0.0");
        }
        return total > 0.0 ? count / total : 0.0;
    }

    public void normalize() {
        double totalCount = this.totalCount();
        for (E key : this.keySet()) {
            this.setCount(key, this.getCount(key) / totalCount);
        }
        this.dirty = true;
    }

    public void setCount(E key, double count) {
        this.entries.put(key, count);
        this.dirty = true;
    }

    public void put(E key, double count, boolean keepHigher) {
        if (keepHigher && this.entries.containsKey(key)) {
            double oldCount = this.entries.get(key);
            if (count > oldCount) {
                this.entries.put(key, count);
            }
        } else {
            this.entries.put(key, count);
        }
        this.dirty = true;
    }

    public E sample(Random rand) {
        double total = this.totalCount();
        if (total <= 0.0) {
            throw new RuntimeException(String.format("Attempting to sample() with totalCount() %.3f\n", total));
        }
        double sum = 0.0;
        double r = rand.nextDouble();
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            double count = entry.getValue();
            double frac = count / total;
            if (!(r < (sum += frac))) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Shoudl've have returned a sample by now....");
    }

    public E sample() {
        return this.sample(new Random());
    }

    public void removeKey(E key) {
        this.setCount(key, 0.0);
        this.dirty = true;
        this.removeKeyFromEntries(key);
    }

    protected void removeKeyFromEntries(E key) {
        this.entries.remove(key);
    }

    public void setMaxCount(E key, double val) {
        Double value = this.entries.get(key);
        if (value == null || val > value) {
            this.setCount(key, val);
            this.dirty = true;
        }
    }

    public void setMinCount(E key, double val) {
        Double value = this.entries.get(key);
        if (value == null || val < value) {
            this.setCount(key, val);
            this.dirty = true;
        }
    }

    public double incrementCount(E key, double increment) {
        double newVal = this.getCount(key) + increment;
        this.setCount(key, newVal);
        this.dirty = true;
        return newVal;
    }

    public void incrementAll(Collection<? extends E> collection, double count) {
        for (E key : collection) {
            this.incrementCount(key, count);
        }
        this.dirty = true;
    }

    public <T extends E> void incrementAll(Counter<T> counter) {
        this.incrementAll(counter, 1.0);
    }

    public <T extends E> void incrementAll(Counter<T> counter, double scale) {
        for (Map.Entry<T, Double> entry : counter.entrySet()) {
            this.incrementCount(entry.getKey(), scale * entry.getValue());
        }
        this.dirty = true;
    }

    public double totalCount() {
        if (!this.dirty) {
            return this.cacheTotal;
        }
        double total = 0.0;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            total += entry.getValue().doubleValue();
        }
        this.cacheTotal = total;
        this.dirty = false;
        return total;
    }

    public Collection<Map.Entry<E, Double>> getEntriesSortedByIncreasingCount() {
        ArrayList<Map.Entry<E, Double>> sorted = new ArrayList<Map.Entry<E, Double>>(this.entrySet());
        Collections.sort(sorted, new EntryValueComparator(false));
        return sorted;
    }

    public Collection<Map.Entry<E, Double>> getEntriesSortedByDecreasingCount() {
        ArrayList<Map.Entry<E, Double>> sorted = new ArrayList<Map.Entry<E, Double>>(this.entrySet());
        Collections.sort(sorted, new EntryValueComparator(true));
        return sorted;
    }

    public E argMax() {
        double maxCount = Double.NEGATIVE_INFINITY;
        E maxKey = null;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(entry.getValue() > maxCount) && maxKey != null) continue;
            maxKey = entry.getKey();
            maxCount = entry.getValue();
        }
        return maxKey;
    }

    public double min() {
        return this.maxMinHelp(false);
    }

    public double max() {
        return this.maxMinHelp(true);
    }

    private double maxMinHelp(boolean max) {
        double maxCount = max ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            if (!(max && entry.getValue() > maxCount) && (max || !(entry.getValue() < maxCount))) continue;
            maxCount = entry.getValue();
        }
        return maxCount;
    }

    public String toString() {
        return this.toStringSortedByKeys();
    }

    public String toStringSortedByKeys() {
        StringBuilder sb = new StringBuilder("[");
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(5);
        int numKeysPrinted = 0;
        for (E element : new TreeSet<E>(this.keySet())) {
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(f.format(this.getCount(element)));
            if (numKeysPrinted < this.size() - 1) {
                sb.append(", ");
            }
            ++numKeysPrinted;
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public Counter() {
    }

    public Counter(Counter<? extends E> counter) {
        this();
        this.incrementAll(counter);
    }

    public Counter(Collection<? extends E> collection) {
        this();
        this.incrementAll(collection, 1.0);
    }

    public void pruneKeysBelowThreshold(double cutoff) {
        Iterator<E> it = this.entries.keySet().iterator();
        while (it.hasNext()) {
            E key = it.next();
            double val = this.entries.get(key);
            if (!(val < cutoff)) continue;
            it.remove();
        }
        this.dirty = true;
    }

    public Set<Map.Entry<E, Double>> getEntrySet() {
        return this.entries.entrySet();
    }

    public boolean isEqualTo(Counter<E> counter) {
        boolean tmp = true;
        Counter bigger = counter.size() > this.size() ? counter : this;
        for (E e : bigger.keySet()) {
            tmp &= counter.getCount(e) == this.getCount(e);
        }
        return tmp;
    }

    public static void main(String[] args) {
        Counter<String> counter = new Counter<String>();
        System.out.println(counter);
        counter.incrementCount("planets", 7.0);
        System.out.println(counter);
        counter.incrementCount("planets", 1.0);
        System.out.println(counter);
        counter.setCount("suns", 1.0);
        System.out.println(counter);
        counter.setCount("aliens", 0.0);
        System.out.println(counter);
        System.out.println(counter.toString());
        System.out.println("Total: " + counter.totalCount());
    }

    public void clear() {
        this.entries.clear();
        this.dirty = true;
    }

    public void setAllCounts(double val) {
        for (E e : this.keySet()) {
            this.setCount(e, val);
        }
    }

    public double dotProduct(Counter<E> other) {
        double sum = 0.0;
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            double value;
            double otherCount = other.getCount(entry.getKey());
            if (otherCount == 0.0 || (value = entry.getValue().doubleValue()) == 0.0) continue;
            sum += value * otherCount;
        }
        return sum;
    }

    public void scale(double c) {
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            entry.setValue(entry.getValue() * c);
        }
    }

    public Counter<E> scaledClone(double c) {
        Counter<E> newCounter = new Counter<E>();
        for (Map.Entry<E, Double> entry : this.getEntrySet()) {
            newCounter.setCount(entry.getKey(), entry.getValue() * c);
        }
        return newCounter;
    }

    public Counter<E> difference(Counter<E> counter) {
        Counter<E> clone = new Counter<E>(this);
        for (E key : counter.keySet()) {
            double count = counter.getCount(key);
            clone.incrementCount(key, -1.0 * count);
        }
        return clone;
    }

    public Counter<E> toLogSpace() {
        Counter<E> newCounter = new Counter<E>(this);
        for (E key : newCounter.keySet()) {
            newCounter.setCount(key, Math.log(this.getCount(key)));
        }
        return newCounter;
    }

    public boolean approxEquals(Counter<E> other, double tol) {
        for (E key : this.keySet()) {
            if (!(Math.abs(this.getCount(key) - other.getCount(key)) > tol)) continue;
            return false;
        }
        for (E key : other.keySet()) {
            if (!(Math.abs(this.getCount(key) - other.getCount(key)) > tol)) continue;
            return false;
        }
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Iterable<Double> values() {
        return new Iterable<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){
                    Iterator<Map.Entry<E, Double>> entryIterator;
                    {
                        this.entryIterator = Counter.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entryIterator.hasNext();
                    }

                    @Override
                    public Double next() {
                        return this.entryIterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.entryIterator.remove();
                    }
                };
            }
        };
    }

    public void prune(Set<E> toRemove) {
        for (E e : toRemove) {
            this.removeKey(e);
        }
    }

    public void pruneExcept(Set<E> toKeep) {
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E key : this.entries.keySet()) {
            if (toKeep.contains(key)) continue;
            toRemove.add(key);
        }
        for (E e : toRemove) {
            this.removeKey(e);
        }
    }

    public static <L> Counter<L> absCounts(Counter<L> counts) {
        Counter<L> res = new Counter<L>();
        for (Map.Entry<L, Double> entry : counts.entrySet()) {
            res.incrementCount(entry.getKey(), Math.abs(entry.getValue()));
        }
        return res;
    }

    public void putAll(double d) {
        for (Map.Entry<E, Double> entry : this.entries.entrySet()) {
            this.setCount(entry.getKey(), d);
        }
        this.dirty = true;
    }

    public class EntryValueComparator
    implements Comparator<Map.Entry<E, Double>> {
        private final boolean descending;

        public EntryValueComparator(boolean descending) {
            this.descending = descending;
        }

        @Override
        public int compare(Map.Entry<E, Double> e1, Map.Entry<E, Double> e2) {
            return this.descending ? Double.compare(e2.getValue(), e1.getValue()) : Double.compare(e1.getValue(), e2.getValue());
        }
    }
}

