/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.KeyPairType;
import net.sf.portecle.crypto.SignatureType;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.DocumentMaxLengthFilter;
import net.sf.portecle.gui.IntegerDocumentFilter;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.error.DThrowable;

class DGenerateCertificate
extends PortecleJDialog {
    private static final int BAD_VALIDITY = -1;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final Pattern MAILBOX_RE;
    private static final String DEFAULT_VALIDITY;
    private JComboBox<SignatureType> m_jcbSigAlg;
    private JTextField m_jtfValidity;
    private JTextField m_jtfCommonName;
    private JTextField m_jtfOrganisationUnit;
    private JTextField m_jtfOrganisationName;
    private JTextField m_jtfLocalityName;
    private JTextField m_jtfStateName;
    private JTextField m_jtfCountryCode;
    private JTextField m_jtfEmailAddress;
    private JTextField m_jtfDnsName;
    private final KeyPairType m_keyPairType;
    private String m_sCommonName;
    private String m_sOrganizationUnit;
    private String m_sOrganizationName;
    private String m_sLocalityName;
    private String m_sStateName;
    private String m_sCountryCode;
    private String m_sEmailAddress;
    private int m_iValidity = -1;
    private String m_sDnsName;
    private boolean m_bSuccess;

    public DGenerateCertificate(Window window, String string, KeyPairType keyPairType) {
        super(window, true);
        this.m_keyPairType = keyPairType;
        this.initComponents(string);
    }

    private void initComponents(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        int n = 0;
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlSigAlg.text"));
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = n++;
        this.m_jcbSigAlg = new JComboBox();
        DGenerateCertificate.populateSigAlgs(this.m_keyPairType, this.m_jcbSigAlg);
        this.m_jcbSigAlg.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jcbSigAlg.tooltip"));
        jLabel.setLabelFor(this.m_jcbSigAlg);
        GridBagConstraints gridBagConstraints4 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints4.gridy = gridBagConstraints3.gridy;
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlValidity.text"));
        GridBagConstraints gridBagConstraints5 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints5.gridy = n++;
        this.m_jtfValidity = new JTextField(DEFAULT_VALIDITY, 5);
        Document document = this.m_jtfValidity.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new IntegerDocumentFilter(this.m_jtfValidity.getColumns()));
        }
        this.m_jtfValidity.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfValidity.tooltip"));
        jLabel2.setLabelFor(this.m_jtfValidity);
        GridBagConstraints gridBagConstraints6 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints6.gridy = gridBagConstraints5.gridy;
        JLabel jLabel3 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlCommonName.text"));
        GridBagConstraints gridBagConstraints7 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints7.gridy = n++;
        this.m_jtfCommonName = new JTextField(15);
        this.m_jtfCommonName.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfCommonName.tooltip"));
        jLabel3.setLabelFor(this.m_jtfCommonName);
        GridBagConstraints gridBagConstraints8 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints8.gridy = gridBagConstraints7.gridy;
        JLabel jLabel4 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlOrganisationUnit.text"));
        GridBagConstraints gridBagConstraints9 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints9.gridy = n++;
        this.m_jtfOrganisationUnit = new JTextField(15);
        this.m_jtfOrganisationUnit.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfOrganisationUnit.tooltip"));
        jLabel4.setLabelFor(this.m_jtfOrganisationUnit);
        GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints10.gridy = gridBagConstraints9.gridy;
        JLabel jLabel5 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlOrganisationName.text"));
        GridBagConstraints gridBagConstraints11 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints11.gridy = n++;
        this.m_jtfOrganisationName = new JTextField(15);
        this.m_jtfOrganisationName.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfOrganisationName.tooltip"));
        jLabel5.setLabelFor(this.m_jtfOrganisationName);
        GridBagConstraints gridBagConstraints12 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints12.gridy = gridBagConstraints11.gridy;
        JLabel jLabel6 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlLocalityName.text"));
        GridBagConstraints gridBagConstraints13 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints13.gridy = n++;
        this.m_jtfLocalityName = new JTextField(15);
        this.m_jtfLocalityName.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfLocalityName.tooltip"));
        jLabel6.setLabelFor(this.m_jtfLocalityName);
        GridBagConstraints gridBagConstraints14 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints14.gridy = gridBagConstraints13.gridy;
        JLabel jLabel7 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlStateName.text"));
        GridBagConstraints gridBagConstraints15 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints15.gridy = n++;
        this.m_jtfStateName = new JTextField(15);
        this.m_jtfStateName.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfStateName.tooltip"));
        jLabel7.setLabelFor(this.m_jtfStateName);
        GridBagConstraints gridBagConstraints16 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints16.gridy = gridBagConstraints15.gridy;
        JLabel jLabel8 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlCountryCode.text"));
        GridBagConstraints gridBagConstraints17 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints17.gridy = n++;
        this.m_jtfCountryCode = new JTextField(Locale.getDefault().getCountry(), 2);
        document = this.m_jtfCountryCode.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new DocumentMaxLengthFilter(this.m_jtfCountryCode.getColumns()));
        }
        this.m_jtfCountryCode.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfCountryCode.tooltip"));
        jLabel8.setLabelFor(this.m_jtfCountryCode);
        GridBagConstraints gridBagConstraints18 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints18.gridy = gridBagConstraints17.gridy;
        JLabel jLabel9 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlEmailAddress.text"));
        GridBagConstraints gridBagConstraints19 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints19.gridy = n++;
        this.m_jtfEmailAddress = new JTextField(15);
        this.m_jtfEmailAddress.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfEmailAddress.tooltip"));
        jLabel9.setLabelFor(this.m_jtfEmailAddress);
        GridBagConstraints gridBagConstraints20 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints20.gridy = gridBagConstraints19.gridy;
        JLabel jLabel10 = new JLabel(FPortecle.RB.getString("DGenerateCertificate.jlDnsName.text"));
        GridBagConstraints gridBagConstraints21 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints21.gridy = n++;
        this.m_jtfDnsName = new JTextField(15);
        this.m_jtfDnsName.setToolTipText(FPortecle.RB.getString("DGenerateCertificate.m_jtfDnsName.tooltip"));
        jLabel10.setLabelFor(this.m_jtfDnsName);
        GridBagConstraints gridBagConstraints22 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints22.gridy = gridBagConstraints21.gridy;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        jPanel.add((Component)jLabel, gridBagConstraints3);
        jPanel.add(this.m_jcbSigAlg, gridBagConstraints4);
        jPanel.add((Component)jLabel2, gridBagConstraints5);
        jPanel.add((Component)this.m_jtfValidity, gridBagConstraints6);
        jPanel.add((Component)jLabel3, gridBagConstraints7);
        jPanel.add((Component)this.m_jtfCommonName, gridBagConstraints8);
        jPanel.add((Component)jLabel4, gridBagConstraints9);
        jPanel.add((Component)this.m_jtfOrganisationUnit, gridBagConstraints10);
        jPanel.add((Component)jLabel5, gridBagConstraints11);
        jPanel.add((Component)this.m_jtfOrganisationName, gridBagConstraints12);
        jPanel.add((Component)jLabel6, gridBagConstraints13);
        jPanel.add((Component)this.m_jtfLocalityName, gridBagConstraints14);
        jPanel.add((Component)jLabel7, gridBagConstraints15);
        jPanel.add((Component)this.m_jtfStateName, gridBagConstraints16);
        jPanel.add((Component)jLabel8, gridBagConstraints17);
        jPanel.add((Component)this.m_jtfCountryCode, gridBagConstraints18);
        jPanel.add((Component)jLabel9, gridBagConstraints19);
        jPanel.add((Component)this.m_jtfEmailAddress, gridBagConstraints20);
        jPanel.add((Component)jLabel10, gridBagConstraints21);
        jPanel.add((Component)this.m_jtfDnsName, gridBagConstraints22);
        JButton jButton = this.getOkButton(false);
        JButton jButton2 = this.getCancelButton();
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setTitle(string);
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        this.m_jtfCommonName.requestFocusInWindow();
    }

    private static void populateSigAlgs(KeyPairType keyPairType, JComboBox<SignatureType> jComboBox) {
        jComboBox.removeAllItems();
        for (SignatureType signatureType : SignatureType.valuesFor(keyPairType)) {
            jComboBox.addItem(signatureType);
        }
        jComboBox.setSelectedItem((Object)SignatureType.defaultFor(keyPairType));
        jComboBox.setEnabled(jComboBox.getItemCount() > 1);
    }

    private boolean validateValues() {
        Matcher matcher;
        this.m_iValidity = this.validateValidity(this.m_jtfValidity.getText());
        if (this.m_iValidity == -1) {
            SwingHelper.selectAndFocus(this.m_jtfValidity);
            return false;
        }
        this.m_sCommonName = this.validateCommonName(this.m_jtfCommonName.getText());
        this.m_sOrganizationUnit = this.validateOrganisationUnit(this.m_jtfOrganisationUnit.getText());
        this.m_sOrganizationName = this.validateOrganisationName(this.m_jtfOrganisationName.getText());
        this.m_sLocalityName = this.validateLocalityName(this.m_jtfLocalityName.getText());
        this.m_sStateName = this.validateStateName(this.m_jtfStateName.getText());
        this.m_sCountryCode = this.validateCountryCode(this.m_jtfCountryCode.getText());
        this.m_sEmailAddress = this.validateEmailAddress(this.m_jtfEmailAddress.getText());
        this.m_sDnsName = this.validateDnsName(this.m_jtfDnsName.getText());
        if (this.m_sCommonName == null && this.m_sOrganizationUnit == null && this.m_sOrganizationName == null && this.m_sLocalityName == null && this.m_sStateName == null && this.m_sCountryCode == null && this.m_sEmailAddress == null) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateCertificate.ValueReqCertAttr.message"), this.getTitle(), 2);
            return false;
        }
        if (this.m_sCountryCode != null && this.m_sCountryCode.length() != 2) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(FPortecle.RB.getString("DGenerateCertificate.CountryCodeLength.message"), 2), this.getTitle(), 2);
            SwingHelper.selectAndFocus(this.m_jtfCountryCode);
            return false;
        }
        if (!(this.m_sEmailAddress == null || (matcher = MAILBOX_RE.matcher(this.m_sEmailAddress)).matches() && matcher.group(1).length() <= 64 && matcher.group(2).length() <= 255)) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateCertificate.EmailAddressSyntax.message"), this.getTitle(), 2);
            SwingHelper.selectAndFocus(this.m_jtfEmailAddress);
            return false;
        }
        this.m_bSuccess = true;
        return true;
    }

    private int validateValidity(String string) {
        int n;
        if ((string = string.trim()).isEmpty()) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateCertificate.ValReqValidity.message"), this.getTitle(), 2);
            return -1;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateCertificate.ValidityInteger.message"), this.getTitle(), 2);
            return -1;
        }
        if (n < 1) {
            JOptionPane.showMessageDialog(this, FPortecle.RB.getString("DGenerateCertificate.ValidityNonZero.message"), this.getTitle(), 2);
            return -1;
        }
        return n;
    }

    private String validateCommonName(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateOrganisationUnit(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateOrganisationName(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateLocalityName(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateStateName(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateCountryCode(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateEmailAddress(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    private String validateDnsName(String string) {
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    protected X509Certificate generateCertificate(KeyPair keyPair) {
        X509Certificate x509Certificate = null;
        try {
            SignatureType signatureType = (SignatureType)((Object)this.m_jcbSigAlg.getSelectedItem());
            x509Certificate = X509CertUtil.generateCert(this.m_sCommonName, this.m_sOrganizationUnit, this.m_sOrganizationName, this.m_sLocalityName, this.m_sStateName, this.m_sCountryCode, this.m_sEmailAddress, this.m_iValidity, this.m_sDnsName, keyPair.getPublic(), keyPair.getPrivate(), signatureType);
        }
        catch (Exception exception) {
            DThrowable dThrowable = new DThrowable((Window)this, null, exception);
            dThrowable.setLocationRelativeTo(this.getParent());
            SwingHelper.showAndWait(dThrowable);
            this.closeDialog();
        }
        return x509Certificate;
    }

    public boolean isSuccessful() {
        return this.m_bSuccess;
    }

    @Override
    protected void okPressed() {
        if (this.validateValues()) {
            super.okPressed();
        }
    }

    static {
        String string = "[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+";
        String string2 = "[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?";
        String string3 = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
        String string4 = "IPV6:[0-9A-Fa-f]{0,4}(:[0-9A-Fa-f]{0,4})+";
        String string5 = string + "(?:\\." + string + ")*";
        String string6 = string2 + "(?:\\." + string2 + ")*";
        String string7 = "\\[(?:" + string3 + "|" + string4 + ")\\]";
        MAILBOX_RE = Pattern.compile("(" + string5 + ")@(" + string6 + "|" + string7 + ")");
        DEFAULT_VALIDITY = FPortecle.RB.getString("DGenerateCertificate.defaultValidityPeriod");
    }
}

