/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class TGAExtensions {
    private String authorName;
    private String authorComments;
    private Calendar creationDate;
    private String jobId;
    private String softwareId;
    private String softwareVersion;
    private int backgroundColor;
    private double pixelAspectRatio;
    private double gamma;
    private long colorCorrectionOffset;
    private long postageStampOffset;
    private long scanLineOffset;
    private int attributeType;

    private TGAExtensions() {
    }

    static TGAExtensions read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readUnsignedShort();
        if (n < 494) {
            throw new IIOException(String.format("TGA Extension Area size less than %d: %d", 495, n));
        }
        TGAExtensions tGAExtensions = new TGAExtensions();
        tGAExtensions.authorName = TGAExtensions.readString(imageInputStream, 41);
        tGAExtensions.authorComments = TGAExtensions.readString(imageInputStream, 324);
        tGAExtensions.creationDate = TGAExtensions.readDate(imageInputStream);
        tGAExtensions.jobId = TGAExtensions.readString(imageInputStream, 41);
        imageInputStream.skipBytes(6);
        tGAExtensions.softwareId = TGAExtensions.readString(imageInputStream, 41);
        int n2 = imageInputStream.readUnsignedShort();
        char c = (char)imageInputStream.readByte();
        tGAExtensions.softwareVersion = n2 != 0 || c != ' ' ? String.format("%d.%d%s", n2 / 100, n2 % 100, Character.valueOf(c)).trim() : null;
        tGAExtensions.backgroundColor = imageInputStream.readInt();
        tGAExtensions.pixelAspectRatio = TGAExtensions.readRational(imageInputStream);
        tGAExtensions.gamma = TGAExtensions.readRational(imageInputStream);
        tGAExtensions.colorCorrectionOffset = imageInputStream.readUnsignedInt();
        tGAExtensions.postageStampOffset = imageInputStream.readUnsignedInt();
        tGAExtensions.scanLineOffset = imageInputStream.readUnsignedInt();
        tGAExtensions.attributeType = imageInputStream.readUnsignedByte();
        return tGAExtensions;
    }

    private static double readRational(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        return n2 != 0 ? (double)n / (double)n2 : 1.0;
    }

    private static Calendar readDate(ImageInputStream imageInputStream) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        int n5 = imageInputStream.readUnsignedShort();
        int n6 = imageInputStream.readUnsignedShort();
        if (n == 0 && n3 == 0 && n2 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
            return null;
        }
        calendar.set(n3, n - 1, n2, n4, n5, n6);
        return calendar;
    }

    private static String readString(ImageInputStream imageInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        imageInputStream.readFully(byArray);
        return TGAExtensions.asZeroTerminatedASCIIString(byArray);
    }

    private static String asZeroTerminatedASCIIString(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
        }
        return new String(byArray, 0, n, StandardCharsets.US_ASCII);
    }

    public boolean hasAlpha() {
        switch (this.attributeType) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAlphaPremultiplied() {
        switch (this.attributeType) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public long getThumbnailOffset() {
        return this.postageStampOffset;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorComments() {
        return this.authorComments;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getSoftware() {
        return this.softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public double getPixelAspectRatio() {
        return this.pixelAspectRatio;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }
}

