/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Subpart;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public boolean matches(Environment var1);

    public Subpart getSubpart();

    public Range getRange();

    public Selector optimizedBaseCheck();

    public static class OptimizedGeneralSelector
    extends AbstractSelector {
        public final String base;
        public final Range range;
        public final Subpart subpart;

        public OptimizedGeneralSelector(String string, Pair<Integer, Integer> pair, List<Condition> list, Subpart subpart) {
            super(list);
            this.base = string;
            if (pair != null) {
                int n;
                int n2 = pair.a == null ? 0 : (Integer)pair.a;
                int n3 = n = pair.b == null ? Integer.MAX_VALUE : (Integer)pair.b;
                this.range = n2 <= n ? OptimizedGeneralSelector.fromLevel(n2, n) : Range.ZERO_TO_INFINITY;
            } else {
                this.range = Range.ZERO_TO_INFINITY;
            }
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(String string, Range range, List<Condition> list, Subpart subpart) {
            super(list);
            this.base = string;
            this.range = range;
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        public OptimizedGeneralSelector(GeneralSelector generalSelector) {
            this(generalSelector.base, generalSelector.range, (List<Condition>)generalSelector.conds, generalSelector.subpart);
        }

        @Override
        public Subpart getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        public String getBase() {
            return this.base;
        }

        public boolean matchesBase(OsmPrimitiveType osmPrimitiveType) {
            if ("*".equals(this.base)) {
                return true;
            }
            if (OsmPrimitiveType.NODE.equals((Object)osmPrimitiveType)) {
                return "node".equals(this.base);
            }
            if (OsmPrimitiveType.WAY.equals((Object)osmPrimitiveType)) {
                return "way".equals(this.base) || "area".equals(this.base);
            }
            if (OsmPrimitiveType.RELATION.equals((Object)osmPrimitiveType)) {
                return "area".equals(this.base) || "relation".equals(this.base) || "canvas".equals(this.base);
            }
            return false;
        }

        public boolean matchesBase(OsmPrimitive osmPrimitive) {
            if (!this.matchesBase(osmPrimitive.getType())) {
                return false;
            }
            if (osmPrimitive instanceof Relation) {
                if ("area".equals(this.base)) {
                    return ((Relation)osmPrimitive).isMultipolygon();
                }
                if ("canvas".equals(this.base)) {
                    return osmPrimitive.get("#canvas") != null;
                }
            }
            return true;
        }

        public boolean matchesBase(Environment environment) {
            return this.matchesBase(environment.osm);
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public static Range fromLevel(int n, int n2) {
            if (n > n2) {
                throw new AssertionError();
            }
            double d = 0.0;
            double d2 = Double.POSITIVE_INFINITY;
            if (n2 != Integer.MAX_VALUE) {
                d = OptimizedGeneralSelector.level2scale(n2 + 1);
            }
            if (n != 0) {
                d2 = OptimizedGeneralSelector.level2scale(n);
            }
            return new Range(d, d2);
        }

        public static double level2scale(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("lvl must be >= 0 but is " + n);
            }
            return Math.PI * 2 * Ellipsoid.WGS84.a / Math.pow(2.0, n) / 2.56;
        }

        public static int scale2level(double d) {
            if (d < 0.0) {
                throw new IllegalArgumentException("scale must be >= 0 but is " + d);
            }
            return (int)Math.floor(Math.log(Math.PI * 2 * Ellipsoid.WGS84.a / 2.56 / d) / Math.log(2.0));
        }

        public String toString() {
            return this.base + (Range.ZERO_TO_INFINITY.equals(this.range) ? "" : this.range) + Utils.join("", this.conds) + (this.subpart != null && this.subpart != Subpart.DEFAULT_SUBPART ? "::" + this.subpart : "");
        }
    }

    public static class GeneralSelector
    extends OptimizedGeneralSelector {
        public GeneralSelector(String string, Pair<Integer, Integer> pair, List<Condition> list, Subpart subpart) {
            super(string, pair, list, subpart);
        }

        public boolean matchesConditions(Environment environment) {
            return super.matches(environment);
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new OptimizedGeneralSelector(this);
        }

        @Override
        public boolean matches(Environment environment) {
            return this.matchesBase(environment) && super.matches(environment);
        }
    }

    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> list) {
            super(list);
        }

        @Override
        public boolean matches(Environment environment) {
            Utils.ensure(environment.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{environment.getContext()});
            return super.matches(environment);
        }

        @Override
        public Subpart getSubpart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Selector optimizedBaseCheck() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> list) {
            this.conds = list == null || list.isEmpty() ? null : list;
        }

        @Override
        public boolean matches(Environment environment) {
            CheckParameterUtil.ensureParameterNotNull(environment, "env");
            if (this.conds == null) {
                return true;
            }
            for (Condition condition : this.conds) {
                try {
                    if (condition.applies(environment)) continue;
                    return false;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    Main.error((Throwable)patternSyntaxException, "PatternSyntaxException while applying condition" + condition + ':');
                    return false;
                }
            }
            return true;
        }

        public List<Condition> getConditions() {
            if (this.conds == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.conds);
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        public final Selector left;
        public final LinkSelector link;
        public final Selector right;
        public final ChildOrParentSelectorType type;

        public ChildOrParentSelector(Selector selector, LinkSelector linkSelector, Selector selector2, ChildOrParentSelectorType childOrParentSelectorType) {
            CheckParameterUtil.ensureParameterNotNull(selector, "a");
            CheckParameterUtil.ensureParameterNotNull(selector2, "b");
            CheckParameterUtil.ensureParameterNotNull(linkSelector, "link");
            CheckParameterUtil.ensureParameterNotNull((Object)childOrParentSelectorType, "type");
            this.left = selector;
            this.link = linkSelector;
            this.right = selector2;
            this.type = childOrParentSelectorType;
        }

        @Override
        public boolean matches(Environment environment) {
            block27: {
                block26: {
                    if (!this.right.matches(environment)) {
                        return false;
                    }
                    if (ChildOrParentSelectorType.ELEMENT_OF.equals((Object)this.type)) {
                        ContainsFinder containsFinder;
                        if (environment.osm instanceof Node || environment.osm.getDataSet() == null) {
                            return false;
                        }
                        try {
                            if (!(environment.osm instanceof Way) || this.right instanceof OptimizedGeneralSelector && !((OptimizedGeneralSelector)this.right).matchesBase(OsmPrimitiveType.RELATION)) {
                                throw new NoSuchElementException();
                            }
                            SubclassFilteredCollection subclassFilteredCollection = Utils.filteredCollection(SubclassFilteredCollection.filter(environment.osm.getReferrers(), osmPrimitive -> osmPrimitive.hasTag("type", "multipolygon")), Relation.class);
                            Relation relation = (Relation)subclassFilteredCollection.iterator().next();
                            if (relation == null) {
                                throw new NoSuchElementException();
                            }
                            final Set<OsmPrimitive> set = relation.getMemberPrimitives();
                            containsFinder = new ContainsFinder(new Environment(relation)){

                                @Override
                                public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
                                    return super.isPrimitiveUsable(osmPrimitive) && !set.contains(osmPrimitive);
                                }
                            };
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            Main.trace(noSuchElementException);
                            containsFinder = new ContainsFinder(environment);
                        }
                        environment.parent = environment.osm;
                        if (this.left instanceof OptimizedGeneralSelector) {
                            if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.NODE)) {
                                containsFinder.visit(environment.osm.getDataSet().searchNodes(environment.osm.getBBox()));
                            }
                            if (((OptimizedGeneralSelector)this.left).matchesBase(OsmPrimitiveType.WAY)) {
                                containsFinder.visit(environment.osm.getDataSet().searchWays(environment.osm.getBBox()));
                            }
                        } else {
                            containsFinder.visit(environment.osm.getDataSet().allPrimitives());
                        }
                        return environment.child != null;
                    }
                    if (ChildOrParentSelectorType.CROSSING.equals((Object)this.type) && environment.osm instanceof Way) {
                        environment.parent = environment.osm;
                        CrossingFinder crossingFinder = new CrossingFinder(environment);
                        if (this.right instanceof OptimizedGeneralSelector && ((OptimizedGeneralSelector)this.right).matchesBase(OsmPrimitiveType.WAY)) {
                            crossingFinder.visit(environment.osm.getDataSet().searchWays(environment.osm.getBBox()));
                        }
                        return environment.child != null;
                    }
                    if (!ChildOrParentSelectorType.SIBLING.equals((Object)this.type)) break block26;
                    if (!(environment.osm instanceof Node)) break block27;
                    for (Way way : Utils.filteredCollection(environment.osm.getReferrers(true), Way.class)) {
                        Node node;
                        Environment environment2;
                        int n = way.getNodes().indexOf(environment.osm);
                        if (n - 1 < 0 || !this.left.matches(environment2 = environment.withPrimitive(node = way.getNode(n - 1)).withParent(way).withChild(environment.osm)) || !this.link.matches(environment2.withLinkContext())) continue;
                        environment.child = node;
                        environment.index = n;
                        environment.count = way.getNodesCount();
                        environment.parent = way;
                        return true;
                    }
                    break block27;
                }
                if (ChildOrParentSelectorType.CHILD.equals((Object)this.type) && this.link.conds != null && !this.link.conds.isEmpty() && this.link.conds.get(0) instanceof ConditionFactory.OpenEndPseudoClassCondition) {
                    if (environment.osm instanceof Node) {
                        environment.osm.visitReferrers(new MultipolygonOpenEndFinder(environment));
                        return environment.parent != null;
                    }
                } else if (ChildOrParentSelectorType.CHILD.equals((Object)this.type)) {
                    MatchingReferrerFinder matchingReferrerFinder = new MatchingReferrerFinder(environment);
                    environment.osm.visitReferrers(matchingReferrerFinder);
                    if (environment.parent != null) {
                        return true;
                    }
                } else if (ChildOrParentSelectorType.PARENT.equals((Object)this.type)) {
                    if (environment.osm instanceof Way) {
                        List<Node> list = ((Way)environment.osm).getNodes();
                        for (int i = 0; i < list.size(); ++i) {
                            Node node = list.get(i);
                            if (!this.left.matches(environment.withPrimitive(node)) || !this.link.matches(environment.withChildAndIndexAndLinkContext(node, i, list.size()))) continue;
                            environment.child = node;
                            environment.index = i;
                            environment.count = list.size();
                            return true;
                        }
                    } else if (environment.osm instanceof Relation) {
                        List<RelationMember> list = ((Relation)environment.osm).getMembers();
                        for (int i = 0; i < list.size(); ++i) {
                            OsmPrimitive osmPrimitive2 = list.get(i).getMember();
                            if (!this.left.matches(environment.withPrimitive(osmPrimitive2)) || !this.link.matches(environment.withChildAndIndexAndLinkContext(osmPrimitive2, i, list.size()))) continue;
                            environment.child = osmPrimitive2;
                            environment.index = i;
                            environment.count = list.size();
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Subpart getSubpart() {
            return this.right.getSubpart();
        }

        @Override
        public Range getRange() {
            return this.right.getRange();
        }

        @Override
        public Selector optimizedBaseCheck() {
            return new ChildOrParentSelector(this.left, this.link, this.right.optimizedBaseCheck(), this.type);
        }

        public String toString() {
            return this.left.toString() + ' ' + (ChildOrParentSelectorType.PARENT.equals((Object)this.type) ? (char)'<' : '>') + this.link + ' ' + this.right;
        }

        private class ContainsFinder
        extends AbstractFinder {
            protected ContainsFinder(Environment environment) {
                super(environment);
                CheckParameterUtil.ensureThat(!(environment.osm instanceof Node), "Nodes not supported");
            }

            @Override
            public void visit(Node node) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(new Environment(node).withParent(this.e.osm)) && (this.e.osm instanceof Way && Geometry.nodeInsidePolygon(node, ((Way)this.e.osm).getNodes()) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isNodeInsideMultiPolygon(node, (Relation)this.e.osm, null))) {
                    this.e.child = node;
                }
            }

            @Override
            public void visit(Way way) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(new Environment(way).withParent(this.e.osm)) && (this.e.osm instanceof Way && Geometry.PolygonIntersection.FIRST_INSIDE_SECOND.equals((Object)Geometry.polygonIntersection(way.getNodes(), ((Way)this.e.osm).getNodes())) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isPolygonInsideMultiPolygon(way.getNodes(), (Relation)this.e.osm, null))) {
                    this.e.child = way;
                }
            }
        }

        private final class CrossingFinder
        extends AbstractFinder {
            private CrossingFinder(Environment environment) {
                super(environment);
                CheckParameterUtil.ensureThat(environment.osm instanceof Way, "Only ways are supported");
            }

            @Override
            public void visit(Way way) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(new Environment(way).withParent(this.e.osm)) && this.e.osm instanceof Way && Geometry.PolygonIntersection.CROSSING.equals((Object)Geometry.polygonIntersection(way.getNodes(), ((Way)this.e.osm).getNodes()))) {
                    this.e.child = way;
                }
            }
        }

        private class MultipolygonOpenEndFinder
        extends AbstractFinder {
            private final AbstractVisitor innerVisitor;

            @Override
            public void visit(Way way) {
                way.visitReferrers(this.innerVisitor);
            }

            MultipolygonOpenEndFinder(Environment environment) {
                super(environment);
                this.innerVisitor = new AbstractFinder(this.e){

                    @Override
                    public void visit(Relation relation) {
                        List<Node> list;
                        int n;
                        if (ChildOrParentSelector.this.left.matches(this.e.withPrimitive(relation)) && (n = (list = MultipolygonCache.getInstance().get(relation).getOpenEnds()).indexOf(this.e.osm)) >= 0) {
                            this.e.parent = relation;
                            this.e.index = n;
                            this.e.count = list.size();
                        }
                    }
                };
            }
        }

        private static abstract class AbstractFinder
        extends AbstractVisitor {
            protected final Environment e;

            protected AbstractFinder(Environment environment) {
                this.e = environment;
            }

            @Override
            public void visit(Node node) {
            }

            @Override
            public void visit(Way way) {
            }

            @Override
            public void visit(Relation relation) {
            }

            public void visit(Collection<? extends OsmPrimitive> collection) {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (this.e.child != null) break;
                    if (!this.isPrimitiveUsable(osmPrimitive)) continue;
                    osmPrimitive.accept(this);
                }
            }

            public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
                return !this.e.osm.equals(osmPrimitive) && osmPrimitive.isUsable();
            }
        }

        private class MatchingReferrerFinder
        extends AbstractVisitor {
            private final Environment e;

            MatchingReferrerFinder(Environment environment) {
                this.e = environment;
            }

            @Override
            public void visit(Node node) {
                throw new AssertionError();
            }

            private <T extends OsmPrimitive> void doVisit(T t, IntSupplier intSupplier, IntFunction<OsmPrimitive> intFunction) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(t))) {
                    return;
                }
                int n = intSupplier.getAsInt();
                if (ChildOrParentSelector.this.link.conds == null) {
                    this.e.parent = t;
                    this.e.count = n;
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    if (!intFunction.apply(i).equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(t, i, n))) continue;
                    this.e.parent = t;
                    this.e.index = i;
                    this.e.count = n;
                    return;
                }
            }

            @Override
            public void visit(Way way) {
                this.doVisit(way, way::getNodesCount, way::getNode);
            }

            @Override
            public void visit(Relation relation) {
                this.doVisit(relation, relation::getMembersCount, n -> relation.getMember(n).getMember());
            }
        }
    }

    public static enum ChildOrParentSelectorType {
        CHILD,
        PARENT,
        ELEMENT_OF,
        CROSSING,
        SIBLING;

    }
}

