/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\b*\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\"\u0010\u0010\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\n\u0010\u0015\u001a\u00020\b*\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "boxInlineClassIfNeeded", "inlineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "toArrayLiteral", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "unboxInlineClassIfNeeded", "backend.js"})
final class VarargTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    private final IrExpression toArrayLiteral(@NotNull List<? extends IrExpression> $this$toArrayLiteral, IrType type2, IrType varargElementType) {
        Object object;
        block5: {
            block4: {
                Object object2 = this.context.getIntrinsics().getPrimitiveArrays();
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(type2);
                boolean bl = false;
                object = object2.get(irClassifierSymbol);
                if (object == null) break block4;
                object2 = object;
                boolean bl2 = false;
                bl = false;
                Object primitiveType = object2;
                boolean bl3 = false;
                object = this.context.getIntrinsics().getPrimitiveToLiteralConstructor().get(primitiveType);
                if (object != null) break block5;
            }
            object = this.context.getIntrinsics().getArrayLiteral();
        }
        PrimitiveType intrinsic = object;
        IrExpression irExpression = (IrExpression)CollectionsKt.firstOrNull($this$toArrayLiteral);
        int startOffset = irExpression != null ? irExpression.getStartOffset() : -1;
        IrExpression irExpression2 = (IrExpression)CollectionsKt.lastOrNull($this$toArrayLiteral);
        int endOffset = irExpression2 != null ? irExpression2.getEndOffset() : -1;
        IrVarargImpl irVararg = new IrVarargImpl(startOffset, endOffset, type2, varargElementType, $this$toArrayLiteral);
        IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, type2, (IrFunctionSymbol)((Object)intrinsic));
        boolean bl = false;
        boolean bl4 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl5 = false;
        Collection collection = ((IrSimpleFunction)intrinsic.getOwner()).getTypeParameters();
        boolean bl6 = false;
        if (!collection.isEmpty()) {
            $this$apply.putTypeArgument(0, varargElementType);
        }
        $this$apply.putValueArgument(0, irVararg);
        return irCallImpl;
    }

    @NotNull
    public final IrExpression unboxInlineClassIfNeeded(@NotNull IrExpression $this$unboxInlineClassIfNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)$this$unboxInlineClassIfNeeded, (String)"$this$unboxInlineClassIfNeeded");
        IrClass irClass = InlineClassesKt.getInlinedClass($this$unboxInlineClassIfNeeded.getType());
        if (irClass == null) {
            return $this$unboxInlineClassIfNeeded;
        }
        IrClass inlinedClass = irClass;
        IrField field = InlineClassesKt.getInlineClassBackingField(inlinedClass);
        return new IrGetFieldImpl($this$unboxInlineClassIfNeeded.getStartOffset(), $this$unboxInlineClassIfNeeded.getEndOffset(), (IrFieldSymbol)field.getSymbol(), IrUtilsKt.getDefaultType(inlinedClass), $this$unboxInlineClassIfNeeded, null, null, 96, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression boxInlineClassIfNeeded(@NotNull IrExpression $this$boxInlineClassIfNeeded, @Nullable IrClass inlineClass) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)$this$boxInlineClassIfNeeded, (String)"$this$boxInlineClassIfNeeded");
        if (inlineClass == null) {
            irExpression = $this$boxInlineClassIfNeeded;
        } else {
            void $this$single$iv;
            Object object = IrUtilsKt.getConstructors(inlineClass);
            IrType irType = IrUtilsKt.getDefaultType(inlineClass);
            int n = $this$boxInlineClassIfNeeded.getEndOffset();
            int n2 = $this$boxInlineClassIfNeeded.getStartOffset();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                if (!it.isPrimary()) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object var16_17 = single$iv;
            IrFunctionSymbol irFunctionSymbol = ((IrConstructor)var16_17).getSymbol();
            IrType irType2 = irType;
            int n3 = n;
            int n4 = n2;
            object = new IrCallImpl(n4, n3, irType2, irFunctionSymbol);
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            ((IrCallWithIndexedArgumentsBase)it).putValueArgument(0, $this$boxInlineClassIfNeeded);
            irExpression = (IrExpression)object;
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        IrExpression irExpression;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        boolean bl = false;
        List currentList = new ArrayList();
        boolean bl2 = false;
        List segments = new ArrayList();
        IrType elementType = expression2.getVarargElementType();
        IrType primitiveElementType = null;
        IrType primitiveExpressionType = null;
        boolean needUnboxing = false;
        IrClass arrayInlineClass = InlineClassesKt.getInlinedClass(expression2.getType());
        if (arrayInlineClass != null) {
            IrClass irClass = InlineClassesKt.getInlinedClass(elementType);
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            primitiveElementType = InlineClassesKt.getInlineClassBackingField(irClass).getType();
            primitiveExpressionType = InlineClassesKt.getInlineClassBackingField(arrayInlineClass).getType();
            needUnboxing = true;
        } else {
            primitiveElementType = elementType;
            primitiveExpressionType = expression2.getType();
            needUnboxing = false;
        }
        for (IrVarargElement e : expression2.getElements()) {
            object = e;
            if (object instanceof IrSpreadElement) {
                if (!currentList.isEmpty()) {
                    segments.add(this.toArrayLiteral(currentList, primitiveExpressionType, primitiveElementType));
                    currentList.clear();
                }
                segments.add(needUnboxing ? this.unboxInlineClassIfNeeded(((IrSpreadElement)e).getExpression()) : ((IrSpreadElement)e).getExpression());
                continue;
            }
            if (!(object instanceof IrExpression)) continue;
            currentList.add(needUnboxing ? this.unboxInlineClassIfNeeded((IrExpression)e) : (IrExpression)e);
        }
        if (!currentList.isEmpty()) {
            segments.add(this.toArrayLiteral(currentList, primitiveExpressionType, primitiveElementType));
            currentList.clear();
        }
        if (segments.isEmpty()) {
            return this.toArrayLiteral(CollectionsKt.emptyList(), primitiveExpressionType, primitiveElementType);
        }
        if (segments.size() == 1) {
            boolean bl3;
            boolean $i$f$any;
            Object $this$any$iv;
            block19: {
                $this$any$iv = expression2.getElements();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    object = $this$any$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv = object.next();
                        IrVarargElement it = (IrVarargElement)element$iv;
                        boolean bl4 = false;
                        if (!(it instanceof IrSpreadElement)) continue;
                        bl3 = true;
                        break block19;
                    }
                    bl3 = false;
                }
            }
            if (!bl3) {
                IrExpression irExpression2;
                IrExpression res2 = (IrExpression)CollectionsKt.first((List)segments);
                if (needUnboxing) {
                    IrClass irClass = arrayInlineClass;
                    if (irClass == null) {
                        Intrinsics.throwNpe();
                    }
                    irExpression2 = this.boxInlineClassIfNeeded(res2, irClass);
                } else {
                    irExpression2 = res2;
                }
                return irExpression2;
            }
            $this$any$iv = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.context.getIntrinsics().getJsArraySlice().getSymbol());
            $i$f$any = false;
            boolean bl5 = false;
            Object $this$apply = $this$any$iv;
            boolean bl6 = false;
            ((IrCallWithIndexedArgumentsBase)$this$apply).putValueArgument(0, (IrExpression)CollectionsKt.first((List)segments));
            return (IrExpression)$this$any$iv;
        }
        IrExpression arrayLiteral = this.toArrayLiteral(segments, new IrSimpleTypeImpl(this.context.getIntrinsics().getArray(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList()), this.context.getIrBuiltIns().getAnyType());
        IrSimpleFunctionSymbol concatFun = CollectionsKt.contains((Iterable)this.context.getIntrinsics().getPrimitiveArrays().keySet(), (Object)IrTypesKt.getClassifierOrNull(expression2.getType())) ? this.context.getIntrinsics().getPrimitiveArrayConcat() : this.context.getIntrinsics().getArrayConcat();
        IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), concatFun);
        boolean bl7 = false;
        boolean bl8 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl9 = false;
        $this$apply.putValueArgument(0, arrayLiteral);
        IrCallImpl res3 = irCallImpl;
        if (needUnboxing) {
            IrExpression irExpression3 = res3;
            IrClass irClass = arrayInlineClass;
            if (irClass == null) {
                Intrinsics.throwNpe();
            }
            irExpression = this.boxInlineClassIfNeeded(irExpression3, irClass);
        } else {
            irExpression = res3;
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        int size = expression2.getValueArgumentsCount();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            IrExpression argument = expression2.getValueArgument((int)i);
            IrValueParameter parameter = expression2.getSymbol().getOwner().getValueParameters().get((int)i);
            if (argument == null && parameter.getVarargElementType() != null) {
                List list2 = CollectionsKt.emptyList();
                IrType irType = parameter.getType();
                IrType irType2 = parameter.getVarargElementType();
                if (irType2 == null) {
                    Intrinsics.throwNpe();
                }
                expression2.putValueArgument((int)i, this.toArrayLiteral(list2, irType, irType2));
            }
            ++i;
        }
        return expression2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public VarargTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

