/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractArraySnapshot;
import org.gradle.internal.snapshot.impl.ArrayValueSnapshot;

public class IsolatedArray
extends AbstractArraySnapshot<Isolatable<?>>
implements Isolatable<Object[]> {
    public static final IsolatedArray EMPTY = new IsolatedArray((ImmutableList<Isolatable<?>>)ImmutableList.of());

    public IsolatedArray(ImmutableList<Isolatable<?>> elements) {
        super(elements);
    }

    @Override
    public ValueSnapshot asSnapshot() {
        if (this.elements.isEmpty()) {
            return ArrayValueSnapshot.EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.elements.size());
        for (Isolatable element : this.elements) {
            builder.add((Object)element.asSnapshot());
        }
        return new ArrayValueSnapshot((ImmutableList<ValueSnapshot>)builder.build());
    }

    @Override
    public Object[] isolate() {
        Object[] toReturn = new Object[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            Isolatable element = (Isolatable)this.elements.get(i);
            toReturn[i] = element.isolate();
        }
        return toReturn;
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        return null;
    }
}

