/*
 * Decompiled with CFR 0.152.
 */
package SevenZip;

import Common.CRC;
import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import SevenZip.ICodeProgress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LzmaBench {
    static final int kAdditionalSize = 0x200000;
    static final int kCompressedAdditionalSize = 1024;
    static final int kSubBits = 8;

    static int GetLogSize(int n) {
        for (int i = 8; i < 32; ++i) {
            for (int j = 0; j < 256; ++j) {
                if (n > (1 << i) + (j << i - 8)) continue;
                return (i << 8) + j;
            }
        }
        return 8192;
    }

    static long MyMultDiv64(long l, long l2) {
        long l3 = 1000L;
        long l4 = l2;
        while (l3 > 1000000L) {
            l3 >>>= 1;
            l4 >>>= 1;
        }
        if (l4 == 0L) {
            l4 = 1L;
        }
        return l * l3 / l4;
    }

    static long GetCompressRating(int n, long l, long l2) {
        long l3 = LzmaBench.GetLogSize(n) - 4608;
        long l4 = 1060L + (l3 * l3 * 10L >> 16);
        long l5 = l2 * l4;
        return LzmaBench.MyMultDiv64(l5, l);
    }

    static long GetDecompressRating(long l, long l2, long l3) {
        long l4 = l3 * 220L + l2 * 20L;
        return LzmaBench.MyMultDiv64(l4, l);
    }

    static long GetTotalRating(int n, long l, long l2, long l3, long l4, long l5) {
        return (LzmaBench.GetCompressRating(n, l, l2) + LzmaBench.GetDecompressRating(l3, l4, l5)) / 2L;
    }

    static void PrintValue(long l) {
        String string = "";
        string = string + l;
        int n = 0;
        while (n + string.length() < 6) {
            System.out.print(" ");
            ++n;
        }
        System.out.print(string);
    }

    static void PrintRating(long l) {
        LzmaBench.PrintValue(l / 1000000L);
        System.out.print(" MIPS");
    }

    static void PrintResults(int n, long l, long l2, boolean bl, long l3) {
        long l4 = LzmaBench.MyMultDiv64(l2, l);
        LzmaBench.PrintValue(l4 / 1024L);
        System.out.print(" KB/s  ");
        long l5 = bl ? LzmaBench.GetDecompressRating(l, l2, l3) : LzmaBench.GetCompressRating(n, l, l2);
        LzmaBench.PrintRating(l5);
    }

    public static int LzmaBenchmark(int n, int n2) throws Exception {
        if (n <= 0) {
            return 0;
        }
        if (n2 < 262144) {
            System.out.println("\nError: dictionary size for benchmark must be >= 18 (256 KB)");
            return 1;
        }
        System.out.print("\n       Compressing                Decompressing\n\n");
        Encoder encoder = new Encoder();
        Decoder decoder = new Decoder();
        if (!encoder.SetDictionarySize(n2)) {
            throw new Exception("Incorrect dictionary size");
        }
        int n3 = n2 + 0x200000;
        int n4 = n3 / 2 + 1024;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        encoder.WriteCoderProperties(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        decoder.SetDecoderProperties2(byArray);
        CBenchRandomGenerator cBenchRandomGenerator = new CBenchRandomGenerator();
        cBenchRandomGenerator.Set(n3);
        cBenchRandomGenerator.Generate();
        CRC cRC = new CRC();
        cRC.Init();
        cRC.Update(cBenchRandomGenerator.Buffer, 0, cBenchRandomGenerator.BufferSize);
        CProgressInfo cProgressInfo = new CProgressInfo();
        cProgressInfo.ApprovedStart = n2;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        MyInputStream myInputStream = new MyInputStream(cBenchRandomGenerator.Buffer, cBenchRandomGenerator.BufferSize);
        byte[] byArray2 = new byte[n4];
        MyOutputStream myOutputStream = new MyOutputStream(byArray2);
        CrcOutStream crcOutStream = new CrcOutStream();
        MyInputStream myInputStream2 = null;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            cProgressInfo.Init();
            myInputStream.reset();
            myOutputStream.reset();
            encoder.Code(myInputStream, myOutputStream, -1L, -1L, cProgressInfo);
            long l5 = System.currentTimeMillis() - cProgressInfo.Time;
            if (i == 0) {
                n5 = myOutputStream.size();
                myInputStream2 = new MyInputStream(byArray2, n5);
            } else if (n5 != myOutputStream.size()) {
                throw new Exception("Encoding error");
            }
            if (cProgressInfo.InSize == 0L) {
                throw new Exception("Internal ERROR 1282");
            }
            long l6 = 0L;
            for (int j = 0; j < 2; ++j) {
                myInputStream2.reset();
                crcOutStream.Init();
                long l7 = n3;
                long l8 = System.currentTimeMillis();
                if (decoder.Code(myInputStream2, crcOutStream, l7, null) != 0) {
                    throw new Exception("Decoding Error");
                }
                l6 = System.currentTimeMillis() - l8;
                if (crcOutStream.GetDigest() == cRC.GetDigest()) continue;
                throw new Exception("CRC Error");
            }
            long l9 = (long)n3 - cProgressInfo.InSize;
            LzmaBench.PrintResults(n2, l5, l9, false, 0L);
            System.out.print("     ");
            LzmaBench.PrintResults(n2, l6, n3, true, n5);
            System.out.println();
            l += l9;
            l2 += l5;
            l3 += l6;
            l4 += (long)n5;
        }
        System.out.println("---------------------------------------------------");
        LzmaBench.PrintResults(n2, l2, l, false, 0L);
        System.out.print("     ");
        LzmaBench.PrintResults(n2, l3, (long)n3 * (long)n, true, l4);
        System.out.println("    Average");
        return 0;
    }

    static class CProgressInfo
    implements ICodeProgress {
        public long ApprovedStart;
        public long InSize;
        public long Time;

        CProgressInfo() {
        }

        public void Init() {
            this.InSize = 0L;
        }

        @Override
        public void SetProgress(long l, long l2) {
            if (l >= this.ApprovedStart && this.InSize == 0L) {
                this.Time = System.currentTimeMillis();
                this.InSize = l;
            }
        }
    }

    static class MyInputStream
    extends InputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyInputStream(byte[] byArray, int n) {
            this._buffer = byArray;
            this._size = n;
        }

        @Override
        public void reset() {
            this._pos = 0;
        }

        @Override
        public int read() {
            if (this._pos >= this._size) {
                return -1;
            }
            return this._buffer[this._pos++] & 0xFF;
        }
    }

    static class MyOutputStream
    extends OutputStream {
        byte[] _buffer;
        int _size;
        int _pos;

        public MyOutputStream(byte[] byArray) {
            this._buffer = byArray;
            this._size = this._buffer.length;
        }

        public void reset() {
            this._pos = 0;
        }

        @Override
        public void write(int n) throws IOException {
            if (this._pos >= this._size) {
                throw new IOException("Error");
            }
            this._buffer[this._pos++] = (byte)n;
        }

        public int size() {
            return this._pos;
        }
    }

    static class CrcOutStream
    extends OutputStream {
        public CRC CRC = new CRC();

        CrcOutStream() {
        }

        public void Init() {
            this.CRC.Init();
        }

        public int GetDigest() {
            return this.CRC.GetDigest();
        }

        @Override
        public void write(byte[] byArray) {
            this.CRC.Update(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.CRC.Update(byArray, n, n2);
        }

        @Override
        public void write(int n) {
            this.CRC.UpdateByte(n);
        }
    }

    static class CBenchRandomGenerator {
        CBitRandomGenerator RG = new CBitRandomGenerator();
        int Pos;
        int Rep0;
        public int BufferSize;
        public byte[] Buffer = null;

        public void Set(int n) {
            this.Buffer = new byte[n];
            this.Pos = 0;
            this.BufferSize = n;
        }

        int GetRndBit() {
            return this.RG.GetRnd(1);
        }

        int GetLogRandBits(int n) {
            int n2 = this.RG.GetRnd(n);
            return this.RG.GetRnd(n2);
        }

        int GetOffset() {
            if (this.GetRndBit() == 0) {
                return this.GetLogRandBits(4);
            }
            return this.GetLogRandBits(4) << 10 | this.RG.GetRnd(10);
        }

        int GetLen1() {
            return this.RG.GetRnd(1 + this.RG.GetRnd(2));
        }

        int GetLen2() {
            return this.RG.GetRnd(2 + this.RG.GetRnd(2));
        }

        public void Generate() {
            this.RG.Init();
            this.Rep0 = 1;
            while (this.Pos < this.BufferSize) {
                int n;
                if (this.GetRndBit() == 0 || this.Pos < 1) {
                    this.Buffer[this.Pos++] = (byte)this.RG.GetRnd(8);
                    continue;
                }
                if (this.RG.GetRnd(3) == 0) {
                    n = 1 + this.GetLen1();
                } else {
                    do {
                        this.Rep0 = this.GetOffset();
                    } while (this.Rep0 >= this.Pos);
                    ++this.Rep0;
                    n = 2 + this.GetLen2();
                }
                int n2 = 0;
                while (n2 < n && this.Pos < this.BufferSize) {
                    this.Buffer[this.Pos] = this.Buffer[this.Pos - this.Rep0];
                    ++n2;
                    ++this.Pos;
                }
            }
        }
    }

    static class CBitRandomGenerator {
        CRandomGenerator RG = new CRandomGenerator();
        int Value;
        int NumBits;

        CBitRandomGenerator() {
        }

        public void Init() {
            this.Value = 0;
            this.NumBits = 0;
        }

        public int GetRnd(int n) {
            if (this.NumBits > n) {
                int n2 = this.Value & (1 << n) - 1;
                this.Value >>>= n;
                this.NumBits -= n;
                return n2;
            }
            int n3 = this.Value << (n -= this.NumBits);
            this.Value = this.RG.GetRnd();
            this.Value >>>= n;
            this.NumBits = 32 - n;
            return n3 |= this.Value & (1 << n) - 1;
        }
    }

    static class CRandomGenerator {
        int A1;
        int A2;

        public CRandomGenerator() {
            this.Init();
        }

        public void Init() {
            this.A1 = 362436069;
            this.A2 = 521288629;
        }

        public int GetRnd() {
            this.A1 = 36969 * (this.A1 & 0xFFFF) + (this.A1 >>> 16);
            this.A2 = 18000 * (this.A2 & 0xFFFF) + (this.A2 >>> 16);
            return this.A1 << 16 ^ this.A2;
        }
    }
}

