/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.F;
import com.informagen.Sequence;
import com.informagen.report.ReportLayout;
import com.informagen.report.SequenceMember;
import com.informagen.report.TranslationFrameMember;
import com.informagen.sa.digest.CutSite;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestReportPanel;
import com.informagen.sa.digest.EnzymeCuts;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class RestrictionMapPanel
extends DigestReportPanel {
    static final int basesPerLine = 60;

    public RestrictionMapPanel() {
        super("Map");
    }

    public void digestChanged(Digest digest) {
        this.writeHeader(digest);
        Vector vector = digest.getCutters();
        ReportLayout reportLayout = new ReportLayout();
        String string = digest.getSequence().getSequence();
        reportLayout.add(new SequenceMember(string, 8));
        StringBuffer stringBuffer = new StringBuffer(Sequence.revComp(string));
        stringBuffer.reverse();
        reportLayout.add(new SequenceMember(stringBuffer.toString(), 8));
        reportLayout.add(new TranslationFrameMember(string, 9, 1));
        reportLayout.add(new TranslationFrameMember(string, 9, 2));
        reportLayout.add(new TranslationFrameMember(string, 9, 3));
        StringWriter stringWriter = new StringWriter();
        try {
            Comparator comparator = CutSite.getComparator();
            for (int i = 0; i <= string.length(); i += 60) {
                Vector vector2 = this.findCutsInRange(vector, i, i + 60);
                Collections.sort(vector2, comparator);
                Collections.reverse(vector2);
                Iterator iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    CutSite cutSite = (CutSite)iterator.next();
                    String string2 = cutSite.getEnzymeName();
                    int n = cutSite.getPatternPosition() % 60;
                    n = n == 0 ? 60 : n;
                    n -= string2.length();
                    --n;
                    ((Writer)stringWriter).write(F.f(" ", n += 8, (short)16));
                    ((Writer)stringWriter).write(cutSite.getEnzymeName());
                    ((Writer)stringWriter).write(" ");
                    ((Writer)stringWriter).write(cutSite.getEnzymeSite());
                    ((Writer)stringWriter).write(" ");
                    ((Writer)stringWriter).write("\n");
                }
                reportLayout.write(stringWriter, i, i + 60);
                ((Writer)stringWriter).write("\n\n");
            }
            ((Writer)stringWriter).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.textArea.append(((Object)stringWriter).toString());
        this.textArea.setCaretPosition(0);
    }

    private Vector findCutsInRange(Vector vector, int n, int n2) {
        Vector<CutSite> vector2 = new Vector<CutSite>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            EnzymeCuts enzymeCuts = (EnzymeCuts)iterator.next();
            Iterator iterator2 = enzymeCuts.getCutSites().iterator();
            while (iterator2.hasNext()) {
                CutSite cutSite = (CutSite)iterator2.next();
                int n3 = cutSite.getCutPosition();
                if (n3 <= n || n3 > n2) continue;
                vector2.addElement(cutSite);
            }
        }
        return vector2;
    }
}

