/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.Sequence;
import com.informagen.sa.digest.EnzymeComparator;
import java.util.Comparator;

public class Enzyme {
    private static EnzymeComparator comparator = null;
    final String name;
    final String site;
    int forwardOffset;
    int reverseOffset;
    final int[] pattern;
    boolean perfect = true;

    Enzyme(String string, String string2) {
        this(string, string2, string2.indexOf(47), string2.length() - string2.indexOf(47));
    }

    Enzyme(String string, String string2, int n, int n2) {
        int n3;
        this.name = string;
        this.site = string2;
        this.forwardOffset = n;
        this.reverseOffset = n2;
        int[] nArray = Sequence.toBinary(string2);
        int n4 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            int n5 = nArray[n3];
            if (n5 != 0) {
                ++n4;
            }
            if (n5 == 1 || n5 == 2 || n5 == 4 || n5 == 8 || n5 == 0) continue;
            this.perfect = false;
        }
        this.pattern = new int[n4];
        n4 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] == 0) continue;
            this.pattern[n4] = nArray[n3];
            ++n4;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSite() {
        return this.site;
    }

    public int[] getPattern() {
        return this.pattern;
    }

    public boolean isFourCutter() {
        return this.pattern.length == 4;
    }

    public boolean isSixCutter() {
        return this.pattern.length == 6;
    }

    public boolean isPerfect() {
        return this.perfect;
    }

    public int getForwardOffset() {
        return this.forwardOffset;
    }

    public int getReverseOffset() {
        return this.reverseOffset;
    }

    public static Comparator getComparator() {
        if (comparator == null) {
            comparator = new EnzymeComparator();
        }
        return comparator;
    }
}

