/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import com.informagen.Sequence;
import com.informagen.sa.NCBItinyseqHandler;
import com.informagen.sa.SequenceAnalysis;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JOptionPane;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FarFetch {
    private static String hostAddress = "http://eutils.ncbi.nlm.nih.gov";
    private static String fetchSEQ = "/entrez/eutils/efetch.fcgi?db=nucleotide&rettype=fasta&retmode=xml&id=";
    private static String fetchGBX = "/entrez/eutils/efetch.fcgi?db=nucleotide&rettype=gb&retmode=xml&id=";

    public static Sequence fetchViaGID(int n) {
        return FarFetch.fetchViaGID(Integer.toString(n));
    }

    public static Sequence fetchViaGID(String string) {
        Sequence sequence = null;
        try {
            HttpClient httpClient = new HttpClient();
            GetMethod getMethod = new GetMethod(hostAddress + fetchSEQ + string);
            int n = httpClient.executeMethod(getMethod);
            if (n != 200) {
                JOptionPane.showMessageDialog(null, "Could not fetch sequence via ID: " + string);
                return null;
            }
            byte[] byArray = getMethod.getResponseBody();
            getMethod.releaseConnection();
            NCBItinyseqHandler nCBItinyseqHandler = new NCBItinyseqHandler();
            XMLReader xMLReader = SequenceAnalysis.getXMLReader();
            ErrorHandler errorHandler = SequenceAnalysis.getSAXErrorHandler();
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setContentHandler(nCBItinyseqHandler);
            sequence = new Sequence();
            nCBItinyseqHandler.setSequence(sequence);
            StringReader stringReader = new StringReader(new String(byArray));
            xMLReader.parse(new InputSource(stringReader));
        }
        catch (HttpRecoverableException httpRecoverableException) {
            JOptionPane.showMessageDialog(null, "Error handling HTTP request: " + httpRecoverableException.getMessage());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException);
            sequence = null;
        }
        catch (SAXException sAXException) {
            JOptionPane.showMessageDialog(null, "Could not fetch sequence via ID: " + string + "\n" + sAXException.toString());
            sequence = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return sequence;
    }

    public static String fetchGBXViaGID(int n) {
        return FarFetch.fetchGBXViaGID(Integer.toString(n));
    }

    public static String fetchGBXViaGID(String string) {
        String string2 = null;
        try {
            HttpClient httpClient = new HttpClient();
            GetMethod getMethod = new GetMethod(hostAddress + fetchGBX + string);
            int n = httpClient.executeMethod(getMethod);
            if (n != 200) {
                JOptionPane.showMessageDialog(null, "Could not fetch sequence via ID: " + string);
                return null;
            }
            byte[] byArray = getMethod.getResponseBody();
            getMethod.releaseConnection();
            string2 = new String(byArray);
        }
        catch (HttpRecoverableException httpRecoverableException) {
            JOptionPane.showMessageDialog(null, "Error handling HTTP request: " + httpRecoverableException.getMessage());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException);
            string2 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

