/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.F;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

class MapRuler
extends JComponent {
    static final int FONTSIZE = 10;
    static final Color rulerColor = new Color(230, 163, 4);
    boolean isKbp = false;
    private int minExtent = 0;
    private int maxExtent = 0;
    private int extent = 0;
    private int pixelWidth = 0;
    private int pixelsPerTick = 0;
    private int bpPerTick = 0;
    Font labelFont;
    FontMetrics fontMetrics;
    int mark = Integer.MIN_VALUE;

    MapRuler() {
    }

    int getRulerHeight() {
        return (int)((double)this.getFontHeight() * 2.5);
    }

    int getMajorTickHeight() {
        return (int)((double)this.getFontHeight() * 0.5);
    }

    int getFontHeight() {
        if (this.fontMetrics == null) {
            this.instanceFont();
        }
        return this.fontMetrics.getHeight();
    }

    void showValueAt(int n) {
        this.mark = n;
    }

    void setExtent(int n, int n2) {
        this.minExtent = n;
        this.maxExtent = n2;
        this.extent = n2 - n;
    }

    private void setIncrementAndUnits() {
        if (this.extent != 0 && this.pixelWidth != 0) {
            double d = (double)this.pixelWidth / (double)this.extent;
            int n = 70;
            this.bpPerTick = (int)((double)n * ((double)this.extent / (double)this.pixelWidth));
            this.bpPerTick = this.bpPerTick / 100 * 100;
            if (this.bpPerTick == 0) {
                this.bpPerTick = 100;
            }
            this.pixelsPerTick = this.bpPerTick * this.pixelWidth / this.extent;
            this.isKbp = this.bpPerTick > 200;
        }
    }

    void setPreferredWidth(int n) {
        this.pixelWidth = n;
        this.setPreferredSize(new Dimension(n, this.getRulerHeight()));
        this.setIncrementAndUnits();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        if (this.extent == 0 || this.pixelWidth == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(rulerColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.labelFont == null) {
            this.instanceFont();
        }
        graphics.setFont(this.labelFont);
        graphics.setColor(Color.black);
        this.setIncrementAndUnits();
        if (this.getSize().width == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = null;
        n4 = rectangle.x;
        n3 = rectangle.x + rectangle.width;
        int n6 = this.valueAtPixel(n4);
        int n7 = this.valueAtPixel(n3);
        for (n2 = n6 = n6 / this.bpPerTick * this.bpPerTick; n2 < n7; n2 += this.bpPerTick) {
            if (n2 < 0) continue;
            string = this.isKbp ? F.f((double)n2 / 1000.0, Integer.MAX_VALUE, 1) : Integer.toString(n2);
            n = this.fontMetrics.stringWidth(string);
            int n8 = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
            n5 = this.getMajorTickHeight();
            if (n2 == 0) {
                string = string + (this.isKbp ? " Kb" : " bp");
            }
            if (n5 == 0) continue;
            int n9 = (n2 - this.minExtent) * this.pixelWidth / this.extent;
            graphics.drawLine(n9, this.getRulerHeight() - 1, n9, this.getRulerHeight() - n5 - 1);
            if (string == null) continue;
            graphics.drawString(string, n9 - (n >> 1), n8);
        }
        if (this.mark > Integer.MIN_VALUE) {
            string = Integer.toString(this.valueAtPixel(this.mark));
            n2 = this.fontMetrics.stringWidth(string);
            n = this.fontMetrics.getHeight() - this.fontMetrics.getDescent();
            graphics.drawString(string, this.mark - (n2 >> 1) - 1, n);
        }
    }

    private void instanceFont() {
        this.labelFont = new Font("SansSerif", 0, 10);
        this.fontMetrics = this.getFontMetrics(this.labelFont);
    }

    private int valueAtPixel(int n) {
        return n == Integer.MIN_VALUE ? this.minExtent : n * this.extent / this.pixelWidth + this.minExtent;
    }
}

