/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaIconFactory;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.ImageDecodeParam;
import ch.randelshofer.quaqua.ext.batik.ext.awt.image.codec.util.MemoryCacheSeekableStream;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Application {
    private static final boolean DEBUG = true;
    private static final boolean isNativeCodeAvailable;

    private Application() {
    }

    public static void requestUserAttention(boolean requestCritical) {
        if (isNativeCodeAvailable) {
            Application.jniRequestUserAttention(true);
        } else {
            try {
                Object app = Methods.invokeStatic("com.apple.cocoa.application.NSApplication", "sharedApplication");
                Methods.invoke(app, "requestUserAttention", app.getClass().getDeclaredField("UserAttentionRequestInformational").getInt(app));
            }
            catch (Throwable ex) {
                System.err.println("Quaqua Warning: Couldn't invoke NSApplication.requestUserAttention");
            }
        }
    }

    private static native void jniRequestUserAttention(boolean var0);

    public static BufferedImage getIconImage(int size) {
        BufferedImage image = null;
        if (isNativeCodeAvailable) {
            try {
                byte[] tiffData = Application.jniGetIconImage(size);
                TIFFImageDecoder decoder = new TIFFImageDecoder(new MemoryCacheSeekableStream(new ByteArrayInputStream(tiffData)), (ImageDecodeParam)new TIFFDecodeParam());
                RenderedImage rImg = decoder.decodeAsRenderedImage(0);
                image = Images.toBufferedImage(rImg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (image == null) {
            image = Images.toBufferedImage(Images.createImage(QuaquaIconFactory.class.getResource("/ch/randelshofer/quaqua/images/ApplicationIcon.png")));
        }
        if (image.getWidth() != size) {
            BufferedImage tmp = new BufferedImage(size, size, 2);
            Graphics2D g = tmp.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(image, 0, 0, size, size, null);
            g.dispose();
            image = tmp;
        }
        return image;
    }

    private static native byte[] jniGetIconImage(int var0);

    static {
        boolean success;
        String value = QuaquaManager.getProperty("Quaqua.jniIsPreloaded");
        if (value == null) {
            value = QuaquaManager.getProperty("Quaqua.JNI.isPreloaded");
        }
        if (value != null && value.equals("true")) {
            success = true;
        } else {
            try {
                System.loadLibrary("quaqua");
                success = true;
            }
            catch (Throwable e) {
                System.err.println("Warning: " + Application.class + " couldn't load library libquaqua.jnilib.");
                success = false;
            }
        }
        isNativeCodeAvailable = success;
    }
}

