/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorder;
import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.QuaquaButtonListener;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.HalfbrightFilter;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.Methods;
import ch.randelshofer.quaqua.util.ShadowFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class QuaquaButtonUI
extends BasicButtonUI
implements VisuallyLayoutable {
    private static final QuaquaButtonUI buttonUI = new QuaquaButtonUI();
    private static Rectangle viewR = new Rectangle();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        String pp = this.getPropertyPrefix();
        QuaquaUtilities.installProperty(b, "opaque", UIManager.get(pp + "opaque"));
        b.setRequestFocusEnabled(QuaquaManager.getBoolean(pp + "requestFocusEnabled"));
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new QuaquaButtonListener(b);
    }

    public void paint(Graphics g, JComponent c) {
        Border b;
        String style = (String)c.getClientProperty("Quaqua.Button.style");
        if (style != null && style.equals("help")) {
            Insets insets = c.getInsets();
            UIManager.getIcon("Button.helpIcon").paintIcon(c, g, insets.left, insets.top);
            return;
        }
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        if (((AbstractButton)c).isBorderPainted() && (b = c.getBorder()) != null && b instanceof BackgroundBorder) {
            ((BackgroundBorder)b).getBackgroundBorder().paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
        super.paint(g, c);
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, c, this);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        this.paintText(g, (AbstractButton)c, textRect, text);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = Methods.invokeGetter((Object)b, "getDisplayedMnemonicIndex", -1);
        boolean borderHasPressedCue = this.borderHasPressedCue(b);
        if (model.isPressed() && model.isArmed() && !borderHasPressedCue) {
            g.setColor(new Color(-1610612736, true));
            QuaquaUtilities.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset() + 1);
        }
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            Color c = UIManager.getColor(this.getPropertyPrefix() + "disabledForeground");
            g.setColor(c != null ? c : b.getForeground());
        }
        QuaquaUtilities.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        Icon shadowIcon = null;
        boolean borderHasPressedCue = this.borderHasPressedCue(b);
        if (icon == null) {
            return;
        }
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            } else if (icon != null && icon instanceof ImageIcon && !borderHasPressedCue) {
                tmpIcon = new ImageIcon(HalfbrightFilter.createHalfbrightImage(((ImageIcon)icon).getImage()));
                shadowIcon = new ImageIcon(ShadowFilter.createShadowImage(((ImageIcon)icon).getImage()));
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected()) {
                tmpIcon = b.getRolloverSelectedIcon();
                if (tmpIcon == null) {
                    tmpIcon = b.getSelectedIcon();
                }
            } else {
                tmpIcon = b.getRolloverIcon();
            }
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (model.isPressed() && model.isArmed()) {
            if (shadowIcon != null) {
                shadowIcon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset() + 1);
            }
            icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    private boolean isFixedHeight(JComponent c) {
        Border b = c.getBorder();
        if (b != null && b instanceof BackgroundBorder && (b = ((BackgroundBorder)b).getBackgroundBorder()) != null && b instanceof QuaquaButtonBorder) {
            return ((QuaquaButtonBorder)b).isFixedHeight(c);
        }
        return false;
    }

    private boolean borderHasPressedCue(AbstractButton c) {
        if (c.isBorderPainted()) {
            Border b = c.getBorder();
            if (b != null && b instanceof BackgroundBorder && (b = ((BackgroundBorder)b).getBackgroundBorder()) != null && b instanceof QuaquaButtonBorder) {
                return ((QuaquaButtonBorder)b).hasPressedCue(c);
            }
            return b != null;
        }
        return false;
    }

    protected String getPropertyPrefix() {
        return super.getPropertyPrefix();
    }

    public Dimension getMinimumSize(JComponent c) {
        String style = (String)c.getClientProperty("Quaqua.Button.style");
        if (style != null && style.equals("help")) {
            return this.getPreferredSize(c);
        }
        Dimension d = super.getMinimumSize(c);
        if (this.isFixedHeight(c)) {
            Dimension p = this.getPreferredSize(c);
            d.height = Math.max(d.height, p.height);
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return QuaquaButtonUI.getPreferredSize((AbstractButton)c);
    }

    public Dimension getMaximumSize(JComponent c) {
        String style = (String)c.getClientProperty("Quaqua.Button.style");
        if (style != null && style.equals("help")) {
            return this.getPreferredSize(c);
        }
        Dimension d = super.getMaximumSize(c);
        if (this.isFixedHeight(c)) {
            Dimension p = this.getPreferredSize(c);
            d.height = Math.max(d.height, p.height);
        }
        return d;
    }

    public static Dimension getPreferredSize(AbstractButton b) {
        String style = (String)b.getClientProperty("Quaqua.Button.style");
        if (style != null && style.equals("help")) {
            Icon helpIcon = UIManager.getIcon("Button.helpIcon");
            Insets insets = b.getInsets();
            return new Dimension(helpIcon.getIconWidth() + insets.left + insets.right, helpIcon.getIconHeight() + insets.top + insets.bottom);
        }
        if (b.getComponentCount() > 0) {
            return null;
        }
        int textIconGap = Methods.invokeGetter((Object)b, "getIconTextGap", 4);
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        QuaquaButtonUI.viewR.y = 0;
        QuaquaButtonUI.viewR.x = 0;
        QuaquaButtonUI.viewR.width = Short.MAX_VALUE;
        QuaquaButtonUI.viewR.height = Short.MAX_VALUE;
        QuaquaButtonUI.iconR.height = 0;
        QuaquaButtonUI.iconR.width = 0;
        QuaquaButtonUI.iconR.y = 0;
        QuaquaButtonUI.iconR.x = 0;
        QuaquaButtonUI.textR.height = 0;
        QuaquaButtonUI.textR.width = 0;
        QuaquaButtonUI.textR.y = 0;
        QuaquaButtonUI.textR.x = 0;
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : textIconGap);
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    protected String layoutCL(AbstractButton c, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(c, fontMetrics, text, icon, c.getVerticalAlignment(), c.getHorizontalAlignment(), c.getVerticalTextPosition(), c.getHorizontalTextPosition(), viewR, iconR, textR, Methods.invokeGetter((Object)c, "getIconTextGap", 4));
    }

    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Icon icon;
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        AbstractButton b = (AbstractButton)c;
        if (type == 1 && b.getBorder() != null && b.isBorderPainted()) {
            Border border = b.getBorder();
            if (border instanceof BackgroundBorder) {
                if ((border = ((BackgroundBorder)border).getBackgroundBorder()) instanceof VisualMargin) {
                    InsetsUtil.subtractInto(((VisualMargin)border).getVisualMargin(c), bounds);
                } else if (border instanceof QuaquaButtonBorder) {
                    InsetsUtil.subtractInto(((QuaquaButtonBorder)border).getVisualMargin(c), bounds);
                }
            }
            return bounds;
        }
        String text = b.getText();
        Icon icon2 = icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        if (icon == null && text == null) {
            return null;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets insets = c.getInsets(viewInsets);
        QuaquaButtonUI.viewR.x = insets.left;
        QuaquaButtonUI.viewR.y = insets.top;
        QuaquaButtonUI.viewR.width = width - (insets.left + insets.right);
        QuaquaButtonUI.viewR.height = height - (insets.top + insets.bottom);
        QuaquaButtonUI.iconR.height = 0;
        QuaquaButtonUI.iconR.width = 0;
        QuaquaButtonUI.iconR.y = 0;
        QuaquaButtonUI.iconR.x = 0;
        QuaquaButtonUI.textR.height = 0;
        QuaquaButtonUI.textR.width = 0;
        QuaquaButtonUI.textR.y = 0;
        QuaquaButtonUI.textR.x = 0;
        String clippedText = this.layoutCL(b, fm, text, icon, viewR, iconR, textR);
        Rectangle textBounds = Fonts.getPerceivedBounds(text, c.getFont(), c);
        int ascent = fm.getAscent();
        QuaquaButtonUI.textR.y += ascent + textBounds.y;
        QuaquaButtonUI.textR.height = textBounds.height;
        bounds.setBounds(textR);
        return bounds;
    }
}

