/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.ports;

import edsim51sh.Sizes;
import edsim51sh.ports.Pin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PortPinDescriptions {
    private Sizes sizes = new Sizes();
    private Pin[] pins = new Pin[32];
    private Color blue = new Color(153, 153, 255);
    private Dimension smallDim;
    private Dimension largeDim;
    private Dimension dim;
    private Font smallFont;
    private Font largeFont;
    private Font font;

    public PortPinDescriptions() {
        this.smallDim = this.sizes.portBitFieldSmall;
        this.largeDim = this.sizes.portBitFieldLarge;
        this.smallFont = this.sizes.portPinFontSmall;
        this.largeFont = this.sizes.portPinFontLarge;
        int portNumber = 0;
        int pinNumber = 0;
        for (int i = 0; i < 32; ++i) {
            this.pins[i] = new Pin(portNumber, pinNumber);
            if (portNumber == 0 || portNumber == 2) {
                this.pins[i].getPinLabel().setForeground(Color.WHITE);
                this.pins[i].getDescriptionLabel().setForeground(Color.WHITE);
            } else {
                this.pins[i].getPinLabel().setForeground(this.blue);
                this.pins[i].getDescriptionLabel().setForeground(this.blue);
            }
            if (++pinNumber != 8) continue;
            pinNumber = 0;
            ++portNumber;
        }
    }

    public void setSize(boolean small) {
        if (small) {
            this.dim = this.smallDim;
            this.font = this.smallFont;
        } else {
            this.dim = this.largeDim;
            this.font = this.largeFont;
        }
        for (int i = 0; i < 32; ++i) {
            JTextField field = this.pins[i].getField();
            field.setMinimumSize(this.dim);
            field.setMaximumSize(this.dim);
            field.setPreferredSize(this.dim);
            this.pins[i].getPinLabel().setFont(this.font);
            this.pins[i].getDescriptionLabel().setFont(this.font);
        }
    }

    public void setPortPinValue(int portNumber, int pinNumber, int bitValue) {
        int index = portNumber * 8 + pinNumber;
        this.pins[index].setField(bitValue);
    }

    public void setPortPinDescription(int portNumber, int pinNumber, String description, String toolTip) {
        int index = portNumber * 8 + pinNumber;
        this.pins[index].setPortPinDescription(portNumber, pinNumber, description, toolTip);
    }

    public JLabel getPinLabel(int portNumber, int pinNumber) {
        int index = portNumber * 8 + pinNumber;
        return this.pins[index].getPinLabel();
    }

    public JLabel getDescriptionLabel(int portNumber, int pinNumber) {
        int index = portNumber * 8 + pinNumber;
        return this.pins[index].getDescriptionLabel();
    }

    public String[][] getEntirePortDescriptionAndToolTip(int portNumber) {
        String[][] ss = new String[2][8];
        int base = portNumber * 8;
        for (int i = 0; i < 8; ++i) {
            ss[0][i] = this.pins[base + i].getDescription();
            ss[1][i] = this.pins[base + i].getToolTip();
        }
        return ss;
    }

    public JTextField getField(int portNumber, int pinNumber) {
        int index = portNumber * 8 + pinNumber;
        return this.pins[index].getField();
    }

    public Pin[] getPins() {
        return this.pins;
    }
}

