/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.anl;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.anl.AnlAaddress;
import edsim51sh.instructions.anl.AnlAatReg;
import edsim51sh.instructions.anl.AnlAdata;
import edsim51sh.instructions.anl.AnlAddressA;
import edsim51sh.instructions.anl.AnlAddressData;
import edsim51sh.instructions.anl.AnlAreg;
import edsim51sh.instructions.anl.AnlCyBit;
import edsim51sh.instructions.anl.AnlCyNotBit;

public class Anl
extends Instruction {
    public Anl() {
        this.mneumonic = "ANL";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.startsWith("ANL A,")) {
            int registerNumber;
            if (mneumonic.startsWith("ANL A,#")) {
                return new AnlAdata();
            }
            if (mneumonic.length() == 8) {
                registerNumber = mneumonic.charAt(7) - 48;
                if (mneumonic.startsWith("ANL A,R") && mneumonic.charAt(7) >= '0' && mneumonic.charAt(7) <= '7') {
                    return new AnlAreg(registerNumber);
                }
            }
            if (mneumonic.length() >= 9) {
                registerNumber = mneumonic.charAt(8) - 48;
                if (mneumonic.equals("ANL A,@R0") || mneumonic.equals("ANL A,@R1")) {
                    return new AnlAatReg(registerNumber);
                }
            }
            return new AnlAaddress();
        }
        if (mneumonic.startsWith("ANL C,/")) {
            return new AnlCyNotBit();
        }
        if (mneumonic.startsWith("ANL C,")) {
            return new AnlCyBit();
        }
        if (mneumonic.endsWith(",A")) {
            return new AnlAddressA();
        }
        int hashIndex = mneumonic.indexOf(35);
        int commaIndex = mneumonic.indexOf(44);
        if (hashIndex > 5 && commaIndex > 4) {
            return new AnlAddressData();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

