/*
 * Decompiled with CFR 0.152.
 */
import java.util.prefs.Preferences;

final class Settings {
    StackMode stackMode;
    Mode mode;
    EnterMode enterMode;
    PasteParsingAlgorithm pasteParsingAlgorithm;
    boolean round;
    int roundLength;
    boolean truncateZeros;
    boolean arcAutorelease;
    boolean hypAutorelease;
    String customButtonCommand;
    private static final String prefsNodeName = "Calcoo";

    Settings(StackMode stackMode, Mode mode, EnterMode enterMode, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, PasteParsingAlgorithm pasteParsingAlgorithm, String string) {
        this.stackMode = stackMode;
        this.mode = mode;
        this.enterMode = enterMode;
        this.round = bl;
        this.roundLength = n;
        this.truncateZeros = bl2;
        this.arcAutorelease = bl3;
        this.hypAutorelease = bl4;
        this.pasteParsingAlgorithm = pasteParsingAlgorithm;
        this.customButtonCommand = string;
    }

    private static String cleanUpCustomCommand(String string) {
        String[] stringArray = string.trim().split(" +");
        if (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            Command command;
            try {
                command = Command.valueOf(stringArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            if (Command.invalidForCustomCommandSequence.contains((Object)command)) continue;
            stringBuilder.append((Object)command);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    static Settings load(int n) {
        String string;
        PasteParsingAlgorithm pasteParsingAlgorithm;
        EnterMode enterMode;
        Mode mode;
        StackMode stackMode;
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        try {
            stackMode = StackMode.valueOf(preferences.get("StackMode", Defaults.stackMode.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stackMode = Defaults.stackMode;
        }
        try {
            mode = Mode.valueOf(preferences.get("Mode", Defaults.mode.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mode = Defaults.mode;
        }
        try {
            enterMode = EnterMode.valueOf(preferences.get("EnterMode", Defaults.enterMode.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            enterMode = Defaults.enterMode;
        }
        boolean bl = preferences.getBoolean("Round", false);
        int n2 = preferences.getInt("RoundLength", n);
        if (n2 <= 0 || n2 > n) {
            n2 = n;
        }
        boolean bl2 = preferences.getBoolean("TruncateZeros", false);
        boolean bl3 = preferences.getBoolean("ArcAutorelease", true);
        boolean bl4 = preferences.getBoolean("HypAutorelease", true);
        try {
            pasteParsingAlgorithm = PasteParsingAlgorithm.valueOf(preferences.get("PasteParsingAlgorithm", Defaults.pasteParsingAlgorithm.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pasteParsingAlgorithm = Defaults.pasteParsingAlgorithm;
        }
        try {
            string = Settings.cleanUpCustomCommand(preferences.get("CustomButtonCommand", ""));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = "";
        }
        return new Settings(stackMode, mode, enterMode, bl, n2, bl2, bl3, bl4, pasteParsingAlgorithm, string);
    }

    void save() {
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        preferences.put("StackMode", this.stackMode.toString());
        preferences.put("Mode", this.mode.toString());
        preferences.put("EnterMode", this.enterMode.toString());
        preferences.putBoolean("Round", this.round);
        preferences.putInt("RoundLength", this.roundLength);
        preferences.putBoolean("TruncateZeros", this.truncateZeros);
        preferences.putBoolean("ArcAutorelease", this.arcAutorelease);
        preferences.putBoolean("HypAutorelease", this.hypAutorelease);
        preferences.put("PasteParsingAlgorithm", this.pasteParsingAlgorithm.toString());
        preferences.put("CustomButtonCommand", this.customButtonCommand);
    }

    static AngleUnits loadAngleUnits() {
        AngleUnits angleUnits;
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        try {
            angleUnits = AngleUnits.valueOf(preferences.get("AngleUnits", Defaults.angleUnits.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            angleUnits = Defaults.angleUnits;
        }
        return angleUnits;
    }

    static void saveAngleUnits(AngleUnits angleUnits) {
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        preferences.put("AngleUnits", angleUnits.toString());
    }

    static DisplayFormat loadDisplayFormat() {
        DisplayFormat displayFormat;
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        try {
            displayFormat = DisplayFormat.valueOf(preferences.get("DisplayFormat", Defaults.displayFormat.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            displayFormat = Defaults.displayFormat;
        }
        return displayFormat;
    }

    static void saveDisplayFormat(DisplayFormat displayFormat) {
        Preferences preferences = Preferences.userRoot().node(prefsNodeName);
        preferences.put("DisplayFormat", displayFormat.toString());
    }

    static enum DisplayFormat {
        FIX,
        SCI,
        ENG;

    }

    static enum AngleUnits {
        DEG,
        RAD;

    }

    private static class Defaults {
        static final StackMode stackMode = StackMode.INFINITE;
        static final Mode mode = Mode.ALG;
        static final EnterMode enterMode = EnterMode.TRADITIONAL;
        static final boolean round = false;
        static final boolean truncateZeros = false;
        static final boolean arcAutorelease = true;
        static final boolean hypAutorelease = true;
        static final AngleUnits angleUnits = AngleUnits.DEG;
        static final DisplayFormat displayFormat = DisplayFormat.FIX;
        static final PasteParsingAlgorithm pasteParsingAlgorithm = PasteParsingAlgorithm.LOCALE_BASED;
        static final String customButtonCommand = "";

        private Defaults() {
            throw new AssertionError((Object)"Defaults is a utility class.");
        }
    }

    private static class Names {
        static final String stackMode = "StackMode";
        static final String mode = "Mode";
        static final String enterMode = "EnterMode";
        static final String round = "Round";
        static final String roundLength = "RoundLength";
        static final String truncateZeros = "TruncateZeros";
        static final String arcAutorelease = "ArcAutorelease";
        static final String hypAutorelease = "HypAutorelease";
        static final String angleUnits = "AngleUnits";
        static final String displayFormat = "DisplayFormat";
        static final String pasteParsingAlgorithm = "PasteParsingAlgorithm";
        static final String customButtonCommand = "CustomButtonCommand";

        private Names() {
            throw new AssertionError((Object)"Names is a utility class.");
        }
    }

    static enum PasteParsingAlgorithm {
        LOCALE_BASED,
        HEURISTIC;

    }

    static enum EnterMode {
        TRADITIONAL,
        HP28;

    }

    static enum Mode {
        RPN,
        ALG;

    }

    static enum StackMode {
        XYZT,
        INFINITE;

    }
}

